/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.azure.base.ui.views.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Combo;

import com.clustercontrol.cloud.azure.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.azure.base.resources.CloudResourceProvider;
import com.clustercontrol.cloud.azure.base.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.azure.base.ui.dialogs.RestoreStorageDialog;
import com.clustercontrol.cloud.presenter.ICloudStorageBackup;
import com.clustercontrol.cloud.presenter.IAccountResource.IRegion;
import com.clustercontrol.cloud.ui.views.StorageBackupsView;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;

public class RestoreStorageAction extends SingleSelectionActionEx {
	private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
	
	private String msgRestoreStorageConfirm = messages.getString("message.confirm_some_action_to_something", new Object[]{"word.storage", "word.restore"});
	private String msgRestoreStorageResult = messages.getString("message.result_some_action_to_something", new Object[]{"word.storage", "word.restore"});


	@Override
	protected void invoke(IAction action) throws InvocationException {
		
		final StorageBackupsView view = (StorageBackupsView)viewPart;
		IRegion region = view.getActiveRegion();
		
		final ICloudStorageBackup backup = (ICloudStorageBackup)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
		
		if (region == null) {
			assert view.getCurrentAccountResource().getRegions().length > 0;
			region = view.getCurrentAccountResource().getRegions()[0];
		}
		
		final CloudResourceProvider provider = new CloudResourceProviderImpl(region.getAccountResource().getAccountResourceId());
		RestoreStorageDialog dialog = new RestoreStorageDialog(this.viewPart.getSite().getShell());
		
		com.clustercontrol.ws.azure.SnapShotInfo ssinfo = new com.clustercontrol.ws.azure.SnapShotInfo();
		ssinfo = provider.getSnapShotInfo(region.getRegion(), backup.getStorageBackupId(), backup.getStorageId());
		
		dialog.setCloudInfoProvider(provider);
		dialog.setSnapShotInfo(ssinfo);
		
		dialog.setBehavior(new RestoreStorageDialog.DialogBehavior(){
			@Override
			public void setupRegion(Combo cmbRegion) {
				super.setupRegion(cmbRegion);

				if (view != null && view.getActiveRegion() != null && cmbRegion.indexOf(view.getActiveRegion().getRegionName()) != -1) {
					cmbRegion.select(cmbRegion.indexOf(view.getActiveRegion().getRegionName()));
				} else if(cmbRegion.getItemCount() > 0) {
					cmbRegion.select(0);
				}
			}
		});
		
		if (dialog.open() == Window.OK) {
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				msgRestoreStorageConfirm)){

				RestoreStorageDialog.DialogData output = dialog.getOutput();
				output.setSourceDiskName(backup.getStorageId());
				
				output.setSnapShotInfo(ssinfo);
				
				
				provider.restoreStorage(region.getRegion(), output);
				
				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					msgRestoreStorageResult);
			}
			else {
				return;
			}
		}
	}
	
	@Override
	public void selectionChanged(IAction action, ISelection selection) {
		super.selectionChanged(action, selection);
		ICloudStorageBackup backup = (ICloudStorageBackup)((IStructuredSelection)selection).getFirstElement();
		if(backup == null || backup.getRestoreStatus() == null || backup.getRestoreStatus().equals(ICloudStorageBackup.RestoreStatus.unavailable.name())){
			action.setEnabled(false);
		}
	}
}