/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.azure.base.ui.views.actions;


import java.util.Iterator;
import java.util.List;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;

import com.clustercontrol.cloud.azure.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.azure.base.resources.CloudResourceProvider;
import com.clustercontrol.cloud.azure.base.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.azure.base.ui.dialogs.AttachStorageFromStorageDialog;
import com.clustercontrol.cloud.presenter.ICloudStorage;
import com.clustercontrol.cloud.presenter.IAccountResource.IRegion;
import com.clustercontrol.cloud.ui.views.StoragesView;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.azure.AzureCreateStorageRequest;
import com.clustercontrol.ws.azure.InstanceInfo;


public class AttachStorageFromStorageAction extends SingleSelectionActionEx {
	private MessageManagerExt messages = MessageManagerExt.getInstance("messages");

	private String msgAttachStorageConfirm = messages.getString("message.confirm_some_action_to_subjects", new Object[]{"word.storage", "word.attach"});
	private String msgAttachStorageResult = messages.getString("message.some_command_has_been_accepted", new Object[]{"word.storage", "word.attach"});


	@Override
	protected void invoke(IAction action) throws InvocationException {

		final StoragesView view = (StoragesView)viewPart;
		IRegion region = view.getActiveRegion();


		if (region == null) {
			assert view.getCurrentAccountResource().getRegions().length > 0;
			region = view.getCurrentAccountResource().getRegions()[0];
		}

		ICloudStorage storage = (ICloudStorage)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
		AttachStorageFromStorageDialog dialog = new AttachStorageFromStorageDialog(this.viewPart.getSite().getShell(), storage);

		ICloudStorage[] iCloudStorage = storage.getCloudStorageManager().getCloudStorages();
		int diskSize=0;
		for(int i=0; i<iCloudStorage.length; i++){
			if(iCloudStorage[i].getStorageAttachment() != null){
				diskSize += iCloudStorage[i].getSize();
			}
		}
		dialog.setDiskSize(diskSize);
		final CloudResourceProvider provider = new CloudResourceProviderImpl(region.getAccountResource().getAccountResourceId());
		String cui = view.getCurrentAccountResource().getActiveUser().getCloudUserId();
		String ak = view.getCurrentAccountResource().getCloudUserManager().getCloudUser(cui).getAccessKey();
		String rg = region.getRegion();
		String cloudServiceName = "";
		cloudServiceName = view.getActiveZone()==null?"":view.getActiveZone();
		cloudServiceName = storage.getZone()==null?"":storage.getZone();
		List<InstanceInfo> instanceInfo = provider.getInstanceByCloudService(rg, cloudServiceName);
		dialog.setSubscriptionId(ak);
		dialog.setInstanceInfo(instanceInfo);
		dialog.setCloudService(cloudServiceName);

		if(dialog.open() == Window.OK){
			if (MessageDialog.openConfirm(
					null,
					Messages.getString("confirmed"),
					msgAttachStorageConfirm + "\n" + storage.getStorageId())){

				//storage.attach(dialog.getInstanceId(), dialog.getDeviceName());

				AzureCreateStorageRequest request = new AzureCreateStorageRequest();
				request.setVirtualHardDiskHostCaching(dialog.getHostCaching());
				request.setInstanceName(dialog.getInstanceId());
				request.setLUN(dialog.getLun());
				request.setCloudServiceName(cloudServiceName);
				
				provider.atachStorage(rg, request.getInstanceName(), storage.getStorageId(), request);
				
				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					msgAttachStorageResult);
			}
		}
	}

	protected boolean canEnabled(IStructuredSelection selection) {
		Iterator<?> iter = selection.iterator();
		while (iter.hasNext()) {
			ICloudStorage storage = (ICloudStorage)iter.next();

			if (storage.getStorageAttachment() != null || storage.getRegistState().equals(ICloudStorage.RegistStateType.deleted.name())) {
				return false;
			}
		}
		return true;
	}
}