/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.azure.base.ui.views.actions;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;

import com.clustercontrol.cloud.azure.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.azure.base.resources.CloudResourceProvider;
import com.clustercontrol.cloud.azure.base.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.azure.base.ui.dialogs.AttachStorageFromInstanceDialog;
import com.clustercontrol.cloud.presenter.ICloudInstance;
import com.clustercontrol.cloud.presenter.IAccountResource.IRegion;
import com.clustercontrol.cloud.ui.views.InstancesView;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.azure.AzureCreateStorageRequest;
import com.clustercontrol.ws.azure.DataVirtualHardDisks;
import com.clustercontrol.ws.azure.InstanceInfo;

public class AttachStorageFromInstanceAction extends SingleSelectionActionEx {
	private MessageManagerExt messages = MessageManagerExt.getInstance("messages");

	private String msgAttachStorageConfirm = messages.getString("message.confirm_some_action_to_subjects", new Object[]{"word.storage", "word.attach"});
	private String msgAttachStorageResult = messages.getString("message.some_command_has_been_accepted", new Object[]{"word.storage", "word.attach"});

	@Override
	protected void invoke(IAction action) throws InvocationException {
		ICloudInstance instance = (ICloudInstance)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
		AttachStorageFromInstanceDialog dialog = new AttachStorageFromInstanceDialog(this.viewPart.getSite().getShell(), instance);

		final InstancesView view = (InstancesView)viewPart;
		String cui = instance.getCloudUserId();
		String ak = view.getCurrentAccountResource().getCloudUserManager().getCloudUser(cui).getAccessKey();
		IRegion region = view.getActiveRegion();
		final CloudResourceProvider provider = new CloudResourceProviderImpl(region.getAccountResource().getAccountResourceId());
		String rg = region.getRegion();
		String ii = instance.getInstanceId();
		List<DataVirtualHardDisks> dvhds =provider.getDataVirtualHardDisk(rg, ii);
		List<InstanceInfo> instances = provider.getInstanceByCloudService(rg, instance.getZone());
		
		List<String> luns = new ArrayList<>();
		for(InstanceInfo instanceinfo:instances){
			if(instanceinfo.getInstanceName().equals(ii)){
				for(int i=0;i<=15;i++){
					if(!instanceinfo.getAttachedLun().contains(i)){
						luns.add(Integer.toString(i));
					}
				}
			}
		}
		
		dialog.setLuns(luns);
		dialog.setSubscriptionId(ak);
		dialog.setDataVirtualHardDisks(dvhds);

		//List<String> sa = provider.getStorageAccountByCloudService(rg, view.getActiveZone());

		//dialog.setStorageAccountName(sa.get(0));
		if(dialog.open() == Window.OK){

			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				msgAttachStorageConfirm+"\n"+dialog.getStorageId())){

				//instance.attachStorage(dialog.getStorageId(), dialog.getDeviceName());
				
				AzureCreateStorageRequest request = new AzureCreateStorageRequest();
				request.setVirtualHardDiskHostCaching(dialog.getHostCaching());
				request.setInstanceName(ii);
				request.setLUN(dialog.getLun());
				request.setCloudServiceName(instance.getZone());
				
				provider.atachStorage(rg, request.getInstanceName(), dialog.getStorageId(), request);

				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					msgAttachStorageResult);
			}
			else {
				return;
			}
		}
	}

	protected boolean canEnabled(IStructuredSelection selection) {
		ICloudInstance instance = (ICloudInstance)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
		if (instance.getRegistState().equals(ICloudInstance.RegistStateType.deleted.name())) {
			return false;
		}
		return true;
	}
}