/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.azure.base.ui.dialogs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import com.clustercontrol.cloud.azure.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.azure.base.resources.AvailabilityZone;
import com.clustercontrol.cloud.azure.base.resources.CloudResourceProvider;
import com.clustercontrol.cloud.azure.base.resources.EndPointInfo;
import com.clustercontrol.cloud.azure.base.resources.InstanceTypeInfo;
import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.presenter.CreateCloudInstanceRequest;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.azure.AzureImage;
import com.clustercontrol.ws.azure.EndPoint;
import com.clustercontrol.cloud.presenter.TemplateJobsArgument;

public class CreateInstanceDialog extends Dialog {
	public static class EbsBlockDevice {
		public Integer volumeSize;
		public Boolean deleteOnTermination;
		public String volumeType;
		public Integer iops;
	}

	public static class InstanceDetail {
		public List<String> securityGroupIds = new ArrayList<>();
		public String keyName;
		public Boolean monitoring;
		public Boolean disableApiTermination;
		public String instanceInitiatedShutdownBehavior;
		public Boolean ebsOptimized;
		public EbsBlockDevice rootBlockDevice;
	}

	public static class Model extends CreateCloudInstanceRequest implements Serializable{
		private static final long serialVersionUID = -8364801407665470030L;
		private String regionName;
		private String cloudServiceName;
		private String storageAccountName;
		private String containerName;
		private String sizeName;
		private String newUserName;
		private String password;
		private String rePassword;
		private String templateId;
		private List<TemplateJobsArgument> arguments;
		private Boolean isAvailabilitySet = false;
		private List<EndPoint> endPoint;
		private AzureImage azureImage;
		private String availabilitySetNmae;
		private Boolean isRestore = false;
		
		public String getRegionName() {
			return this.regionName;
		}

		public void setRegionName(String regionName) {
			this.regionName = regionName;
		}
		
		public String getCloudServiceName() {
			return this.cloudServiceName;
		}

		public void setCloudServiceName(String cloudServiceName) {
			this.cloudServiceName = cloudServiceName;
		}

		public String getStorageAccountName() {
			return this.storageAccountName;
		}

		public void setStorageAccountName(String storageAccountName) {
			this.storageAccountName = storageAccountName;
		}
		
		public String getContainerName(){
			return this.containerName;
		}
		
		public void setContainerName(String containerName){
			this.containerName = containerName;
		}

		public String getSize() {
			return this.sizeName;
		}

		public void setSize(String sizeName) {
			this.sizeName = sizeName;
		}

		public String getNewUserName() {
			return this.newUserName;
		}

		public void setNewUserName(String newUserName) {
			this.newUserName = newUserName;
		}

		public String getPassword() {
			return this.password;
		}

		public void setPassword(String password) {
			this.password = password;
		}

		public String getRePassword() {
			return this.rePassword;
		}

		public void setRePassword(String rePassword) {
			this.rePassword = rePassword;
		}

		public void setAzureImage(AzureImage azureImage){
			this.azureImage = azureImage;
		}
		
		public AzureImage getAzureImage(){
			return this.azureImage;
		}
		
		public boolean isRestore(){
			return this.isRestore;
		}
		
		public void setIsRestore(boolean isRestore){
			this.isRestore = isRestore;
		}

		public String getTemplateId() {
			return this.templateId;
		}

		public void setTemplateId(String templateId) {
			this.templateId = templateId;
		}

		public List<TemplateJobsArgument> getArguments() {
			return this.arguments;
		}

		public void setArguments(List<TemplateJobsArgument> arguments) {
			this.arguments = arguments;
		}

		public Boolean getIsAvailabilitySet() {
			return this.isAvailabilitySet;
		}

		public void setIsAvailabilitySet(Boolean isAvailabilitySet) {
			this.isAvailabilitySet = isAvailabilitySet;
		}

		public List<EndPoint> getEndPoint() {
			return this.endPoint;
		}

		public void setEndPoint(List<EndPoint> endPoint) {
			this.endPoint = endPoint;
		}

		public String getAvailabilitySetNmae(){
			return this.availabilitySetNmae;
		}
		
		public void setAvailabilitySetNmae(String AvailabilitySetNmae){
			this.availabilitySetNmae = AvailabilitySetNmae;
		}
		
		public Model deepCopy() {
//			return ControlUtil.deepCopy(this);
			return this;
		}
	}

	interface IDialogBehavior {
		void setInput(Model input);
		void setProvider(CloudResourceProvider provider);

		void setupFacilityId(Text facilityId);
		void setupFacilityName(Text facilityName);
		void setupReplaceNode(Button btnReplaceNode);
		void setupDescription(Text description);
		void setupNodeName(Text nodeName);
		void setupCloudService(Combo cloudService);
		void setupStorageAccount(Combo storageAccount);
		void setupSize(Combo size);
		void setupNewUserName(Text newUserName);
		void setupPassword(Text password);
		void setupRePassword(Text rePassword);
		void setupSelectImageFlg(Button rdoAmi, Button rdoTemplate);
		void setupImage(Text image, Button selectImage);
		void setupTemplate(Button availabilitySet, Combo template, Button editArgument);
		void setupDetailSettings(Button detailSettings);
		void setupAvailabilityZone(Combo cmbAvailabilityZone);

	}

	public static class DialogBehavior implements IDialogBehavior{
		protected MessageManagerExt messages = MessageManagerExt.getInstance("messages");
		protected CloudResourceProvider provider;
		protected Model input;

		public void setInput(Model input){
			this.input = input;
		};
		public void setProvider(CloudResourceProvider provider){
			this.provider = provider;
		};

		public void setupFacilityId(Text facilityId){};
		public void setupFacilityName(Text facilityName){};
		public void setupReplaceNode(Button btnReplaceNode){};
		public void setupDescription(Text description){};
		public void setupNodeName(Text nodeName){};
		public void setupCloudService(Combo cloudService){};
		public void setupStorageAccount(Combo storageAccount){};
		public void setupSize(Combo size){};
		public void setupNewUserName(Text newUserName){};
		public void setupPassword(Text password){};
		public void setupRePassword(Text RePassword){};
		public void setupSelectImageFlg(Button rdoAmi, Button rdoTemplate){};
		public void setupImage(Text image, Button selectImage){};
		public void setupTemplate(Button useTemplate, Combo template, Button editArgument){};
		public void setupDetailSettings(Button detailSettings){};
		public void setupAvailabilityZone(Combo cmbAvailabilityZone) {}
		public void setupRegion(final Combo cmbRegion) {}

	}

	private MessageManagerExt messages = MessageManagerExt.getInstance("messages");

	private String strSeparator = messages.getString("caption.title_separator");
	private String strNodeInfo = messages.getString("word.node_info");
	private String strFacilityId = messages.getString("word.facility_id");
	private String strNodeReplaceDescription = messages.getString("caption.node_replace_description");
	private String strFacilityName = messages.getString("word.facility_name");
	private String strDescription = messages.getString("word.description");
	private String strNodeName = messages.getString("word.node_name");
	private String strInstanceInfo = messages.getString("word.instance_info");
	private String strCloudService = messages.getString("word.cloud_service");
	private String strStorageAccount = messages.getString("word.storage_account");
	private String strContainerName = messages.getString("word.container_name");
	private String strSize = messages.getString("word.size");
	private String strNewUserName = messages.getString("word.new_user_name");
	private String strPassword = messages.getString("word.password");
	private String strRePassword = messages.getString("word.re_password");
	private String strImage = messages.getString("word.image");
	private String strRefer = messages.getString("word.refer");
	private String strEndPoint = messages.getString("word.end_point");
	private String strAvailabilitySet = messages.getString("word.availability_set");
	private String strAvailabilitySetName = messages.getString("word.availability_set_name");
	private String strCreateInstanceDialog = messages.getString("caption.create_instance_dialog");
	//private String strAssginScope = messages.getString("word.assgin_scope_id");

	private Shell shell;

	private Text facilityId;
	private Button btnReplaceNode;
	private Text facilityName;
	private Text description;
	private Text nodeName;
	private Combo cmbCloudService;
	private Combo cmbStorageAccount;
	private Combo cmbContainer;
	private Combo cmbSize;
	private Text newUserName;
	private Text password;
	private Text rePassword;
	private Text txtIMAGE;
	private Button btnAvailabilitySet;
	private Text txtAvailabilitySetName;

	private Button btnSelectIMAGE;

	private CloudResourceProvider provider;

	private Model input;
	private Model output = new Model();

	private IDialogBehavior behavior = new DialogBehavior();

	private List<AvailabilityZone> cloudServices = new ArrayList<>();
	private List<EndPoint> endPoint = new ArrayList<>();
	private String regionName = "";
	private Label lblIMAGE;
	private Label lblAvailabilitySet;
	private Label lblAvailabilitySetName;
	//private Label lblAssign;

	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public CreateInstanceDialog(Shell parentShell){
		super(parentShell);
		this.shell = parentShell;
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.NONE);
		container.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));
		GridLayout gl_container = new GridLayout(1, false);
		container.setLayout(gl_container);
		GridData gd_container = new GridData(GridData.FILL_BOTH);
		gd_container.widthHint = 614;
		container.setLayoutData(gd_container);

		Group grpNodeInfo = new Group(container, SWT.NONE);
		grpNodeInfo.setText(strNodeInfo + strSeparator);
		GridLayout gl_grpNodeInfo = new GridLayout(2, false);
		gl_grpNodeInfo.verticalSpacing = 9;
		gl_grpNodeInfo.horizontalSpacing = 15;
		grpNodeInfo.setLayout(gl_grpNodeInfo);
		grpNodeInfo.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 5, 1));

		Label lblid = new Label(grpNodeInfo, SWT.RIGHT);
		lblid.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblid.setText(strFacilityId + strSeparator);

		facilityId = new Text(grpNodeInfo, SWT.BORDER);
		facilityId.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		new Label(grpNodeInfo, SWT.NONE);

		btnReplaceNode = new Button(grpNodeInfo, SWT.CHECK);
		btnReplaceNode.setText(strNodeReplaceDescription);

		Label lblFacilityName = new Label(grpNodeInfo, SWT.RIGHT);
		lblFacilityName.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblFacilityName.setText(strFacilityName + strSeparator);

		facilityName = new Text(grpNodeInfo, SWT.BORDER);
		facilityName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));

		Label lblDescription = new Label(grpNodeInfo, SWT.RIGHT);
		lblDescription.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblDescription.setText(strDescription + strSeparator);

		description = new Text(grpNodeInfo, SWT.BORDER);
		description.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));

		Label lblNodeName = new Label(grpNodeInfo, SWT.RIGHT);
		lblNodeName.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblNodeName.setText(strNodeName + strSeparator);

		nodeName = new Text(grpNodeInfo, SWT.BORDER);
		GridData gd_nodeName = new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1);
		gd_nodeName.widthHint = 66;
		nodeName.setLayoutData(gd_nodeName);

		Group grpInstacneInfo = new Group(container, SWT.NONE);
		grpInstacneInfo.setText(strInstanceInfo);
		GridLayout gl_grpInstacneInfo = new GridLayout(3, false);
		gl_grpInstacneInfo.verticalSpacing = 9;
		gl_grpInstacneInfo.horizontalSpacing = 15;
		grpInstacneInfo.setLayout(gl_grpInstacneInfo);
		GridData gd_grpInstacneInfo = new GridData(SWT.FILL, SWT.CENTER, false, false, 5, 1);
		gd_grpInstacneInfo.heightHint = 370;
		grpInstacneInfo.setLayoutData(gd_grpInstacneInfo);

		Label lblCloudService = new Label(grpInstacneInfo, SWT.RIGHT);
		lblCloudService.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblCloudService.setText(strCloudService + strSeparator);

		cmbCloudService = new Combo(grpInstacneInfo, SWT.READ_ONLY);
		for(AvailabilityZone az : cloudServices){
			cmbCloudService.add(az.getZoneName());
		}
		cmbCloudService.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		cmbCloudService.addSelectionListener(new SelectionListener(){
			public void widgetDefaultSelected(SelectionEvent e){
			}
			public void widgetSelected(SelectionEvent e){
			    Combo bCombo = (Combo)e.widget;
			    cmbStorageAccount.removeAll();
			    List<String> storageAccounts = provider.getStorageAccountByCloudService(regionName,bCombo.getItem(bCombo.getSelectionIndex()));
			    for(String storageAccountName : storageAccounts){
			    	cmbStorageAccount.add(storageAccountName);
			    }
			}
		});

		Label lblStorageAccount = new Label(grpInstacneInfo, SWT.RIGHT);
		lblStorageAccount.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblStorageAccount.setText(strStorageAccount + strSeparator);

		cmbStorageAccount = new Combo(grpInstacneInfo, SWT.READ_ONLY);
		cmbStorageAccount.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		cmbStorageAccount.addSelectionListener(new SelectionListener(){
			public void widgetDefaultSelected(SelectionEvent e){
			}
			public void widgetSelected(SelectionEvent e){
				Combo bCombo = (Combo)e.widget;
				cmbContainer.removeAll();
				List<String> containers = provider.getContainerByStorageAccount(regionName, bCombo.getItem(bCombo.getSelectionIndex()));
				for(String container: containers){
					cmbContainer.add(container);
				}
			}
		});
		
		Label lblContainerName = new Label(grpInstacneInfo, SWT.RIGHT);
		lblContainerName.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblContainerName.setText(strContainerName + strSeparator);
		
		cmbContainer = new Combo(grpInstacneInfo, SWT.READ_ONLY);
		cmbContainer.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));

		Label lblSize = new Label(grpInstacneInfo, SWT.RIGHT);
		lblSize.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblSize.setText(strSize + strSeparator);

		cmbSize = new Combo(grpInstacneInfo, SWT.READ_ONLY);
		cmbSize.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		cmbSize.setItems(InstanceTypeInfo.storageSize);

		Label lblNewUserName = new Label(grpInstacneInfo, SWT.RIGHT);
		lblNewUserName.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblNewUserName.setText(strNewUserName + strSeparator);

		newUserName = new Text(grpInstacneInfo, SWT.BORDER);
		newUserName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 2, 1));

		Label lblPassword = new Label(grpInstacneInfo, SWT.RIGHT);
		lblPassword.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblPassword.setText(strPassword + strSeparator);

		password = new Text(grpInstacneInfo, SWT.BORDER | SWT.PASSWORD);
		password.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 2, 1));

		Label lblRePassword = new Label(grpInstacneInfo, SWT.RIGHT);
		lblRePassword.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblRePassword.setText(strRePassword + strSeparator);

		rePassword = new Text(grpInstacneInfo, SWT.BORDER | SWT.PASSWORD);
		rePassword.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 2, 1));

		lblIMAGE = new Label(grpInstacneInfo, SWT.NONE);
		lblIMAGE.setAlignment(SWT.RIGHT);
		lblIMAGE.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblIMAGE.setText(strImage + strSeparator);

		txtIMAGE = new Text(grpInstacneInfo, SWT.BORDER | SWT.READ_ONLY);
		txtIMAGE.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		if(output.isRestore()){
			txtIMAGE.setText(output.getAzureImage().getImageId());
			
			EndPointInfo epinfo = new EndPointInfo();
			if(endPoint.size() == 0 && output.getAzureImage().getOStype().toLowerCase().equals("windows")){
				endPoint.addAll(epinfo.getWindowsDefaultEndPoint());
			}
			else if(endPoint.size() == 0 && output.getAzureImage().getOStype().toLowerCase().equals("linux")){
				endPoint.addAll(epinfo.getLinuxDefaultEndPoint());
			}
		}

		btnSelectIMAGE = new Button(grpInstacneInfo, SWT.NONE);
		btnSelectIMAGE.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		btnSelectIMAGE.setText(strRefer);

		if(output.isRestore()){
			btnSelectIMAGE.setEnabled(false);
		}else{
			btnSelectIMAGE.addSelectionListener(new SelectionAdapter(){
				@Override
				public void widgetSelected(SelectionEvent e) {
					SelectVMIDialog dialog = new SelectVMIDialog(shell);
					dialog.setCloudInfoProvider(provider);
					dialog.setRegion(regionName);
					dialog.open();

					if (dialog.getReturnCode() == Window.OK) {
						AzureImage image = dialog.getOutput();
						txtIMAGE.setText("("+image.getImageId()+") "+image.getName());
						txtIMAGE.setData(image);
						output.setAzureImage(image);
						
						EndPointInfo epinfo = new EndPointInfo();
						if(endPoint.size() == 0 && image.getOStype().toLowerCase().equals("windows")){
							endPoint.addAll(epinfo.getWindowsDefaultEndPoint());
						}
						else if(endPoint.size() == 0 && image.getOStype().toLowerCase().equals("linux")){
							endPoint.addAll(epinfo.getLinuxDefaultEndPoint());
						}
					}
				}
			});
		}
		
		lblAvailabilitySet = new Label(grpInstacneInfo, SWT.NONE);
		lblAvailabilitySet.setAlignment(SWT.RIGHT);
		lblAvailabilitySet.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblAvailabilitySet.setText(strAvailabilitySet + strSeparator);

		btnAvailabilitySet = new Button(grpInstacneInfo, SWT.CHECK);
		btnAvailabilitySet.addSelectionListener(new SelectionListener(){
			@Override
			public void widgetDefaultSelected(SelectionEvent e) {
			}

			@Override
			public void widgetSelected(SelectionEvent e) {
				Button bCombo = (Button)e.widget;
			    if(bCombo.getSelection()){
			    	txtAvailabilitySetName.setEnabled(true);
			    }else{
			    	txtAvailabilitySetName.setEnabled(false);
			    }
			}
		});
		btnAvailabilitySet.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 2, 1));
		btnAvailabilitySet.setAlignment(SWT.RIGHT);
	
		lblAvailabilitySetName = new Label(grpInstacneInfo, SWT.NONE);
		lblAvailabilitySetName.setAlignment(SWT.RIGHT);
		lblAvailabilitySetName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblAvailabilitySetName.setText(strAvailabilitySetName + strSeparator);
		
		txtAvailabilitySetName = new Text(grpInstacneInfo, SWT.BORDER);
		txtAvailabilitySetName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 2, 1));
		txtAvailabilitySetName.setEnabled(false);
		
		/*lblAssign = new Label(grpInstacneInfo, SWT.NONE);
		lblAssign.setAlignment(SWT.RIGHT);
		lblAssign.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblAssign.setText(strAssginScope + strSeparator);
		
		txtAssign = new Text(grpInstacneInfo, SWT.BORDER);
		txtAssign.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 2, 1));*/
		
		new Label(grpInstacneInfo, SWT.NONE);
		new Label(grpInstacneInfo, SWT.NONE);
		
		Button btnEndPointSettings = new Button(grpInstacneInfo, SWT.NONE);
		btnEndPointSettings.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		btnEndPointSettings.setText(strEndPoint);
		
		new Label(grpInstacneInfo, SWT.NONE);
		new Label(grpInstacneInfo, SWT.NONE);
		new Label(grpInstacneInfo, SWT.NONE);
		new Label(grpInstacneInfo, SWT.NONE);
		

		btnEndPointSettings.addSelectionListener(new SelectionAdapter(){
			@Override
			public void widgetSelected(SelectionEvent e) {
				RegistEndPointDialog dialog = new RegistEndPointDialog(shell);
				output.setFacilityName(facilityName.getText());
				dialog.setEndPoint(endPoint);
				if(output.getAzureImage()!=null){
					dialog.setOStype(output.getAzureImage().getOStype());
				}
				if (dialog.open() == Window.OK) {
					endPoint = dialog.getEndPoint();
				}
			}
		});

		ControlUtil.setRequired(new Control[]{facilityId, facilityName, nodeName});

		{
			behavior.setInput(input);
			behavior.setProvider(provider);
			behavior.setupFacilityId(facilityId);
			behavior.setupReplaceNode(btnReplaceNode);
			behavior.setupFacilityName(facilityName);
			behavior.setupDescription(description);
			behavior.setupNodeName(nodeName);
			behavior.setupCloudService(cmbCloudService);
			behavior.setupStorageAccount(cmbStorageAccount);
			behavior.setupSize(cmbSize);
			behavior.setupDetailSettings(btnEndPointSettings);
			behavior.setupImage(txtIMAGE, btnSelectIMAGE);
		}

		// 項目名の幅をグループ間で一致させる。
		container.layout();
		Control[] labels = new Control[]{lblid, lblFacilityName, lblDescription, lblNodeName, lblCloudService, lblStorageAccount, lblSize, lblIMAGE, lblAvailabilitySet};
		int maxWidth = 0;
		for (Control l: labels) {
			Point p = l.getSize();
			maxWidth = Math.max(maxWidth, p.x);
		}
		for (Control l: labels) {
			((GridData)l.getLayoutData()).widthHint = maxWidth;
		}
		grpNodeInfo.layout(true);
		grpInstacneInfo.layout(true);

		return area;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				false);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(640, 690);
	}

	@Override
	protected void okPressed() {
		if (
			facilityId.getText().equals("") ||
			facilityName.getText().equals("") ||
			nodeName.getText().equals("") ||
			cmbCloudService.getText().equals("") ||
			cmbStorageAccount.getText().equals("") ||
			cmbSize.getText().equals("") ||
			(!btnAvailabilitySet.getSelection() && txtIMAGE.getText().equals(""))
			){
			MessageDialog.openError(null,
					Messages.getString("failed"),
					messages.getString("message.must_fully_input"));
			return;
		}
		
		String nodeNameVal = nodeName.getText();
		
		if(nodeNameVal.substring(0, 1).matches(".*[^a-zA-Z].*")
			|| nodeNameVal.substring(nodeNameVal.length()-1).matches(".*[^0-9a-zA-Z].*")
			|| (nodeNameVal.matches(".*[^-0-9a-zA-Z].*"))){
			MessageDialog.openError(null,
					Messages.getString("failed"),
					messages.getString("message.unmatcch_name_rule"));
			return;
		}
		
		
		if(!password.getText().equals(rePassword.getText())){
			MessageDialog.openError(null,
					Messages.getString("failed"),
					messages.getString("message.unmatch_password"));
			return;
		}
		
		int password_chk=0;
		if(password.getText().matches(".*[A-Z].*")){password_chk+=1;}
		if(password.getText().matches(".*[a-z].*")){password_chk+=1;}
		if(password.getText().matches(".*[0-9].*")){password_chk+=1;}
		if(password.getText().matches(".*[^0-9a-zA-Z].*")){password_chk+=1;}
		
		if(password_chk<3){
			MessageDialog.openError(null,
					Messages.getString("failed"),
					messages.getString("message.unmatch_rule"));
			return;
		}
		
		if(password.getText().length()<8){
			MessageDialog.openError(null,
					Messages.getString("failed"),
					messages.getString("message.too_short"));
			return;
		}
		
		output.setCloudServiceName(cmbCloudService.getText());
		output.setStorageAccountName(cmbStorageAccount.getText());
		output.setSize(cmbSize.getText());
		output.setFacilityId(facilityId.getText());
		output.setFacilityName(facilityName.getText());
		output.setDescription(description.getText());
		output.setNodeName(nodeName.getText());
		output.setReplaceNode(btnReplaceNode.getSelection());
		output.setNewUserName(newUserName.getText());
		output.setPassword(password.getText());
		output.setRePassword(rePassword.getText());
		output.setImageId(output.getAzureImage().getImageId());
		output.setIsAvailabilitySet(btnAvailabilitySet.getSelection());
		output.setEndPoint(endPoint);
		output.setAvailabilitySetNmae(txtAvailabilitySetName.getText());
		output.setContainerName(cmbContainer.getText());
		output.setRegionName(this.regionName);
		//output.setAssginScopeID(txtAssign.getText());

		setReturnCode(OK);
		close();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(strCreateInstanceDialog);
	}

	public void setInput(Model input) {
		assert input != null;
		this.input = input;
		output = input.deepCopy();
	}

	public CreateInstanceDialog.Model getOutput() {
		return output;
	}

	public void setCloudInfoProvider(CloudResourceProvider provider) {
		this.provider = provider;
	}

	public void setBehavior(IDialogBehavior behavior){
		this.behavior = behavior;
	}

	public void setupCloudService(List<AvailabilityZone> cloudServices){
		this.cloudServices = cloudServices;
	}

	public void setCurrentRegion(String regionName){
		this.regionName = regionName;
	}

}
