/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.azure.base.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import com.clustercontrol.cloud.azure.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.presenter.ICloudInstance;
import com.clustercontrol.util.Messages;

public class CreateInstanceBackupDialog extends Dialog {
	private MessageManagerExt messages = MessageManagerExt.getInstance("messages");

	private String strSeparator = messages.getString("caption.title_separator");
	private String strVirtualMachineName = messages.getString("word.instance_name");
	private String strDescription = messages.getString("word.description");
	private String strBackupInstanceDialog = messages.getString("caption.backup_instance_dialog");
	private String strImageName = messages.getString("word.image_name");
	private String msgMustFullyInput = messages.getString("message.must_fully_input");
	private String strWithAddVolume = messages.getString("caption.with_add_volume");

	private ICloudInstance instance;

	private Text txtImageName;
	private Text txtDescription;
	private Text txtInstanceName;
	private Button btnWithEbsVolume;

	private String imageName;
	private String description;
	private boolean isAddVolume;

	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public CreateInstanceBackupDialog(Shell parentShell, ICloudInstance instance) {
		super(parentShell);
		this.instance = instance;
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.NONE);
		container.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));
		GridLayout gl_container = new GridLayout(2, false);
		gl_container.horizontalSpacing = 16;
		container.setLayout(gl_container);
		GridData gd_container = new GridData(GridData.FILL_BOTH);
		gd_container.widthHint = 614;
		container.setLayoutData(gd_container);

		Label lblVirtualMachineName = new Label(container, SWT.NONE);
		lblVirtualMachineName.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblVirtualMachineName.setText(strVirtualMachineName + strSeparator);

		txtInstanceName = new Text(container, SWT.BORDER | SWT.READ_ONLY);
		txtInstanceName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		txtInstanceName.setText(instance.getInstanceName());

		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);

		Label lblName = new Label(container, SWT.NONE);
		lblName.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblName.setText(strImageName + strSeparator);

		txtImageName = new Text(container, SWT.BORDER);
		GridData gd_name = new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1);
		gd_name.widthHint = 203;
		txtImageName.setLayoutData(gd_name);

		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);

		Label lblDescription = new Label(container, SWT.NONE);
		lblDescription.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblDescription.setText(strDescription + strSeparator);

		txtDescription = new Text(container, SWT.BORDER | SWT.V_SCROLL);
		GridData gd_Description = new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1);
		gd_Description.widthHint = 146;
		gd_Description.heightHint = 146;
		txtDescription.setLayoutData(gd_Description);
		
		new Label(container, SWT.NONE);
		new Label(container, SWT.NONE);
		
		Label lblWithEbsVolume = new Label(container, SWT.NONE);
		lblWithEbsVolume.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblWithEbsVolume.setText(strWithAddVolume + strSeparator);

		btnWithEbsVolume = new Button(container, SWT.CHECK);
		
		return area;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				false);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(640, 400);
	}

	@Override
	protected void okPressed() {
		if("".equals(txtImageName.getText())){
			MessageDialog.openError(null,
					Messages.getString("failed"),
					msgMustFullyInput);
			return;
		}

		imageName = txtImageName.getText();
		description = txtDescription.getText();
		isAddVolume = btnWithEbsVolume.getSelection();

		setReturnCode(OK);
		close();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(strBackupInstanceDialog);
	}

	public String getImageName() {
		return this.imageName;
	}

	public String getDescription() {
		return this.description;
	}
	
	public boolean isContainAddVolume(){
		return this.isAddVolume;
	}

}
