/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.azure.base.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import com.clustercontrol.cloud.azure.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.presenter.ICloudInstance;
import com.clustercontrol.cloud.presenter.ICloudStorage;
import com.clustercontrol.ws.azure.DataVirtualHardDisks;
import com.clustercontrol.ws.azure.VirtualHardDiskHostCaching;

public class AttachStorageFromInstanceDialog extends Dialog {
	private MessageManagerExt messages = MessageManagerExt.getInstance("messages");

	private String strInstance = messages.getString("word.instance");
	private String strLun = messages.getString("word.lun");
	private String strHostCacheConfig = messages.getString("word.host_cache_config");
	private String strHostCacheNone = messages.getString("word.host_cache_none");
	private String strHostCacheReadOnly = messages.getString("word.host_cache_read_only");
	private String strHostCacheReadWrite = messages.getString("word.host_cache_read_write");
	private String strDiscName = messages.getString("word.disc_name");
	private String strOs = messages.getString("word.os");
	private String strSubscription = messages.getString("word.subscription");
	private String strSpot = messages.getString("word.spot");
	private String strAttachStorageDialog = messages.getString("caption.attach_storage_dialog");

	private ICloudInstance instance;
	private Table table;
	private Text instanceName;
	private Combo cmblun;
	private Button btnHostCacheNone;
	private Button btnHostCacheReadOnly;
	private Button btnHostCacheReadWrite;

	private String storageId;
	private String deviceName;

	List<String> luns;
	String subscriptionId;
	List<DataVirtualHardDisks> dataVirtualHardDisks;
	String uri;
	String storageAccountName;
	VirtualHardDiskHostCaching hostCache;
	Integer lun;

	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public AttachStorageFromInstanceDialog(Shell parentShell, ICloudInstance instance) {
		super(parentShell);
		this.instance = instance;
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.NONE);
		container.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));
		GridLayout gl_container = new GridLayout(2, false);
		container.setLayout(gl_container);
		GridData gd_container = new GridData(GridData.FILL_BOTH);
		gd_container.widthHint = 614;
		container.setLayoutData(gd_container);

//		Label lblStorageAccount = new Label(container, SWT.NONE);
//		lblStorageAccount.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
//		lblStorageAccount.setText(strStorageAccount);
//
//		storageAccount = new Text(container, SWT.BORDER | SWT.READ_ONLY);
//		storageAccount.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
//		storageAccount.setText(storageAccountName);

		Label lblInstance = new Label(container, SWT.NONE);
		lblInstance.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblInstance.setText(strInstance);

		instanceName = new Text(container, SWT.BORDER | SWT.READ_ONLY);
		instanceName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		instanceName.setText(instance.getInstanceId());

		Label lblLun = new Label(container, SWT.NONE);
		lblLun.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblLun.setText(strLun);

		cmblun = new Combo(container, SWT.READ_ONLY);
		cmblun.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
		cmblun.removeAll();
		//List<String> luns = provider.getLun(instance.getInstanceId(),instance.getInstanceId());
		//List<String> luns = provider.getStorageAccountByCloudService("regionName", "cloudServiceName");
		for(String lunName : luns){
			cmblun.add(lunName);
		}
		cmblun.select(0);


		Group grpHostCache = new Group(container,SWT.NONE);
		GridLayout gl_hostCache = new GridLayout(3, false);
		grpHostCache.setLayout(gl_hostCache);
		GridData gd_hostCache = new GridData(SWT.FILL, SWT.CENTER, true, false, 4, 1);
		gd_hostCache.horizontalSpan=4;
		grpHostCache.setLayoutData(gd_hostCache);
		grpHostCache.setText(strHostCacheConfig);

		btnHostCacheNone = new Button(grpHostCache, SWT.RADIO);
		btnHostCacheNone.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		btnHostCacheNone.setSelection(true);
		btnHostCacheNone.setText(strHostCacheNone);

		btnHostCacheReadOnly = new Button(grpHostCache, SWT.RADIO);
		btnHostCacheReadOnly.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		btnHostCacheReadOnly.setText(strHostCacheReadOnly);

		btnHostCacheReadWrite = new Button(grpHostCache, SWT.RADIO);
		btnHostCacheReadWrite.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		btnHostCacheReadWrite.setText(strHostCacheReadWrite);

		table = new Table(container, SWT.BORDER | SWT.FULL_SELECTION);
		table.setLinesVisible(true);
		table.setHeaderVisible(true);
		table.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 2, 1));

		TableColumn tblclmnVolumeId = new TableColumn(table, SWT.NONE);
		tblclmnVolumeId.setWidth(160);
		tblclmnVolumeId.setText(strDiscName);

		TableColumn tableColumn_6 = new TableColumn(table, SWT.NONE);
		tableColumn_6.setWidth(100);
		tableColumn_6.setText(strOs);

		TableColumn tableColumn_1 = new TableColumn(table, SWT.NONE);
		tableColumn_1.setWidth(160);
		tableColumn_1.setText(strSubscription);

		TableColumn tableColumn_2 = new TableColumn(table, SWT.NONE);
		tableColumn_2.setWidth(160);
		tableColumn_2.setText(strSpot);

		List<ICloudStorage> availableVolumes = new ArrayList<ICloudStorage>(Arrays.asList(instance.getCloudInstanceManager().getCloudComputeService().getStorageManager().getCloudStorages()));
		Iterator<ICloudStorage> itav = availableVolumes.iterator();
		while (itav.hasNext()){
			ICloudStorage storage = itav.next();
			if(storage.getStorageId()!=null && storage.getState().equals(ICloudStorage.State.available.name())){
				TableItem item = new TableItem(table,SWT.NULL);
				for(int i=0; i < dataVirtualHardDisks.size(); i++){
					if(dataVirtualHardDisks.get(i).getName()!=null
							&& storage.getStorageId().equals(dataVirtualHardDisks.get(i).getName())){
						if(dataVirtualHardDisks.get(i).getMediaLink() != null){
							uri = dataVirtualHardDisks.get(i).getMediaLink();
						}
					}
				}
				String[] data ={storage.getStorageId(),
								storage.getFlavor(),subscriptionId,uri};
				item.setText(data);
				table.setSelection(0);
			}
		}

		return area;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				false);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(640, 480);
	}

	@Override
	protected void okPressed() {

		storageId = table.getItem(table.getSelectionIndex()).getText(0);
		lun = Integer.parseInt(cmblun.getText());
		if(btnHostCacheReadOnly.getSelection()){
			hostCache = VirtualHardDiskHostCaching.READ_ONLY;
		}else if(btnHostCacheReadWrite.getSelection()){
			hostCache = VirtualHardDiskHostCaching.READ_WRITE;
		}else{
			hostCache = VirtualHardDiskHostCaching.NONE;
		}
		deviceName = "";

		setReturnCode(OK);
		close();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(strAttachStorageDialog);
	}

	public List<String> getLuns(){
		return luns;
	}

	public void setLuns(List<String> luns){
		this.luns = luns;
	}
	
	public String getStorageId(){
		return storageId;
	}

	public String getDeviceName() {
		return deviceName;
	}

	public String getStorageAccountName(){
		return this.storageAccountName;
	}

	public void setStorageAccountName(String storageAccountName){
		this.storageAccountName = storageAccountName;
	}

	public String getSubscriptionId(){
		return subscriptionId;
	}

	public void setSubscriptionId(String subscriptionId){
		this.subscriptionId = subscriptionId;
	}

	public List<DataVirtualHardDisks> getDataVirtualHardDisks(){
		return dataVirtualHardDisks;
	}

	public void setDataVirtualHardDisks(List<DataVirtualHardDisks> dataVirtualHardDisks){
		this.dataVirtualHardDisks = dataVirtualHardDisks;
	}
	
	public VirtualHardDiskHostCaching getHostCaching(){
		return this.hostCache;
	}
	
	public void setHostCaching(VirtualHardDiskHostCaching hostCache){
		this.hostCache=hostCache;
	}
	
	public Integer getLun(){
		return lun;
	}

	public void setLun(Integer lun){
		this.lun = lun;
	}

}
