/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.azure.base.resources;

import java.util.List;

import com.clustercontrol.ws.azure.AzureCreateInstanceRequest;
import com.clustercontrol.ws.azure.AzureCreateStorageRequest;
import com.clustercontrol.ws.azure.AzureRestoreStorageRequest;

public interface CloudResourceProvider {
	List<String> getAllRegion();
	List<AvailabilityZone> getAvailabilityZones(String regionName);
	List<String> getAllInstanceType();
	List<String> getAllVolumeType();
	List<String> getAllServiceName();
	List<com.clustercontrol.ws.azure.InstanceInfo> getInstanceByCloudService(String regionName,String cloudServiceName);
	List<String> getStorageAccountByRegion(String regionName);
	String getRegionByCloudService(String regionName,String cloudServiceName);
	List<String> getStorageAccountByCloudService(String regionName,String cloudServiceName);
	List<String> getContainerByStorageAccount(String regionName, String cloudServiceName);
	void addStorage(String regionName,AzureCreateStorageRequest request);
	void createInstance(String regionName,AzureCreateInstanceRequest request);
	List<com.clustercontrol.ws.azure.AzureImage> getImages(String regionName, String filter);
	List<com.clustercontrol.ws.azure.DataVirtualHardDisks> getDataVirtualHardDisk(String region, String instanceId);
	com.clustercontrol.ws.azure.SnapShotInfo getSnapShotInfo(String region, String snapShotId, String storageId);
	void restoreStorage(String region, AzureRestoreStorageRequest request);
	void detachStorage(String region, String instanceID, String storageID);
	void atachStorage(String region, String instanceID, String storageID, AzureCreateStorageRequest request);
}