/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.azure.base.plugin.action;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.ui.IViewActionDelegate;

import com.clustercontrol.cloud.azure.base.ui.views.actions.AttachStorageFromInstanceAction;
import com.clustercontrol.cloud.azure.base.ui.views.actions.AttachStorageFromStorageAction;
import com.clustercontrol.cloud.azure.base.ui.views.actions.BackupInstanceAction;
import com.clustercontrol.cloud.azure.base.ui.views.actions.CreateInstanceAction;
import com.clustercontrol.cloud.azure.base.ui.views.actions.CreateInstanceByTemplateAction;
import com.clustercontrol.cloud.azure.base.ui.views.actions.CreateStorageAction;
import com.clustercontrol.cloud.azure.base.ui.views.actions.CreateTemplateAction;
import com.clustercontrol.cloud.azure.base.ui.views.actions.DeleteInstanceAction;
import com.clustercontrol.cloud.azure.base.ui.views.actions.DetachStorageFromInstanceAction;
import com.clustercontrol.cloud.azure.base.ui.views.actions.ModifyTemplateAction;
import com.clustercontrol.cloud.azure.base.ui.views.actions.RestoreInstanceAction;
import com.clustercontrol.cloud.azure.base.ui.views.actions.RestoreStorageAction;
import com.clustercontrol.cloud.plugin.action.IActionPluginProvider;


public class AzureStdActionPluginProvider implements IActionPluginProvider {
	private final String CLOUD_TYPE_ID = "Azure";

	private Map<String, IViewActionDelegate> actions;
	
	@Override
	public String getCloudTypeId() {
		return CLOUD_TYPE_ID;
	}

	@Override
	public List<String> getSupportedOperationList() {
		checkInit();
		return Arrays.asList(actions.keySet().toArray(new String[0]));
	}

	@Override
	public Boolean isSupported(String pluginId) {
		checkInit();
		return actions.containsKey(pluginId);
	}

	@Override
	public IViewActionDelegate getAction(String pluginId) {
		checkInit();
		return actions.get(pluginId);
	}
	
	private void init(){
		actions = new HashMap<String, IViewActionDelegate>();
		
		actions.put(com.clustercontrol.cloud.ui.views.actions.CreateInstanceAction.ID, new CreateInstanceAction());
		actions.put(com.clustercontrol.cloud.ui.views.actions.DeleteInstanceAction.ID, new DeleteInstanceAction());
		actions.put(com.clustercontrol.cloud.ui.views.actions.CreateStorageAction.ID, new CreateStorageAction());
		actions.put(com.clustercontrol.cloud.ui.views.actions.AttachStorageFromStorageAction.ID, new AttachStorageFromStorageAction());
		actions.put(com.clustercontrol.cloud.ui.views.actions.AttachStorageFromInstanceAction.ID, new AttachStorageFromInstanceAction());
		actions.put(com.clustercontrol.cloud.ui.views.actions.DetachStorageFromInstanceAction.ID, new DetachStorageFromInstanceAction());
		actions.put(com.clustercontrol.cloud.ui.views.actions.RestoreInstanceAction.ID, new RestoreInstanceAction());
		actions.put(com.clustercontrol.cloud.ui.views.actions.BackupInstanceAction.ID, new BackupInstanceAction());
		actions.put(com.clustercontrol.cloud.ui.views.actions.RestoreStorageAction.ID, new RestoreStorageAction());
		actions.put(com.clustercontrol.cloud.ui.views.actions.CreateInstanceByTemplateAction.ID, new CreateInstanceByTemplateAction());
		actions.put(com.clustercontrol.cloud.ui.views.actions.CreateTemplateAction.ID, new CreateTemplateAction());
		actions.put(com.clustercontrol.cloud.ui.views.actions.ModifyTemplateAction.ID, new ModifyTemplateAction());
	}
	
	private void checkInit(){
		if(actions == null){
			init();
		}
	}
}
