
package com.clustercontrol.ws.azure;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>virtualHardDiskHostCachingのJavaクラス。
 * 
 * <p>次のスキーマ・フラグメントは、このクラス内に含まれる予期されるコンテンツを指定します。
 * <p>
 * <pre>
 * &lt;simpleType name="virtualHardDiskHostCaching">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="None"/>
 *     &lt;enumeration value="ReadOnly"/>
 *     &lt;enumeration value="ReadWrite"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "virtualHardDiskHostCaching")
@XmlEnum
public enum VirtualHardDiskHostCaching {

    @XmlEnumValue("None")
    NONE("None"),
    @XmlEnumValue("ReadOnly")
    READ_ONLY("ReadOnly"),
    @XmlEnumValue("ReadWrite")
    READ_WRITE("ReadWrite");
    private final String value;

    VirtualHardDiskHostCaching(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static VirtualHardDiskHostCaching fromValue(String v) {
        for (VirtualHardDiskHostCaching c: VirtualHardDiskHostCaching.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
