
package com.clustercontrol.ws.azure;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>instance complex typeのJavaクラス。
 * 
 * <p>次のスキーマ・フラグメントは、このクラス内に含まれる予期されるコンテンツを指定します。
 * 
 * <pre>
 * &lt;complexType name="instance">
 *   &lt;complexContent>
 *     &lt;extension base="{http://azure.ws.clustercontrol.com}resource">
 *       &lt;sequence>
 *         &lt;element name="blockDeviceMappings" type="{http://azure.ws.clustercontrol.com}blockDeviceMapping" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="flavor" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="hostName" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="imageId" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="instanceId" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="ipAddress" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="name" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="platform" type="{http://azure.ws.clustercontrol.com}platformKind" minOccurs="0"/>
 *         &lt;element name="state" type="{http://azure.ws.clustercontrol.com}instanceStateKind" minOccurs="0"/>
 *         &lt;element name="tags" type="{http://azure.ws.clustercontrol.com}tag" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="zone" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/extension>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "instance", propOrder = {
    "blockDeviceMappings",
    "flavor",
    "hostName",
    "imageId",
    "instanceId",
    "ipAddress",
    "name",
    "platform",
    "state",
    "tags",
    "zone"
})
public class Instance
    extends Resource
{

    @XmlElement(nillable = true)
    protected List<BlockDeviceMapping> blockDeviceMappings;
    protected String flavor;
    protected String hostName;
    protected String imageId;
    protected String instanceId;
    protected String ipAddress;
    protected String name;
    protected PlatformKind platform;
    protected InstanceStateKind state;
    @XmlElement(nillable = true)
    protected List<Tag> tags;
    protected String zone;

    /**
     * Gets the value of the blockDeviceMappings property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the blockDeviceMappings property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getBlockDeviceMappings().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link BlockDeviceMapping }
     * 
     * 
     */
    public List<BlockDeviceMapping> getBlockDeviceMappings() {
        if (blockDeviceMappings == null) {
            blockDeviceMappings = new ArrayList<BlockDeviceMapping>();
        }
        return this.blockDeviceMappings;
    }

    /**
     * flavorプロパティの値を取得します。
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getFlavor() {
        return flavor;
    }

    /**
     * flavorプロパティの値を設定します。
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setFlavor(String value) {
        this.flavor = value;
    }

    /**
     * hostNameプロパティの値を取得します。
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getHostName() {
        return hostName;
    }

    /**
     * hostNameプロパティの値を設定します。
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setHostName(String value) {
        this.hostName = value;
    }

    /**
     * imageIdプロパティの値を取得します。
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getImageId() {
        return imageId;
    }

    /**
     * imageIdプロパティの値を設定します。
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setImageId(String value) {
        this.imageId = value;
    }

    /**
     * instanceIdプロパティの値を取得します。
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getInstanceId() {
        return instanceId;
    }

    /**
     * instanceIdプロパティの値を設定します。
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setInstanceId(String value) {
        this.instanceId = value;
    }

    /**
     * ipAddressプロパティの値を取得します。
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getIpAddress() {
        return ipAddress;
    }

    /**
     * ipAddressプロパティの値を設定します。
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setIpAddress(String value) {
        this.ipAddress = value;
    }

    /**
     * nameプロパティの値を取得します。
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getName() {
        return name;
    }

    /**
     * nameプロパティの値を設定します。
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setName(String value) {
        this.name = value;
    }

    /**
     * platformプロパティの値を取得します。
     * 
     * @return
     *     possible object is
     *     {@link PlatformKind }
     *     
     */
    public PlatformKind getPlatform() {
        return platform;
    }

    /**
     * platformプロパティの値を設定します。
     * 
     * @param value
     *     allowed object is
     *     {@link PlatformKind }
     *     
     */
    public void setPlatform(PlatformKind value) {
        this.platform = value;
    }

    /**
     * stateプロパティの値を取得します。
     * 
     * @return
     *     possible object is
     *     {@link InstanceStateKind }
     *     
     */
    public InstanceStateKind getState() {
        return state;
    }

    /**
     * stateプロパティの値を設定します。
     * 
     * @param value
     *     allowed object is
     *     {@link InstanceStateKind }
     *     
     */
    public void setState(InstanceStateKind value) {
        this.state = value;
    }

    /**
     * Gets the value of the tags property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the tags property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTags().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Tag }
     * 
     * 
     */
    public List<Tag> getTags() {
        if (tags == null) {
            tags = new ArrayList<Tag>();
        }
        return this.tags;
    }

    /**
     * zoneプロパティの値を取得します。
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getZone() {
        return zone;
    }

    /**
     * zoneプロパティの値を設定します。
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setZone(String value) {
        this.zone = value;
    }

}
