/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.azure.base.ui.views.actions;

import com.clustercontrol.cloud.azure.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.azure.base.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.azure.base.ui.dialogs.CreateStorageDialog;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.ui.views.StoragesView;
import com.clustercontrol.cloud.ui.views.actions.AbstractViewAction;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.azure.AzureCreateStorageRequest;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Combo;

public class CreateStorageAction
extends AbstractViewAction {
    private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
    private String msgCreateStorageConfirm = this.messages.getString("message.confirm_some_action_to_something", new Object[]{"word.storage", "word.create"});
    private String msgCreateStorageResult = this.messages.getString("message.result_some_action_to_something", new Object[]{"word.storage", "word.create"}) + this.messages.getString(this.messages.getString("message.create_storage_notification"));

    public void invoke(IAction action) throws InvocationException {
        final StoragesView view = (StoragesView)this.viewPart;
        IAccountResource.IRegion region = view.getActiveRegion();
        if (region == null) {
            assert (view.getCurrentAccountResource().getRegions().length > 0);
            region = view.getCurrentAccountResource().getRegions()[0];
        }
        CloudResourceProviderImpl provider = new CloudResourceProviderImpl(region.getAccountResource().getAccountResourceId());
        CreateStorageDialog dialog = new CreateStorageDialog(this.viewPart.getSite().getShell());
        dialog.setupCloudService(provider.getAvailabilityZones(region.getRegion()));
        dialog.setCloudInfoProvider(provider);
        dialog.setCurrentRegion(region.getRegion());
        dialog.setBehavior(new CreateStorageDialog.DialogBehavior(){

            @Override
            public void setupRegion(Combo cmbRegion) {
                super.setupRegion(cmbRegion);
                if (view != null && view.getActiveRegion() != null && cmbRegion.indexOf(view.getActiveRegion().getRegionName()) != -1) {
                    cmbRegion.select(cmbRegion.indexOf(view.getActiveRegion().getRegionName()));
                } else if (cmbRegion.getItemCount() > 0) {
                    cmbRegion.select(0);
                }
            }
        });
        if (dialog.open() == 0) {
            if (MessageDialog.openConfirm(null, (String)Messages.getString((String)"confirmed"), (String)this.msgCreateStorageConfirm)) {
                CreateStorageDialog.DialogData output = dialog.getOutput();
                AzureCreateStorageRequest request = new AzureCreateStorageRequest();
                request.setCloudServiceName(output.getCloudServiceName());
                request.setInstanceName(output.getInstanceName());
                request.setStorageAccountName(output.getStorageAccountName());
                request.setContainerName(output.getContainerName());
                request.setStorageName(output.getStorageName());
                request.setStorageSize(output.getStorageSize());
                request.setVirtualHardDiskHostCaching(output.getHostCacheConfig());
                request.setZone(region.getRegionName());
                request.setFlavor(output.getFlavor());
                provider.addStorage(region.getRegion(), request);
                MessageDialog.openInformation(null, (String)Messages.getString((String)"successful"), (String)this.msgCreateStorageResult);
            } else {
                return;
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(true);
    }
}

