/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.azure.base.ui.dialogs;

import com.clustercontrol.cloud.azure.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.presenter.ICloudInstance;
import com.clustercontrol.cloud.presenter.ICloudStorage;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.azure.DataVirtualHardDisk;
import com.clustercontrol.ws.azure.InstanceInfo;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class DetachStorageFromInstanceDialog
extends Dialog {
    private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
    private String strInstance = this.messages.getString("word.instance");
    private String strLun = this.messages.getString("word.lun");
    private String strDiscName = this.messages.getString("word.disc_name");
    private String strOs = this.messages.getString("word.os");
    private String strHostCache = this.messages.getString("word.host_cache");
    private String strSubscription = this.messages.getString("word.subscription");
    private String strSpot = this.messages.getString("word.spot");
    private String strDetachStorageDialog = this.messages.getString("caption.detach_storage_dialog");
    private String msgMustFullyInput = this.messages.getString("message.must_fully_input");
    private ICloudInstance instance;
    private List<ICloudStorage> volumes = new ArrayList<ICloudStorage>();
    private Table table;
    private Text instanceName;
    private String instanceID;
    private String storageID;
    String storageAccountName;
    String subscriptionId;
    InstanceInfo instanceInfo;
    String uri;
    String hostCache;
    String lun;

    public DetachStorageFromInstanceDialog(Shell parentShell, ICloudInstance instance) {
        super(parentShell);
        this.instance = instance;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setBackground(SWTResourceManager.getColor((int)22));
        GridLayout gl_container = new GridLayout(2, false);
        container.setLayout((Layout)gl_container);
        GridData gd_container = new GridData(1808);
        gd_container.widthHint = 614;
        container.setLayoutData((Object)gd_container);
        Label lblInstance = new Label(container, 0);
        lblInstance.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblInstance.setText(this.strInstance);
        this.instanceName = new Text(container, 2056);
        this.instanceName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.instanceName.setText(this.instance.getInstanceId());
        this.table = new Table(container, 67586);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        TableColumn tblclmnVolumeId = new TableColumn(this.table, 0);
        tblclmnVolumeId.setWidth(105);
        tblclmnVolumeId.setText(this.strDiscName);
        TableColumn tableColumn_6 = new TableColumn(this.table, 0);
        tableColumn_6.setWidth(70);
        tableColumn_6.setText(this.strOs);
        TableColumn tableColumn_1 = new TableColumn(this.table, 0);
        tableColumn_1.setWidth(110);
        tableColumn_1.setText(this.strHostCache);
        TableColumn tableColumn_2 = new TableColumn(this.table, 0);
        tableColumn_2.setWidth(120);
        tableColumn_2.setText(this.strSubscription);
        TableColumn tableColumn_3 = new TableColumn(this.table, 0);
        tableColumn_3.setWidth(70);
        tableColumn_3.setText(this.strLun);
        TableColumn tableColumn_4 = new TableColumn(this.table, 0);
        tableColumn_4.setWidth(105);
        tableColumn_4.setText(this.strSpot);
        for (DataVirtualHardDisk dvhd : this.instanceInfo.getDataVirtualHardDisks()) {
            String[] data = new String[]{dvhd.getName(), "Data", dvhd.getHostCaching() != null ? dvhd.getHostCaching().toString() : "", this.subscriptionId, dvhd.getLogicalUnitNumber() == null ? "" : dvhd.getLogicalUnitNumber().toString(), dvhd.getMediaLink()};
            TableItem item = new TableItem(this.table, 0);
            item.setText(data);
        }
        this.table.setSelection(0);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DetachStorageFromInstanceDialog.this.volumes.clear();
                for (TableItem ti : DetachStorageFromInstanceDialog.this.table.getSelection()) {
                    DetachStorageFromInstanceDialog.this.volumes.add((ICloudStorage)ti.getData());
                }
            }
        });
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(640, 480);
    }

    protected void okPressed() {
        if (this.volumes.isEmpty()) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.msgMustFullyInput);
            return;
        }
        this.setInstanceID(this.instance.getInstanceId());
        this.setStorageID(this.table.getItem(this.table.getSelectionIndex()).getText(0));
        this.setReturnCode(0);
        this.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.strDetachStorageDialog);
    }

    public String getStorageAccountName() {
        return this.storageAccountName;
    }

    public void setStorageAccountName(String storageAccountName) {
        this.storageAccountName = storageAccountName;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public InstanceInfo getDataVirtualHardDisks() {
        return this.instanceInfo;
    }

    public void setDataVirtualHardDisks(InstanceInfo instanceInfo) {
        this.instanceInfo = instanceInfo;
    }

    public void setInstanceID(String instanceID) {
        this.instanceID = instanceID;
    }

    public void setStorageID(String storageID) {
        this.storageID = storageID;
    }

    public String getInstanceID() {
        return this.instanceID;
    }

    public String getStorageID() {
        return this.storageID;
    }

    public static class VolumeProvider {
        private VolumeContentProvider vcp = new VolumeContentProvider();
        private VolumeLabelProvider vlp = new VolumeLabelProvider();

        public VolumeContentProvider getVolumeContentProvider() {
            return this.vcp;
        }

        public VolumeLabelProvider getVolumeLabelProvider() {
            return this.vlp;
        }

        public class VolumeLabelProvider
        extends LabelProvider
        implements ITableLabelProvider {
            public String getColumnText(Object element, int columnIndex) {
                ICloudStorage storage = (ICloudStorage)element;
                switch (columnIndex) {
                    case 0: {
                        return storage.getStorageId();
                    }
                    case 1: {
                        return storage.getStorageName();
                    }
                    case 2: {
                        return storage.getStorageAttachment() != null ? storage.getStorageAttachment().getDevice() : "";
                    }
                    case 3: {
                        return storage.getSnapshotId() != null ? storage.getSnapshotId() : "";
                    }
                    case 4: {
                        return storage.getSize() != null ? String.valueOf(storage.getSize()) : "";
                    }
                    case 5: {
                        return storage.getFlavor();
                    }
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }
        }

        public class VolumeContentProvider
        implements IStructuredContentProvider {
            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }
    }
}

