/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.azure.base.ui.dialogs;

import com.clustercontrol.cloud.azure.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.azure.base.resources.AvailabilityZone;
import com.clustercontrol.cloud.azure.base.resources.CloudResourceProvider;
import com.clustercontrol.cloud.azure.base.resources.EndPointInfo;
import com.clustercontrol.cloud.azure.base.resources.InstanceTypeInfo;
import com.clustercontrol.cloud.azure.base.ui.dialogs.RegistEndPointDialog;
import com.clustercontrol.cloud.azure.base.ui.dialogs.SelectVMIDialog;
import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.presenter.CreateCloudInstanceRequest;
import com.clustercontrol.cloud.presenter.TemplateJobsArgument;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.azure.AzureImage;
import com.clustercontrol.ws.azure.EndPoint;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class CreateInstanceDialog
extends Dialog {
    private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
    private String strSeparator = this.messages.getString("caption.title_separator");
    private String strNodeInfo = this.messages.getString("word.node_info");
    private String strFacilityId = this.messages.getString("word.facility_id");
    private String strNodeReplaceDescription = this.messages.getString("caption.node_replace_description");
    private String strFacilityName = this.messages.getString("word.facility_name");
    private String strDescription = this.messages.getString("word.description");
    private String strNodeName = this.messages.getString("word.node_name");
    private String strInstanceInfo = this.messages.getString("word.instance_info");
    private String strCloudService = this.messages.getString("word.cloud_service");
    private String strStorageAccount = this.messages.getString("word.storage_account");
    private String strContainerName = this.messages.getString("word.container_name");
    private String strSize = this.messages.getString("word.size");
    private String strNewUserName = this.messages.getString("word.new_user_name");
    private String strPassword = this.messages.getString("word.password");
    private String strRePassword = this.messages.getString("word.re_password");
    private String strImage = this.messages.getString("word.image");
    private String strRefer = this.messages.getString("word.refer");
    private String strEndPoint = this.messages.getString("word.end_point");
    private String strAvailabilitySet = this.messages.getString("word.availability_set");
    private String strAvailabilitySetName = this.messages.getString("word.availability_set_name");
    private String strCreateInstanceDialog = this.messages.getString("caption.create_instance_dialog");
    private Shell shell;
    private Text facilityId;
    private Button btnReplaceNode;
    private Text facilityName;
    private Text description;
    private Text nodeName;
    private Combo cmbCloudService;
    private Combo cmbStorageAccount;
    private Combo cmbContainer;
    private Combo cmbSize;
    private Text newUserName;
    private Text password;
    private Text rePassword;
    private Text txtIMAGE;
    private Button btnAvailabilitySet;
    private Text txtAvailabilitySetName;
    private Button btnSelectIMAGE;
    private CloudResourceProvider provider;
    private Model input;
    private Model output = new Model();
    private IDialogBehavior behavior = new DialogBehavior();
    private List<AvailabilityZone> cloudServices = new ArrayList<AvailabilityZone>();
    private List<EndPoint> endPoint = new ArrayList<EndPoint>();
    private String regionName = "";
    private Label lblIMAGE;
    private Label lblAvailabilitySet;
    private Label lblAvailabilitySetName;

    public CreateInstanceDialog(Shell parentShell) {
        super(parentShell);
        this.shell = parentShell;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setBackground(SWTResourceManager.getColor((int)22));
        GridLayout gl_container = new GridLayout(1, false);
        container.setLayout((Layout)gl_container);
        GridData gd_container = new GridData(1808);
        gd_container.widthHint = 614;
        container.setLayoutData((Object)gd_container);
        Group grpNodeInfo = new Group(container, 0);
        grpNodeInfo.setText(this.strNodeInfo + this.strSeparator);
        GridLayout gl_grpNodeInfo = new GridLayout(2, false);
        gl_grpNodeInfo.verticalSpacing = 9;
        gl_grpNodeInfo.horizontalSpacing = 15;
        grpNodeInfo.setLayout((Layout)gl_grpNodeInfo);
        grpNodeInfo.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 5, 1));
        Label lblid = new Label((Composite)grpNodeInfo, 131072);
        lblid.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblid.setText(this.strFacilityId + this.strSeparator);
        this.facilityId = new Text((Composite)grpNodeInfo, 2048);
        this.facilityId.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        new Label((Composite)grpNodeInfo, 0);
        this.btnReplaceNode = new Button((Composite)grpNodeInfo, 32);
        this.btnReplaceNode.setText(this.strNodeReplaceDescription);
        Label lblFacilityName = new Label((Composite)grpNodeInfo, 131072);
        lblFacilityName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblFacilityName.setText(this.strFacilityName + this.strSeparator);
        this.facilityName = new Text((Composite)grpNodeInfo, 2048);
        this.facilityName.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        Label lblDescription = new Label((Composite)grpNodeInfo, 131072);
        lblDescription.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblDescription.setText(this.strDescription + this.strSeparator);
        this.description = new Text((Composite)grpNodeInfo, 2048);
        this.description.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        Label lblNodeName = new Label((Composite)grpNodeInfo, 131072);
        lblNodeName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblNodeName.setText(this.strNodeName + this.strSeparator);
        this.nodeName = new Text((Composite)grpNodeInfo, 2048);
        GridData gd_nodeName = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_nodeName.widthHint = 66;
        this.nodeName.setLayoutData((Object)gd_nodeName);
        Group grpInstacneInfo = new Group(container, 0);
        grpInstacneInfo.setText(this.strInstanceInfo);
        GridLayout gl_grpInstacneInfo = new GridLayout(3, false);
        gl_grpInstacneInfo.verticalSpacing = 9;
        gl_grpInstacneInfo.horizontalSpacing = 15;
        grpInstacneInfo.setLayout((Layout)gl_grpInstacneInfo);
        GridData gd_grpInstacneInfo = new GridData(4, 0x1000000, false, false, 5, 1);
        gd_grpInstacneInfo.heightHint = 370;
        grpInstacneInfo.setLayoutData((Object)gd_grpInstacneInfo);
        Label lblCloudService = new Label((Composite)grpInstacneInfo, 131072);
        lblCloudService.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblCloudService.setText(this.strCloudService + this.strSeparator);
        this.cmbCloudService = new Combo((Composite)grpInstacneInfo, 8);
        for (AvailabilityZone az : this.cloudServices) {
            this.cmbCloudService.add(az.getZoneName());
        }
        this.cmbCloudService.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.cmbCloudService.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Combo bCombo = (Combo)e.widget;
                CreateInstanceDialog.this.cmbStorageAccount.removeAll();
                List<String> storageAccounts = CreateInstanceDialog.this.provider.getStorageAccountByCloudService(CreateInstanceDialog.this.regionName, bCombo.getItem(bCombo.getSelectionIndex()));
                for (String storageAccountName : storageAccounts) {
                    CreateInstanceDialog.this.cmbStorageAccount.add(storageAccountName);
                }
            }
        });
        Label lblStorageAccount = new Label((Composite)grpInstacneInfo, 131072);
        lblStorageAccount.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblStorageAccount.setText(this.strStorageAccount + this.strSeparator);
        this.cmbStorageAccount = new Combo((Composite)grpInstacneInfo, 8);
        this.cmbStorageAccount.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.cmbStorageAccount.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Combo bCombo = (Combo)e.widget;
                CreateInstanceDialog.this.cmbContainer.removeAll();
                List<String> containers = CreateInstanceDialog.this.provider.getContainerByStorageAccount(CreateInstanceDialog.this.regionName, bCombo.getItem(bCombo.getSelectionIndex()));
                for (String container : containers) {
                    CreateInstanceDialog.this.cmbContainer.add(container);
                }
            }
        });
        Label lblContainerName = new Label((Composite)grpInstacneInfo, 131072);
        lblContainerName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblContainerName.setText(this.strContainerName + this.strSeparator);
        this.cmbContainer = new Combo((Composite)grpInstacneInfo, 8);
        this.cmbContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label lblSize = new Label((Composite)grpInstacneInfo, 131072);
        lblSize.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblSize.setText(this.strSize + this.strSeparator);
        this.cmbSize = new Combo((Composite)grpInstacneInfo, 8);
        this.cmbSize.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.cmbSize.setItems(InstanceTypeInfo.storageSize);
        Label lblNewUserName = new Label((Composite)grpInstacneInfo, 131072);
        lblNewUserName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblNewUserName.setText(this.strNewUserName + this.strSeparator);
        this.newUserName = new Text((Composite)grpInstacneInfo, 2048);
        this.newUserName.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        Label lblPassword = new Label((Composite)grpInstacneInfo, 131072);
        lblPassword.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblPassword.setText(this.strPassword + this.strSeparator);
        this.password = new Text((Composite)grpInstacneInfo, 0x400800);
        this.password.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        Label lblRePassword = new Label((Composite)grpInstacneInfo, 131072);
        lblRePassword.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblRePassword.setText(this.strRePassword + this.strSeparator);
        this.rePassword = new Text((Composite)grpInstacneInfo, 0x400800);
        this.rePassword.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.lblIMAGE = new Label((Composite)grpInstacneInfo, 0);
        this.lblIMAGE.setAlignment(131072);
        this.lblIMAGE.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.lblIMAGE.setText(this.strImage + this.strSeparator);
        this.txtIMAGE = new Text((Composite)grpInstacneInfo, 2056);
        this.txtIMAGE.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        if (this.output.isRestore()) {
            this.txtIMAGE.setText(this.output.getAzureImage().getImageId());
            EndPointInfo epinfo = new EndPointInfo();
            if (this.endPoint.size() == 0 && this.output.getAzureImage().getOStype().toLowerCase().equals("windows")) {
                this.endPoint.addAll(epinfo.getWindowsDefaultEndPoint());
            } else if (this.endPoint.size() == 0 && this.output.getAzureImage().getOStype().toLowerCase().equals("linux")) {
                this.endPoint.addAll(epinfo.getLinuxDefaultEndPoint());
            }
        }
        this.btnSelectIMAGE = new Button((Composite)grpInstacneInfo, 0);
        this.btnSelectIMAGE.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnSelectIMAGE.setText(this.strRefer);
        if (this.output.isRestore()) {
            this.btnSelectIMAGE.setEnabled(false);
        } else {
            this.btnSelectIMAGE.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SelectVMIDialog dialog = new SelectVMIDialog(CreateInstanceDialog.this.shell);
                    dialog.setCloudInfoProvider(CreateInstanceDialog.this.provider);
                    dialog.setRegion(CreateInstanceDialog.this.regionName);
                    dialog.open();
                    if (dialog.getReturnCode() == 0) {
                        AzureImage image = dialog.getOutput();
                        CreateInstanceDialog.this.txtIMAGE.setText("(" + image.getImageId() + ") " + image.getName());
                        CreateInstanceDialog.this.txtIMAGE.setData((Object)image);
                        CreateInstanceDialog.this.output.setAzureImage(image);
                        EndPointInfo epinfo = new EndPointInfo();
                        if (CreateInstanceDialog.this.endPoint.size() == 0 && image.getOStype().toLowerCase().equals("windows")) {
                            CreateInstanceDialog.this.endPoint.addAll(epinfo.getWindowsDefaultEndPoint());
                        } else if (CreateInstanceDialog.this.endPoint.size() == 0 && image.getOStype().toLowerCase().equals("linux")) {
                            CreateInstanceDialog.this.endPoint.addAll(epinfo.getLinuxDefaultEndPoint());
                        }
                    }
                }
            });
        }
        this.lblAvailabilitySet = new Label((Composite)grpInstacneInfo, 0);
        this.lblAvailabilitySet.setAlignment(131072);
        this.lblAvailabilitySet.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.lblAvailabilitySet.setText(this.strAvailabilitySet + this.strSeparator);
        this.btnAvailabilitySet = new Button((Composite)grpInstacneInfo, 32);
        this.btnAvailabilitySet.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Button bCombo = (Button)e.widget;
                if (bCombo.getSelection()) {
                    CreateInstanceDialog.this.txtAvailabilitySetName.setEnabled(true);
                } else {
                    CreateInstanceDialog.this.txtAvailabilitySetName.setEnabled(false);
                }
            }
        });
        this.btnAvailabilitySet.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.btnAvailabilitySet.setAlignment(131072);
        this.lblAvailabilitySetName = new Label((Composite)grpInstacneInfo, 0);
        this.lblAvailabilitySetName.setAlignment(131072);
        this.lblAvailabilitySetName.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.lblAvailabilitySetName.setText(this.strAvailabilitySetName + this.strSeparator);
        this.txtAvailabilitySetName = new Text((Composite)grpInstacneInfo, 2048);
        this.txtAvailabilitySetName.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.txtAvailabilitySetName.setEnabled(false);
        new Label((Composite)grpInstacneInfo, 0);
        new Label((Composite)grpInstacneInfo, 0);
        Button btnEndPointSettings = new Button((Composite)grpInstacneInfo, 0);
        btnEndPointSettings.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        btnEndPointSettings.setText(this.strEndPoint);
        new Label((Composite)grpInstacneInfo, 0);
        new Label((Composite)grpInstacneInfo, 0);
        new Label((Composite)grpInstacneInfo, 0);
        new Label((Composite)grpInstacneInfo, 0);
        btnEndPointSettings.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RegistEndPointDialog dialog = new RegistEndPointDialog(CreateInstanceDialog.this.shell);
                CreateInstanceDialog.this.output.setFacilityName(CreateInstanceDialog.this.facilityName.getText());
                dialog.setEndPoint(CreateInstanceDialog.this.endPoint);
                if (CreateInstanceDialog.this.output.getAzureImage() != null) {
                    dialog.setOStype(CreateInstanceDialog.this.output.getAzureImage().getOStype());
                }
                if (dialog.open() == 0) {
                    CreateInstanceDialog.this.endPoint = dialog.getEndPoint();
                }
            }
        });
        ControlUtil.setRequired((Control[])new Control[]{this.facilityId, this.facilityName, this.nodeName});
        this.behavior.setInput(this.input);
        this.behavior.setProvider(this.provider);
        this.behavior.setupFacilityId(this.facilityId);
        this.behavior.setupReplaceNode(this.btnReplaceNode);
        this.behavior.setupFacilityName(this.facilityName);
        this.behavior.setupDescription(this.description);
        this.behavior.setupNodeName(this.nodeName);
        this.behavior.setupCloudService(this.cmbCloudService);
        this.behavior.setupStorageAccount(this.cmbStorageAccount);
        this.behavior.setupSize(this.cmbSize);
        this.behavior.setupDetailSettings(btnEndPointSettings);
        this.behavior.setupImage(this.txtIMAGE, this.btnSelectIMAGE);
        container.layout();
        Control[] labels = new Control[]{lblid, lblFacilityName, lblDescription, lblNodeName, lblCloudService, lblStorageAccount, lblSize, this.lblIMAGE, this.lblAvailabilitySet};
        int maxWidth = 0;
        for (Control l : labels) {
            Point p = l.getSize();
            maxWidth = Math.max(maxWidth, p.x);
        }
        for (Control l : labels) {
            ((GridData)l.getLayoutData()).widthHint = maxWidth;
        }
        grpNodeInfo.layout(true);
        grpInstacneInfo.layout(true);
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(640, 690);
    }

    protected void okPressed() {
        if (this.facilityId.getText().equals("") || this.facilityName.getText().equals("") || this.nodeName.getText().equals("") || this.cmbCloudService.getText().equals("") || this.cmbStorageAccount.getText().equals("") || this.cmbSize.getText().equals("") || !this.btnAvailabilitySet.getSelection() && this.txtIMAGE.getText().equals("")) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.messages.getString("message.must_fully_input"));
            return;
        }
        String nodeNameVal = this.nodeName.getText();
        if (nodeNameVal.substring(0, 1).matches(".*[^a-zA-Z].*") || nodeNameVal.substring(nodeNameVal.length() - 1).matches(".*[^0-9a-zA-Z].*") || nodeNameVal.matches(".*[^-0-9a-zA-Z].*")) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.messages.getString("message.unmatcch_name_rule"));
            return;
        }
        if (!this.password.getText().equals(this.rePassword.getText())) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.messages.getString("message.unmatch_password"));
            return;
        }
        int password_chk = 0;
        if (this.password.getText().matches(".*[A-Z].*")) {
            ++password_chk;
        }
        if (this.password.getText().matches(".*[a-z].*")) {
            ++password_chk;
        }
        if (this.password.getText().matches(".*[0-9].*")) {
            ++password_chk;
        }
        if (this.password.getText().matches(".*[^0-9a-zA-Z].*")) {
            ++password_chk;
        }
        if (password_chk < 3) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.messages.getString("message.unmatch_rule"));
            return;
        }
        if (this.password.getText().length() < 8) {
            MessageDialog.openError(null, (String)Messages.getString((String)"failed"), (String)this.messages.getString("message.too_short"));
            return;
        }
        this.output.setCloudServiceName(this.cmbCloudService.getText());
        this.output.setStorageAccountName(this.cmbStorageAccount.getText());
        this.output.setSize(this.cmbSize.getText());
        this.output.setFacilityId(this.facilityId.getText());
        this.output.setFacilityName(this.facilityName.getText());
        this.output.setDescription(this.description.getText());
        this.output.setNodeName(this.nodeName.getText());
        this.output.setReplaceNode(this.btnReplaceNode.getSelection());
        this.output.setNewUserName(this.newUserName.getText());
        this.output.setPassword(this.password.getText());
        this.output.setRePassword(this.rePassword.getText());
        this.output.setImageId(this.output.getAzureImage().getImageId());
        this.output.setIsAvailabilitySet(this.btnAvailabilitySet.getSelection());
        this.output.setEndPoint(this.endPoint);
        this.output.setAvailabilitySetNmae(this.txtAvailabilitySetName.getText());
        this.output.setContainerName(this.cmbContainer.getText());
        this.output.setRegionName(this.regionName);
        this.setReturnCode(0);
        this.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.strCreateInstanceDialog);
    }

    public void setInput(Model input) {
        assert (input != null);
        this.input = input;
        this.output = input.deepCopy();
    }

    public Model getOutput() {
        return this.output;
    }

    public void setCloudInfoProvider(CloudResourceProvider provider) {
        this.provider = provider;
    }

    public void setBehavior(IDialogBehavior behavior) {
        this.behavior = behavior;
    }

    public void setupCloudService(List<AvailabilityZone> cloudServices) {
        this.cloudServices = cloudServices;
    }

    public void setCurrentRegion(String regionName) {
        this.regionName = regionName;
    }

    public static class DialogBehavior
    implements IDialogBehavior {
        protected MessageManagerExt messages = MessageManagerExt.getInstance("messages");
        protected CloudResourceProvider provider;
        protected Model input;

        @Override
        public void setInput(Model input) {
            this.input = input;
        }

        @Override
        public void setProvider(CloudResourceProvider provider) {
            this.provider = provider;
        }

        @Override
        public void setupFacilityId(Text facilityId) {
        }

        @Override
        public void setupFacilityName(Text facilityName) {
        }

        @Override
        public void setupReplaceNode(Button btnReplaceNode) {
        }

        @Override
        public void setupDescription(Text description) {
        }

        @Override
        public void setupNodeName(Text nodeName) {
        }

        @Override
        public void setupCloudService(Combo cloudService) {
        }

        @Override
        public void setupStorageAccount(Combo storageAccount) {
        }

        @Override
        public void setupSize(Combo size) {
        }

        @Override
        public void setupNewUserName(Text newUserName) {
        }

        @Override
        public void setupPassword(Text password) {
        }

        @Override
        public void setupRePassword(Text RePassword) {
        }

        @Override
        public void setupSelectImageFlg(Button rdoAmi, Button rdoTemplate) {
        }

        @Override
        public void setupImage(Text image, Button selectImage) {
        }

        @Override
        public void setupTemplate(Button useTemplate, Combo template, Button editArgument) {
        }

        @Override
        public void setupDetailSettings(Button detailSettings) {
        }

        @Override
        public void setupAvailabilityZone(Combo cmbAvailabilityZone) {
        }

        public void setupRegion(Combo cmbRegion) {
        }
    }

    static interface IDialogBehavior {
        public void setInput(Model var1);

        public void setProvider(CloudResourceProvider var1);

        public void setupFacilityId(Text var1);

        public void setupFacilityName(Text var1);

        public void setupReplaceNode(Button var1);

        public void setupDescription(Text var1);

        public void setupNodeName(Text var1);

        public void setupCloudService(Combo var1);

        public void setupStorageAccount(Combo var1);

        public void setupSize(Combo var1);

        public void setupNewUserName(Text var1);

        public void setupPassword(Text var1);

        public void setupRePassword(Text var1);

        public void setupSelectImageFlg(Button var1, Button var2);

        public void setupImage(Text var1, Button var2);

        public void setupTemplate(Button var1, Combo var2, Button var3);

        public void setupDetailSettings(Button var1);

        public void setupAvailabilityZone(Combo var1);
    }

    public static class Model
    extends CreateCloudInstanceRequest
    implements Serializable {
        private static final long serialVersionUID = -8364801407665470030L;
        private String regionName;
        private String cloudServiceName;
        private String storageAccountName;
        private String containerName;
        private String sizeName;
        private String newUserName;
        private String password;
        private String rePassword;
        private String templateId;
        private List<TemplateJobsArgument> arguments;
        private Boolean isAvailabilitySet = false;
        private List<EndPoint> endPoint;
        private AzureImage azureImage;
        private String availabilitySetNmae;
        private Boolean isRestore = false;

        public String getRegionName() {
            return this.regionName;
        }

        public void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        public String getCloudServiceName() {
            return this.cloudServiceName;
        }

        public void setCloudServiceName(String cloudServiceName) {
            this.cloudServiceName = cloudServiceName;
        }

        public String getStorageAccountName() {
            return this.storageAccountName;
        }

        public void setStorageAccountName(String storageAccountName) {
            this.storageAccountName = storageAccountName;
        }

        public String getContainerName() {
            return this.containerName;
        }

        public void setContainerName(String containerName) {
            this.containerName = containerName;
        }

        public String getSize() {
            return this.sizeName;
        }

        public void setSize(String sizeName) {
            this.sizeName = sizeName;
        }

        public String getNewUserName() {
            return this.newUserName;
        }

        public void setNewUserName(String newUserName) {
            this.newUserName = newUserName;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getRePassword() {
            return this.rePassword;
        }

        public void setRePassword(String rePassword) {
            this.rePassword = rePassword;
        }

        public void setAzureImage(AzureImage azureImage) {
            this.azureImage = azureImage;
        }

        public AzureImage getAzureImage() {
            return this.azureImage;
        }

        public boolean isRestore() {
            return this.isRestore;
        }

        public void setIsRestore(boolean isRestore) {
            this.isRestore = isRestore;
        }

        public String getTemplateId() {
            return this.templateId;
        }

        public void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        public List<TemplateJobsArgument> getArguments() {
            return this.arguments;
        }

        public void setArguments(List<TemplateJobsArgument> arguments) {
            this.arguments = arguments;
        }

        public Boolean getIsAvailabilitySet() {
            return this.isAvailabilitySet;
        }

        public void setIsAvailabilitySet(Boolean isAvailabilitySet) {
            this.isAvailabilitySet = isAvailabilitySet;
        }

        public List<EndPoint> getEndPoint() {
            return this.endPoint;
        }

        public void setEndPoint(List<EndPoint> endPoint) {
            this.endPoint = endPoint;
        }

        public String getAvailabilitySetNmae() {
            return this.availabilitySetNmae;
        }

        public void setAvailabilitySetNmae(String AvailabilitySetNmae) {
            this.availabilitySetNmae = AvailabilitySetNmae;
        }

        public Model deepCopy() {
            return this;
        }
    }

    public static class InstanceDetail {
        public List<String> securityGroupIds = new ArrayList<String>();
        public String keyName;
        public Boolean monitoring;
        public Boolean disableApiTermination;
        public String instanceInitiatedShutdownBehavior;
        public Boolean ebsOptimized;
        public EbsBlockDevice rootBlockDevice;
    }

    public static class EbsBlockDevice {
        public Integer volumeSize;
        public Boolean deleteOnTermination;
        public String volumeType;
        public Integer iops;
    }
}

