/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.azure.base.ui.dialogs;

import com.clustercontrol.cloud.azure.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.presenter.ICloudStorage;
import com.clustercontrol.ws.azure.DataVirtualHardDisks;
import com.clustercontrol.ws.azure.InstanceInfo;
import com.clustercontrol.ws.azure.VirtualHardDiskHostCaching;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class AttachStorageFromStorageDialog
extends Dialog {
    private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
    private String strDiscName = this.messages.getString("word.disc_name");
    private String instanceName = this.messages.getString("word.instance_name");
    private String strLun = this.messages.getString("word.lun");
    private String strHostCacheConfig = this.messages.getString("word.host_cache_config");
    private String strHostCacheNone = this.messages.getString("word.host_cache_none");
    private String strHostCacheReadOnly = this.messages.getString("word.host_cache_read_only");
    private String strHostCacheReadWrite = this.messages.getString("word.host_cache_read_write");
    private String strOs = this.messages.getString("word.os");
    private String strSubscription = this.messages.getString("word.subscription");
    private String strSpot = this.messages.getString("word.spot");
    private String strAttachStorageDialog = this.messages.getString("caption.attach_storage_dialog");
    private Text txtdiscName;
    private Combo cmblun;
    private Button btnHostCacheNone;
    private Button btnHostCacheReadOnly;
    private Button btnHostCacheReadWrite;
    private Table table;
    private ICloudStorage storage;
    private String instanceId;
    private String deviceName;
    List<String> luns;
    String subscriptionId;
    String uri;
    String cloudService;
    List<DataVirtualHardDisks> dataVirtualHardDisks;
    List<InstanceInfo> instancesInfo;
    int diskSize;
    VirtualHardDiskHostCaching hostCache;
    Integer lun;

    public AttachStorageFromStorageDialog(Shell parentShell, ICloudStorage storage) {
        super(parentShell);
        this.storage = storage;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setBackground(SWTResourceManager.getColor((int)22));
        GridLayout gl_container = new GridLayout(2, false);
        container.setLayout((Layout)gl_container);
        GridData gd_container = new GridData(1808);
        gd_container.widthHint = 614;
        container.setLayoutData((Object)gd_container);
        Label lblDiscName = new Label(container, 0);
        lblDiscName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblDiscName.setText(this.strDiscName);
        this.txtdiscName = new Text(container, 2056);
        this.txtdiscName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtdiscName.setText(this.storage.getStorageId());
        Label lblLun = new Label(container, 0);
        lblLun.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblLun.setText(this.strLun);
        this.cmblun = new Combo(container, 8);
        this.cmblun.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Group grpHostCache = new Group(container, 0);
        GridLayout gl_hostCache = new GridLayout(3, false);
        grpHostCache.setLayout((Layout)gl_hostCache);
        GridData gd_hostCache = new GridData(4, 0x1000000, true, false, 4, 1);
        gd_hostCache.horizontalSpan = 4;
        grpHostCache.setLayoutData((Object)gd_hostCache);
        grpHostCache.setText(this.strHostCacheConfig);
        this.btnHostCacheNone = new Button((Composite)grpHostCache, 16);
        this.btnHostCacheNone.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnHostCacheNone.setSelection(true);
        this.btnHostCacheNone.setText(this.strHostCacheNone);
        this.btnHostCacheReadOnly = new Button((Composite)grpHostCache, 16);
        this.btnHostCacheReadOnly.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnHostCacheReadOnly.setText(this.strHostCacheReadOnly);
        this.btnHostCacheReadWrite = new Button((Composite)grpHostCache, 16);
        this.btnHostCacheReadWrite.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnHostCacheReadWrite.setText(this.strHostCacheReadWrite);
        this.table = new Table(container, 67584);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        TableColumn tblclmnInstance = new TableColumn(this.table, 0);
        tblclmnInstance.setWidth(160);
        tblclmnInstance.setText(this.instanceName);
        TableColumn tableColumnOS = new TableColumn(this.table, 0);
        tableColumnOS.setWidth(100);
        tableColumnOS.setText(this.strOs);
        TableColumn tableColumnSubscription = new TableColumn(this.table, 0);
        tableColumnSubscription.setWidth(160);
        tableColumnSubscription.setText(this.strSubscription);
        TableColumn tableColumnSpot = new TableColumn(this.table, 0);
        tableColumnSpot.setWidth(160);
        tableColumnSpot.setText(this.strSpot);
        for (InstanceInfo instanceInfo : this.instancesInfo) {
            TableItem item = new TableItem(this.table, 0);
            String[] data = new String[]{instanceInfo.getInstanceName(), instanceInfo.getOSType(), this.subscriptionId, this.cloudService};
            item.setText(data);
        }
        this.table.setSelection(0);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AttachStorageFromStorageDialog.this.cmblun.removeAll();
                Table btable = (Table)e.widget;
                String item = btable.getItem(btable.getSelectionIndex()).getText();
                for (InstanceInfo ii : AttachStorageFromStorageDialog.this.instancesInfo) {
                    if (!ii.getInstanceName().equals(item)) continue;
                    for (int i = 0; i <= 15; ++i) {
                        if (ii.getAttachedLun().contains(i)) continue;
                        AttachStorageFromStorageDialog.this.cmblun.add(Integer.toString(i));
                    }
                }
                AttachStorageFromStorageDialog.this.cmblun.select(0);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(640, 480);
    }

    protected void okPressed() {
        this.instanceId = this.table.getItem(this.table.getSelectionIndex()).getText(0);
        this.deviceName = "";
        this.lun = Integer.parseInt(this.cmblun.getText());
        this.hostCache = this.btnHostCacheReadOnly.getSelection() ? VirtualHardDiskHostCaching.READ_ONLY : (this.btnHostCacheReadWrite.getSelection() ? VirtualHardDiskHostCaching.READ_WRITE : VirtualHardDiskHostCaching.NONE);
        this.setReturnCode(0);
        this.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.strAttachStorageDialog);
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public List<DataVirtualHardDisks> getDataVirtualHardDisks() {
        return this.dataVirtualHardDisks;
    }

    public void setDataVirtualHardDisks(List<DataVirtualHardDisks> dataVirtualHardDisks) {
        this.dataVirtualHardDisks = dataVirtualHardDisks;
    }

    public List<InstanceInfo> getInstanceInfo() {
        return this.instancesInfo;
    }

    public void setInstanceInfo(List<InstanceInfo> instancesInfo) {
        this.instancesInfo = instancesInfo;
    }

    public int getDiskSize() {
        return this.diskSize;
    }

    public void setDiskSize(int diskSize) {
        this.diskSize = diskSize;
    }

    public String getCloudService() {
        return this.cloudService;
    }

    public void setCloudService(String cloudService) {
        this.cloudService = cloudService;
    }

    public VirtualHardDiskHostCaching getHostCaching() {
        return this.hostCache;
    }

    public void setHostCaching(VirtualHardDiskHostCaching hostCache) {
        this.hostCache = hostCache;
    }

    public Integer getLun() {
        return this.lun;
    }

    public void setLun(Integer lun) {
        this.lun = lun;
    }

    public static class VolumeProvider {
        private VolumeContentProvider vcp = new VolumeContentProvider();
        private VolumeLabelProvider vlp = new VolumeLabelProvider();

        public VolumeContentProvider getVolumeContentProvider() {
            return this.vcp;
        }

        public VolumeLabelProvider getVolumeLabelProvider() {
            return this.vlp;
        }

        public class VolumeLabelProvider
        extends LabelProvider
        implements ITableLabelProvider {
            public String getColumnText(Object element, int columnIndex) {
                ICloudStorage storage = (ICloudStorage)element;
                switch (columnIndex) {
                    case 0: {
                        return storage.getStorageId();
                    }
                    case 1: {
                        return storage.getStorageAttachment() != null ? storage.getStorageAttachment().getDevice() : "";
                    }
                    case 2: {
                        return storage.getSnapshotId() != null ? storage.getSnapshotId() : "";
                    }
                    case 3: {
                        return storage.getSize() != null ? String.valueOf(storage.getSize()) : "";
                    }
                    case 4: {
                        return storage.getFlavor();
                    }
                }
                return null;
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }
        }

        public class VolumeContentProvider
        implements IStructuredContentProvider {
            public Object[] getElements(Object inputElement) {
                return ((List)inputElement).toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }
    }
}

