/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.azure.base.ui.dialogs;

import com.clustercontrol.cloud.azure.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.presenter.ICloudInstance;
import com.clustercontrol.cloud.presenter.ICloudStorage;
import com.clustercontrol.ws.azure.DataVirtualHardDisks;
import com.clustercontrol.ws.azure.VirtualHardDiskHostCaching;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

public class AttachStorageFromInstanceDialog
extends Dialog {
    private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
    private String strInstance = this.messages.getString("word.instance");
    private String strLun = this.messages.getString("word.lun");
    private String strHostCacheConfig = this.messages.getString("word.host_cache_config");
    private String strHostCacheNone = this.messages.getString("word.host_cache_none");
    private String strHostCacheReadOnly = this.messages.getString("word.host_cache_read_only");
    private String strHostCacheReadWrite = this.messages.getString("word.host_cache_read_write");
    private String strDiscName = this.messages.getString("word.disc_name");
    private String strOs = this.messages.getString("word.os");
    private String strSubscription = this.messages.getString("word.subscription");
    private String strSpot = this.messages.getString("word.spot");
    private String strAttachStorageDialog = this.messages.getString("caption.attach_storage_dialog");
    private ICloudInstance instance;
    private Table table;
    private Text instanceName;
    private Combo cmblun;
    private Button btnHostCacheNone;
    private Button btnHostCacheReadOnly;
    private Button btnHostCacheReadWrite;
    private String storageId;
    private String deviceName;
    List<String> luns;
    String subscriptionId;
    List<DataVirtualHardDisks> dataVirtualHardDisks;
    String uri;
    String storageAccountName;
    VirtualHardDiskHostCaching hostCache;
    Integer lun;

    public AttachStorageFromInstanceDialog(Shell parentShell, ICloudInstance instance) {
        super(parentShell);
        this.instance = instance;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setBackground(SWTResourceManager.getColor((int)22));
        GridLayout gl_container = new GridLayout(2, false);
        container.setLayout((Layout)gl_container);
        GridData gd_container = new GridData(1808);
        gd_container.widthHint = 614;
        container.setLayoutData((Object)gd_container);
        Label lblInstance = new Label(container, 0);
        lblInstance.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblInstance.setText(this.strInstance);
        this.instanceName = new Text(container, 2056);
        this.instanceName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.instanceName.setText(this.instance.getInstanceId());
        Label lblLun = new Label(container, 0);
        lblLun.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblLun.setText(this.strLun);
        this.cmblun = new Combo(container, 8);
        this.cmblun.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.cmblun.removeAll();
        for (String lunName : this.luns) {
            this.cmblun.add(lunName);
        }
        this.cmblun.select(0);
        Group grpHostCache = new Group(container, 0);
        GridLayout gl_hostCache = new GridLayout(3, false);
        grpHostCache.setLayout((Layout)gl_hostCache);
        GridData gd_hostCache = new GridData(4, 0x1000000, true, false, 4, 1);
        gd_hostCache.horizontalSpan = 4;
        grpHostCache.setLayoutData((Object)gd_hostCache);
        grpHostCache.setText(this.strHostCacheConfig);
        this.btnHostCacheNone = new Button((Composite)grpHostCache, 16);
        this.btnHostCacheNone.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnHostCacheNone.setSelection(true);
        this.btnHostCacheNone.setText(this.strHostCacheNone);
        this.btnHostCacheReadOnly = new Button((Composite)grpHostCache, 16);
        this.btnHostCacheReadOnly.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnHostCacheReadOnly.setText(this.strHostCacheReadOnly);
        this.btnHostCacheReadWrite = new Button((Composite)grpHostCache, 16);
        this.btnHostCacheReadWrite.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.btnHostCacheReadWrite.setText(this.strHostCacheReadWrite);
        this.table = new Table(container, 67584);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        TableColumn tblclmnVolumeId = new TableColumn(this.table, 0);
        tblclmnVolumeId.setWidth(160);
        tblclmnVolumeId.setText(this.strDiscName);
        TableColumn tableColumn_6 = new TableColumn(this.table, 0);
        tableColumn_6.setWidth(100);
        tableColumn_6.setText(this.strOs);
        TableColumn tableColumn_1 = new TableColumn(this.table, 0);
        tableColumn_1.setWidth(160);
        tableColumn_1.setText(this.strSubscription);
        TableColumn tableColumn_2 = new TableColumn(this.table, 0);
        tableColumn_2.setWidth(160);
        tableColumn_2.setText(this.strSpot);
        ArrayList<ICloudStorage> availableVolumes = new ArrayList<ICloudStorage>(Arrays.asList(this.instance.getCloudInstanceManager().getCloudComputeService().getStorageManager().getCloudStorages()));
        for (ICloudStorage storage : availableVolumes) {
            if (storage.getStorageId() == null || !storage.getState().equals(ICloudStorage.State.available.name())) continue;
            TableItem item = new TableItem(this.table, 0);
            for (int i = 0; i < this.dataVirtualHardDisks.size(); ++i) {
                if (this.dataVirtualHardDisks.get(i).getName() == null || !storage.getStorageId().equals(this.dataVirtualHardDisks.get(i).getName()) || this.dataVirtualHardDisks.get(i).getMediaLink() == null) continue;
                this.uri = this.dataVirtualHardDisks.get(i).getMediaLink();
            }
            String[] data = new String[]{storage.getStorageId(), storage.getFlavor(), this.subscriptionId, this.uri};
            item.setText(data);
            this.table.setSelection(0);
        }
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(640, 480);
    }

    protected void okPressed() {
        this.storageId = this.table.getItem(this.table.getSelectionIndex()).getText(0);
        this.lun = Integer.parseInt(this.cmblun.getText());
        this.hostCache = this.btnHostCacheReadOnly.getSelection() ? VirtualHardDiskHostCaching.READ_ONLY : (this.btnHostCacheReadWrite.getSelection() ? VirtualHardDiskHostCaching.READ_WRITE : VirtualHardDiskHostCaching.NONE);
        this.deviceName = "";
        this.setReturnCode(0);
        this.close();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.strAttachStorageDialog);
    }

    public List<String> getLuns() {
        return this.luns;
    }

    public void setLuns(List<String> luns) {
        this.luns = luns;
    }

    public String getStorageId() {
        return this.storageId;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getStorageAccountName() {
        return this.storageAccountName;
    }

    public void setStorageAccountName(String storageAccountName) {
        this.storageAccountName = storageAccountName;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public List<DataVirtualHardDisks> getDataVirtualHardDisks() {
        return this.dataVirtualHardDisks;
    }

    public void setDataVirtualHardDisks(List<DataVirtualHardDisks> dataVirtualHardDisks) {
        this.dataVirtualHardDisks = dataVirtualHardDisks;
    }

    public VirtualHardDiskHostCaching getHostCaching() {
        return this.hostCache;
    }

    public void setHostCaching(VirtualHardDiskHostCaching hostCache) {
        this.hostCache = hostCache;
    }

    public Integer getLun() {
        return this.lun;
    }

    public void setLun(Integer lun) {
        this.lun = lun;
    }
}

