/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.azure.base.resources;

import com.clustercontrol.cloud.azure.base.Activator;
import com.clustercontrol.cloud.azure.base.resources.AvailabilityZone;
import com.clustercontrol.cloud.azure.base.resources.CloudResourceProvider;
import com.clustercontrol.cloud.commons.util.AccountControlUtil;
import com.clustercontrol.cloud.presenter.CloudModelException;
import com.clustercontrol.ws.azure.AzureCreateInstanceRequest;
import com.clustercontrol.ws.azure.AzureCreateStorageRequest;
import com.clustercontrol.ws.azure.AzureImage;
import com.clustercontrol.ws.azure.AzureOptionEndpoint;
import com.clustercontrol.ws.azure.AzureRestoreStorageRequest;
import com.clustercontrol.ws.azure.DataVirtualHardDisks;
import com.clustercontrol.ws.azure.InstanceInfo;
import com.clustercontrol.ws.azure.SnapShotInfo;
import com.clustercontrol.ws.cloud.CloudEndpoint;
import com.clustercontrol.ws.cloud.CloudManagerFault_Exception;
import com.clustercontrol.ws.cloud.CloudRegion;
import com.clustercontrol.ws.cloud.CloudService;
import com.clustercontrol.ws.cloud.InvalidRole_Exception;
import com.clustercontrol.ws.cloud.InvalidUserPass_Exception;
import com.clustercontrol.ws.cloud.Zone;
import java.util.ArrayList;
import java.util.List;

public class CloudResourceProviderImpl
implements CloudResourceProvider {
    private AzureOptionEndpoint azureEndpoint = Activator.getEndpointManager().getEndpoint(AzureOptionEndpoint.class);
    private CloudEndpoint cloudEndpoint = Activator.getEndpointManager().getEndpoint(CloudEndpoint.class);
    private String serviceId;
    private String roleId;

    public CloudResourceProviderImpl(String accountResourceId) {
        try {
            for (CloudService cloudService : this.cloudEndpoint.getAllCloudServices()) {
                if (!cloudService.getCloudServiceId().equals("Azure")) continue;
                this.serviceId = cloudService.getCloudServiceId();
            }
        }
        catch (CloudManagerFault_Exception | InvalidRole_Exception | InvalidUserPass_Exception e) {
            new CloudModelException(e);
        }
        this.roleId = AccountControlUtil.getRoleId((String)accountResourceId);
    }

    @Override
    public List<String> getAllRegion() {
        try {
            ArrayList<String> regions = new ArrayList<String>();
            for (CloudRegion r : this.cloudEndpoint.getCloudRegionsByService(this.serviceId)) {
                regions.add(r.getRegion());
            }
            return regions;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<AvailabilityZone> getAvailabilityZones(String region) {
        try {
            ArrayList<AvailabilityZone> azs = new ArrayList<AvailabilityZone>();
            for (Zone wsAZ : this.cloudEndpoint.getZones(this.roleId, region)) {
                AvailabilityZone az = new AvailabilityZone();
                az.setZoneName(wsAZ.getName());
                azs.add(az);
            }
            return azs;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<String> getAllInstanceType() {
        try {
            return this.cloudEndpoint.getInstanceFlavorsByService(this.serviceId);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<String> getAllVolumeType() {
        try {
            ArrayList<String> volumeTypes = new ArrayList<String>();
            for (String v : this.cloudEndpoint.getStorageFlavorsByService(this.serviceId)) {
                volumeTypes.add(v);
            }
            return volumeTypes;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<String> getAllServiceName() {
        try {
            return null;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<InstanceInfo> getInstanceByCloudService(String regionName, String cloudServiceName) {
        try {
            ArrayList<InstanceInfo> azureInstance = new ArrayList<InstanceInfo>();
            for (InstanceInfo v : this.azureEndpoint.getInstanceByCloudService(this.roleId, regionName, cloudServiceName)) {
                azureInstance.add(v);
            }
            return azureInstance;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<String> getStorageAccountByRegion(String regionName) {
        try {
            ArrayList<String> azureStorageAccount = new ArrayList<String>();
            for (String v : this.azureEndpoint.getStorageAccountByRegion(this.roleId, regionName)) {
                azureStorageAccount.add(v);
            }
            return azureStorageAccount;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String getRegionByCloudService(String regionName, String cloudServiceName) {
        try {
            return this.azureEndpoint.getRegionByCloudService(this.roleId, regionName, cloudServiceName);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<String> getStorageAccountByCloudService(String regionName, String cloudServiceName) {
        try {
            ArrayList<String> azureStorageAccount = new ArrayList<String>();
            for (String v : this.azureEndpoint.getStorageAccountByCloudService(this.roleId, regionName, cloudServiceName)) {
                azureStorageAccount.add(v);
            }
            return azureStorageAccount;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<String> getContainerByStorageAccount(String regionName, String cloudServiceName) {
        try {
            ArrayList<String> containers = new ArrayList<String>();
            for (String v : this.azureEndpoint.getContainerByStorageAccount(this.roleId, regionName, cloudServiceName)) {
                containers.add(v);
            }
            return containers;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void addStorage(String regionName, AzureCreateStorageRequest request) {
        try {
            this.azureEndpoint.addStorage(this.roleId, regionName, request);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void createInstance(String regionName, AzureCreateInstanceRequest request) {
        try {
            this.azureEndpoint.createInstance(this.roleId, regionName, request);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<AzureImage> getImages(String region, String filter) {
        try {
            ArrayList<AzureImage> images = new ArrayList<AzureImage>();
            for (AzureImage v : this.azureEndpoint.getImagesWithFilter(this.roleId, region, filter)) {
                images.add(v);
            }
            return images;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public List<DataVirtualHardDisks> getDataVirtualHardDisk(String region, String instanceId) {
        try {
            ArrayList<DataVirtualHardDisks> dvhds = new ArrayList<DataVirtualHardDisks>();
            for (DataVirtualHardDisks v : this.azureEndpoint.getAttacheableDataVirtualHardDisk(this.roleId, region, instanceId)) {
                dvhds.add(v);
            }
            return dvhds;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public SnapShotInfo getSnapShotInfo(String region, String snapShotId, String storageId) {
        try {
            return this.azureEndpoint.getSnapShotInfo(this.roleId, region, snapShotId, storageId);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void restoreStorage(String region, AzureRestoreStorageRequest request) {
        try {
            this.azureEndpoint.restoreStorage(this.roleId, region, request);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void detachStorage(String region, String instanceID, String storageID) {
        try {
            this.azureEndpoint.detachStorage(this.roleId, region, instanceID, storageID);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void atachStorage(String region, String instanceID, String storageID, AzureCreateStorageRequest request) {
        try {
            this.azureEndpoint.atachStorage(this.roleId, region, storageID, request);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

