/*

 Copyright (C) 2008 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.snmptrap.factory;

import java.util.ArrayList;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.fault.MonitorNotFound;
import com.clustercontrol.snmptrap.bean.SnmpTrapMasterInfo;
import com.clustercontrol.snmptrap.entity.SnmpTrapMibMasterData;
import com.clustercontrol.snmptrap.model.SnmpTrapMstEntityPK;
import com.clustercontrol.snmptrap.util.SnmpTrapMasterCache;
import com.clustercontrol.snmptrap.util.SnmpTrapMibMasterCache;

/**
 * MIBマスター情報検索クラス
 *
 * @version 4.0.0
 * @since 2.4.0
 * @author Yosuke
 */
public class SelectMibMaster {

	private static Log m_log = LogFactory.getLog( SelectMibMaster.class );

	/**
	 * MIBマスターの詳細情報を取得します。
	 * 
	 * @param mib マスター情報がほしいMIB
	 * @return　MIBマスターの詳細情報
	 * @throws MonitorNotFound
	 */
	public SnmpTrapMibMasterData getMibMasterData(String mib) throws MonitorNotFound {
		m_log.debug("getMibMasterData() : start mib = " + mib);

		SnmpTrapMibMasterData mibData = SnmpTrapMibMasterCache.getMibMasterInfo(mib);

		m_log.debug("getMibMasterData() : end mib = " + mib);
		return mibData;
	}

	/**
	 * MIB一覧を取得します。
	 * 
	 * @return
	 */
	public ArrayList<String> getMibList() {
		m_log.debug("getMibList() : start");

		ArrayList<String> mibList = SnmpTrapMibMasterCache.getMibList();

		m_log.debug("getMibList() : end");
		return mibList;
	}

	/**
	 * マスタ情報一覧を取得します。
	 * 
	 * @return
	 */
	public ArrayList<SnmpTrapMasterInfo> getMasterList(String mib) {
		m_log.debug("getMasterList() : start mib = " + mib);

		ArrayList<SnmpTrapMasterInfo> masterList = SnmpTrapMasterCache.getMasterList(mib);

		m_log.debug("getMasterList() : end mib = " + mib);
		return masterList;
	}

	/**
	 * SNMPトラップマスター情報を取得します。
	 * @param trapOid
	 * @param genericId
	 * @param specificId
	 * @return SNMPトラップマスター情報
	 */
	public SnmpTrapMasterInfo findMasterInfo(String trapOid, int genericId, int specificId) {
		m_log.debug("findMasterInfo() : start trapOid = " + trapOid + ",genericId = " + genericId + ",specificId = " + specificId);

		SnmpTrapMasterInfo info = SnmpTrapMasterCache.findMasterInfo(trapOid, genericId, specificId);

		m_log.debug("findMasterInfo() : end trapOid = " + trapOid + ",genericId = " + genericId + ",specificId = " + specificId);
		return info;

	}

	/**
	 * マスター情報を取得します。
	 * 
	 * @return マスター情報
	 */
	public SnmpTrapMasterInfo getMasterInfo(SnmpTrapMstEntityPK pk) {
		m_log.debug("getMasterInfo() : start");

		SnmpTrapMasterInfo info = SnmpTrapMasterCache.getMasterInfo(pk);

		m_log.debug("getMasterInfo() : end");
		return info;
	}
}
