/*

Copyright (C) 2008 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.snmptrap.factory;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.fault.MonitorNotFound;
import com.clustercontrol.snmptrap.bean.SnmpTrapMasterInfo;
import com.clustercontrol.snmptrap.model.SnmpTrapMstEntity;
import com.clustercontrol.snmptrap.util.QueryUtil;

/**
 *　OIDマスター情報を変更するクラス<BR>
 *
 * @version 3.0.0
 * @since 2.4.0
 * @author Yosuke
 */
public class ModifyOidMaster {

	private static Log m_log = LogFactory.getLog( ModifyOidMaster.class );


	private SnmpTrapMasterInfo m_OidData;

	/**
	 * OIDマスター情報を変更します。
	 * 
	 * @param oidData　変更するマスター情報
	 * @param user　変更実行ユーザ
	 * @return
	 * @throws MonitorNotFound
	 */
	public boolean modify(SnmpTrapMasterInfo oidData, String user) throws MonitorNotFound {

		m_OidData = oidData;

		boolean result = false;

		// 監視情報を登録
		result = modifyOIDMaster(user);

		return result;
	}

	/**
	 * OIDマスター情報の変更を行う。
	 * @param user　変更実行ユーザ
	 * 
	 * @return
	 * @throws MonitorNotFound
	 */
	public boolean modifyOIDMaster(String user) throws MonitorNotFound {
		boolean result = false;

		// 監視情報を検索
		SnmpTrapMstEntity entity = QueryUtil.getSnmpTrapMstPK(
				m_OidData.getMib(),
				m_OidData.getTrapOid(),
				m_OidData.getGenericId(),
				m_OidData.getSpecificId());

		entity.setUei(m_OidData.getUei());
		entity.setPriority(m_OidData.getPriority());
		entity.setLogmsg(m_OidData.getLogmsg());
		entity.setDescr(m_OidData.getDescr());

		result = true;
		return result;
	}
}
