package com.clustercontrol.nodemap.model;

import java.io.Serializable;
import javax.persistence.*;

import com.clustercontrol.commons.util.JpaTransactionManager;

import java.util.List;


/**
 * The persistent class for the cc_map_bg_image database table.
 * 
 */
@Entity
@Table(name="cc_map_bg_image")
@Cacheable(true)
public class MapBgImageEntity implements Serializable {
	private static final long serialVersionUID = 1L;
	private String filename;
	private byte[] filedata;
	private List<MapInfoEntity> mapInfoEntities;

	@Deprecated
	public MapBgImageEntity() {
	}

	public MapBgImageEntity(String filename) {
		this.setFilename(filename);
		EntityManager em = new JpaTransactionManager().getEntityManager();
		em.persist(this);
	}


	@Id
	public String getFilename() {
		return this.filename;
	}

	public void setFilename(String filename) {
		this.filename = filename;
	}


	public byte[] getFiledata() {
		return this.filedata;
	}

	public void setFiledata(byte[] filedata) {
		this.filedata = filedata;
	}


	//bi-directional many-to-one association to MapInfoEntity
	@OneToMany(mappedBy="mapBgImageEntity", fetch=FetchType.LAZY)
	public List<MapInfoEntity> getMapInfoEntities() {
		return this.mapInfoEntities;
	}

	public void setMapInfoEntities(List<MapInfoEntity> mapInfoEntities) {
		this.mapInfoEntities = mapInfoEntities;
	}

}