/*

Copyright (C) 2010 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.commons.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.HinemosModuleConstant;

public class AsyncTaskPersistentConfig {

	private static Log log = LogFactory.getLog(AsyncTaskPersistentConfig.class);

	public static final String  _MONITOR_AGENT_KEY = "async.task.persist.monitor.agent";
	public static final boolean _MONITOR_AGENT_DEFAULT = false;
	public static final boolean _MONITOR_AGENT;

	public static final String _MONITOR_CUSTOM_KEY = "async.task.persist.monitor.custom";
	public static final boolean _MONITOR_CUSTOM_DEFAULT = false;
	public static final boolean _MONITOR_CUSTOM;

	public static final String  _MONITOR_HTTP_KEY = "async.task.persist.monitor.http";
	public static final boolean _MONITOR_HTTP_DEFAULT = false;
	public static final boolean _MONITOR_HTTP;

	public static final String  _MONITOR_PERFORMANCE_KEY = "async.task.persist.monitor.performance";
	public static final boolean _MONITOR_PERFORMANCE_DEFAULT = false;
	public static final boolean _MONITOR_PERFORMANCE;

	public static final String  _MONITOR_PING_KEY = "async.task.persist.monitor.ping";
	public static final boolean _MONITOR_PING_DEFAULT = false;
	public static final boolean _MONITOR_PING;

	public static final String  _MONITOR_PORT_KEY = "async.task.persist.monitor.port";
	public static final boolean _MONITOR_PORT_DEFAULT = false;
	public static final boolean _MONITOR_PORT;

	public static final String  _MONITOR_PROCESS_KEY = "async.task.persist.monitor.process";
	public static final boolean _MONITOR_PROCESS_DEFAULT = false;
	public static final boolean _MONITOR_PROCESS;

	public static final String  _MONITOR_SNMPTRAP_KEY = "async.task.persist.monitor.snmptrap";
	public static final boolean _MONITOR_SNMPTRAP_DEFAULT = false;
	public static final boolean _MONITOR_SNMPTRAP;

	public static final String  _MONITOR_SNMP_KEY = "async.task.persist.monitor.snmp";
	public static final boolean _MONITOR_SNMP_DEFAULT = false;
	public static final boolean _MONITOR_SNMP;

	public static final String  _MONITOR_SQL_KEY = "async.task.persist.monitor.sql";
	public static final boolean _MONITOR_SQL_DEFAULT = false;
	public static final boolean _MONITOR_SQL;

	public static final String  _MONITOR_SYSTEMLOG_KEY = "async.task.persist.monitor.syslog";
	public static final boolean _MONITOR_SYSTEMLOG_DEFAULT = false;
	public static final boolean _MONITOR_SYSTEMLOG;

	public static final String  _MONITOR_LOGFILE_KEY = "async.task.persist.monitor.logfile";
	public static final boolean _MONITOR_LOGFILE_DEFAULT = false;
	public static final boolean _MONITOR_LOGFILE;

	public static final String  _JOB_KEY = "async.task.persist.job";
	public static final boolean _JOG_DEFAULT = true;
	public static final boolean _JOB;

	public static final String  _MAINTENANCE_KEY = "async.task.persist.maintenance";
	public static final boolean _MAINTENANCE_DEFAULT = true;
	public static final boolean _MAINTENANCE;

	static {
		_MONITOR_AGENT = getConfig(_MONITOR_AGENT_KEY, _MONITOR_AGENT_DEFAULT);
		_MONITOR_CUSTOM = getConfig(_MONITOR_CUSTOM_KEY, _MONITOR_CUSTOM_DEFAULT);
		_MONITOR_HTTP  = getConfig(_MONITOR_HTTP_KEY, _MONITOR_HTTP_DEFAULT);
		_MONITOR_PERFORMANCE = getConfig(_MONITOR_PERFORMANCE_KEY, _MONITOR_PERFORMANCE_DEFAULT);
		_MONITOR_PING = getConfig(_MONITOR_PING_KEY, _MONITOR_PING_DEFAULT);
		_MONITOR_PORT = getConfig(_MONITOR_PORT_KEY, _MONITOR_PORT_DEFAULT);
		_MONITOR_PROCESS = getConfig(_MONITOR_PROCESS_KEY, _MONITOR_PROCESS_DEFAULT);
		_MONITOR_SNMPTRAP = getConfig(_MONITOR_SNMPTRAP_KEY, _MONITOR_SNMPTRAP_DEFAULT);
		_MONITOR_SNMP = getConfig(_MONITOR_SNMP_KEY, _MONITOR_SNMP_DEFAULT);
		_MONITOR_SQL = getConfig(_MONITOR_SQL_KEY, _MONITOR_SQL_DEFAULT);
		_MONITOR_SYSTEMLOG = getConfig(_MONITOR_SYSTEMLOG_KEY, _MONITOR_SYSTEMLOG_DEFAULT);
		_MONITOR_LOGFILE = getConfig(_MONITOR_LOGFILE_KEY, _MONITOR_LOGFILE_DEFAULT);

		_JOB = getConfig(_JOB_KEY, _JOG_DEFAULT);
		_MAINTENANCE = getConfig(_MAINTENANCE_KEY, _MAINTENANCE_DEFAULT);
	}

	/**
	 * 該当のモジュール種別からの出力結果を永続化させるかどうかを返します。
	 */
	public static boolean isPersisted(String typeId) {
		boolean ret = true;

		if ( HinemosModuleConstant.MONITOR_AGENT.equals(typeId) ) {
			ret = _MONITOR_AGENT;
		} else if ( HinemosModuleConstant.MONITOR_CUSTOM.equals(typeId) ) {
			ret = _MONITOR_CUSTOM;
		} else if ( HinemosModuleConstant.MONITOR_HTTP.equals(typeId) ) {
			ret = _MONITOR_HTTP;
		} else if ( HinemosModuleConstant.MONITOR_PERFORMANCE.equals(typeId) ) {
			ret = _MONITOR_PERFORMANCE;
		} else if ( HinemosModuleConstant.MONITOR_PING.equals(typeId) ) {
			ret = _MONITOR_PING;
		} else if ( HinemosModuleConstant.MONITOR_PORT.equals(typeId) ) {
			ret = _MONITOR_PORT;
		} else if ( HinemosModuleConstant.MONITOR_PROCESS.equals(typeId) ) {
			ret = _MONITOR_PROCESS;
		} else if ( HinemosModuleConstant.MONITOR_SNMPTRAP.equals(typeId) ) {
			ret = _MONITOR_SNMPTRAP;
		} else if ( HinemosModuleConstant.MONITOR_SNMP.equals(typeId) ) {
			ret = _MONITOR_SNMP;
		} else if ( HinemosModuleConstant.MONITOR_SQL.equals(typeId) ) {
			ret = _MONITOR_SQL;
		} else if ( HinemosModuleConstant.MONITOR_SYSTEMLOG.equals(typeId) ) {
			ret = _MONITOR_SYSTEMLOG;
		} else if ( HinemosModuleConstant.MONITOR_LOGFILE.equals(typeId) ) {
			ret = _MONITOR_LOGFILE;
		} else if ( HinemosModuleConstant.JOB.equals(typeId) ) {
			ret = _JOB;
		} else if ( HinemosModuleConstant.SYSYTEM_MAINTENANCE.equals(typeId) ) {
			ret = _MAINTENANCE;
		}

		return ret;
	}

	private static boolean getConfig(String key, boolean def) {
		String str = null;
		boolean ret = def;

		try {
			// プロパティファイルから該当するキーの値を読み込む
			str = HinemosProperties.getProperty(key);

			if (str != null) {
				ret = Boolean.TRUE.toString().equalsIgnoreCase(str);
			}
		} finally {
			log.info("initialized async task persistency (" + key + ") :" + ret);
		}

		return ret;
	}
}
