/*

Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

/**
 * JAX-WSによるWEBサービスの初期化(publish)/停止(stop)を制御するHinemos本体のエージェント接続用プラグイン.
 * 
 * @author nagatsumas
 */
package com.clustercontrol.plugin.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.commons.util.HinemosProperties;
import com.clustercontrol.commons.util.MonitoredThreadPoolExecutor;
import com.clustercontrol.plugin.api.HinemosPlugin;
import com.clustercontrol.ws.agent.AgentEndpoint;

public class WebServiceAgentPlugin extends WebServicePlugin implements HinemosPlugin {

	public static final Log log = LogFactory.getLog(WebServiceCorePlugin.class);

	private static final ThreadPoolExecutor _threadPoolForAgent;
	public static final int _threadPoolSizeForAgent;
	public static final int _queueSizeForAgent;
	public static final long _shutdownTimeoutForAgent;

	static {
		_threadPoolSizeForAgent = Integer.parseInt(HinemosProperties.getProperty("agent.ws.threadpool.size" , "8"));
		_queueSizeForAgent = Integer.parseInt(HinemosProperties.getProperty("agent.ws.queue.size" , "1200"));
		_shutdownTimeoutForAgent = Long.parseLong(HinemosProperties.getProperty("agent.ws.shutdown.timeout" , "60000"));

		_threadPoolForAgent = new MonitoredThreadPoolExecutor(_threadPoolSizeForAgent, _threadPoolSizeForAgent, 0L, TimeUnit.MICROSECONDS,
				new LinkedBlockingQueue<Runnable>(_queueSizeForAgent),
				new ThreadFactory() {
			private volatile int _count = 0;
			@Override
			public Thread newThread(Runnable r) {
				return new Thread(r, "WebServiceWorkerForAgent-" + _count++);
			}
		}, new ThreadPoolExecutor.AbortPolicy());
	}

	@Override
	public Set<String> getDependency() {
		Set<String> dependency = new HashSet<String>();
		dependency.add(WebServiceJobMapPlugin.class.getName());
		dependency.add(WebServiceNodeMapPlugin.class.getName());
		dependency.add(WebServiceCorePlugin.class.getName());
		return dependency;
	}

	@Override
	public void create() {

	}

	@Override
	public void activate() {
		/** Webサービスの起動処理 */
		final String addressPrefix = HinemosProperties.getProperty("common.ws.agent.address" , "http://0.0.0.0:8080");
		publish(addressPrefix, "/HinemosWS/AgentEndpoint", new AgentEndpoint(), _threadPoolForAgent);
	}

	@Override
	public void deactivate() {
		// 許容時間まで待ちリクエストを処理する
		_threadPoolForAgent.shutdown();
		try {
			if (! _threadPoolForAgent.awaitTermination(_shutdownTimeoutForAgent, TimeUnit.MILLISECONDS)) {
				List<Runnable> remained = _threadPoolForAgent.shutdownNow();
				if (remained != null) {
					log.info("shutdown timeout. runnable remained. (size = " + remained.size() + ")");
				}
			}
		} catch (InterruptedException e) {
			_threadPoolForAgent.shutdownNow();
		}

		super.deactivate();
	}

}
