/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.snmptrap.dialog;

import java.util.ArrayList;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.Property;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.snmptrap.action.GetSnmpTrapModifyProperty;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.PropertyUtil;
import com.clustercontrol.viewer.PropertySheet;
import com.clustercontrol.ws.monitor.MonitorTrapValueInfo;

/**
 * トラップ定義変更ダイアログクラス<BR>
 * 
 * @version 4.0.0
 * @since 2.1.0
 */
public class SnmpTrapModifyDialog extends CommonDialog {
	/** プロパティシート */
	private PropertySheet viewer = null;

	private Shell shell = null;

	private MonitorTrapValueInfo oidInfo = null;

	/**
	 * コンストラクタ
	 * 
	 * @param parent
	 */
	public SnmpTrapModifyDialog(Shell parent) {
		super(parent);
		setShellStyle(getShellStyle() | SWT.RESIZE | SWT.MAX);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.clustercontrol.dialog.CommonDialog#customizeDialog(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	protected void customizeDialog(Composite parent) {
		shell = this.getShell();

		parent.getShell().setText(Messages.getString("dialog.snmptrap.modify.definition"));

		GridLayout layout = new GridLayout(1, true);
		layout.marginWidth = 10;
		layout.marginHeight = 10;
		parent.setLayout(layout);

		Label tableTitle = new Label(parent, SWT.NONE);
		tableTitle.setText(Messages.getString("attribute") + " : ");
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.horizontalSpan = 1;
		tableTitle.setLayoutData(gridData);

		TableTree table = new TableTree(parent, SWT.BORDER | SWT.H_SCROLL
				| SWT.V_SCROLL | SWT.FULL_SELECTION | SWT.MULTI);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		gridData.horizontalSpan = 1;
		table.setLayoutData(gridData);

		viewer = new PropertySheet(table);

		viewer.setInput(new GetSnmpTrapModifyProperty().getProperty());

		Label line = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.horizontalSpan = 1;
		line.setLayoutData(gridData);

		// 画面中央に
		Display display = shell.getDisplay();
		shell.setLocation(
				(display.getBounds().width - shell.getSize().x) / 2, (display
						.getBounds().height - shell.getSize().y) / 2);

		//開始条件反映
		reflectOidInfo();

		viewer.expandAll();
	}

	/**
	 * OID情報反映
	 * 
	 */
	private void reflectOidInfo() {
		Property property = null;

		if (oidInfo instanceof MonitorTrapValueInfo) {

			//判定対象がジョブの場合
			property = new GetSnmpTrapModifyProperty().getProperty();

			//MIB
			ArrayList<Property> propertyList = PropertyUtil.getProperty(property, GetSnmpTrapModifyProperty.ID_MIB);
			Property mib = (Property) propertyList.get(0);
			mib.setValue(oidInfo.getMib());

			//トラップ名
			propertyList =
					PropertyUtil.getProperty(
							property, GetSnmpTrapModifyProperty.ID_TRAP_NAME);
			Property trapName = (Property) propertyList.get(0);
			trapName.setValue(oidInfo.getUei());

			//トラップOID
			propertyList =
					PropertyUtil.getProperty(
							property, GetSnmpTrapModifyProperty.ID_TRAP_OID);
			Property trapOid = (Property) propertyList.get(0);
			trapOid.setValue(oidInfo.getTrapOid());

			//generic_id
			propertyList =
					PropertyUtil.getProperty(
							property, GetSnmpTrapModifyProperty.ID_GENERIC_ID);
			Property genericId = (Property) propertyList.get(0);
			genericId.setValue(Integer.toString(oidInfo.getGenericId()));

			//specific_id
			propertyList =
					PropertyUtil.getProperty(
							property, GetSnmpTrapModifyProperty.ID_SPRCIFIC_ID);
			Property specificId = (Property) propertyList.get(0);
			specificId.setValue(Integer.toString(oidInfo.getSpecificId()));

			//有効無効
			propertyList =
					PropertyUtil.getProperty(
							property, GetSnmpTrapModifyProperty.ID_VALID);
			Property valid = (Property) propertyList.get(0);
			valid.setValue(new Boolean(oidInfo.isValidFlg()));

			//重要度
			propertyList =
					PropertyUtil.getProperty(
							property, GetSnmpTrapModifyProperty.ID_PRIORITY);
			Property priority = (Property) propertyList.get(0);
			priority.setValue(PriorityConstant.typeToString(oidInfo.getPriority()));

			//メッセージ
			propertyList =
					PropertyUtil.getProperty(
							property, GetSnmpTrapModifyProperty.ID_LOGMSG);
			Property logmsg = (Property) propertyList.get(0);
			logmsg.setValue(oidInfo.getLogmsg());

			//詳細メッセージ
			propertyList =
					PropertyUtil.getProperty(
							property, GetSnmpTrapModifyProperty.ID_DESCR);
			Property descr = (Property) propertyList.get(0);
			descr.setValue(oidInfo.getDescr());

			viewer.setInput(property);

			//ビュー更新
			viewer.refresh();
		}
	}

	/**
	 * OID情報取得
	 * 
	 */
	@SuppressWarnings("unchecked")
	private ValidateResult createOidInfo() {
		ValidateResult result = null;

		if (oidInfo instanceof MonitorTrapValueInfo) {
			Property property = (Property) viewer.getInput();

			//有効無効を取得
			ArrayList values = PropertyUtil.getPropertyValue(
					property, GetSnmpTrapModifyProperty.ID_VALID);
			Boolean valid = (Boolean) values.get(0);
			oidInfo.setValidFlg(valid.booleanValue());

			//重要度を取得
			values = PropertyUtil.getPropertyValue(
					property, GetSnmpTrapModifyProperty.ID_PRIORITY);
			String priority = (String) values.get(0);
			oidInfo.setPriority(PriorityConstant.stringToType(priority));

			//メッセージを取得
			values = PropertyUtil.getPropertyValue(
					property, GetSnmpTrapModifyProperty.ID_LOGMSG);
			String logmsg = (String) values.get(0);
			oidInfo.setLogmsg(logmsg);

			//詳細メッセージを取得
			values = PropertyUtil.getPropertyValue(
					property, GetSnmpTrapModifyProperty.ID_DESCR);
			String descr = (String) values.get(0);
			oidInfo.setDescr(descr);
		}

		return null;
	}

	/**
	 * ダイアログの初期サイズを返します。
	 * 
	 * @return 初期サイズ
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(400, 400);
	}

	/**
	 * 入力値を設定する
	 * 
	 * @param oidInfo
	 * @return
	 */
	public void setInputData(MonitorTrapValueInfo oidInfo) {
		this.oidInfo = oidInfo;
	}

	/**
	 * 入力値を取得する
	 * 
	 * @return
	 */
	public MonitorTrapValueInfo getInputData() {
		return oidInfo;
	}

	/**
	 * ＯＫボタンテキスト取得
	 * 
	 * @return ＯＫボタンのテキスト
	 * @since 1.0.0
	 */
	@Override
	protected String getOkButtonText() {
		return Messages.getString("ok");
	}

	/**
	 * キャンセルボタンテキスト取得
	 * 
	 * @return キャンセルボタンのテキスト
	 * @since 1.0.0
	 */
	@Override
	protected String getCancelButtonText() {
		return Messages.getString("cancel");
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see com.clustercontrol.dialog.CommonDialog#validate()
	 */
	@Override
	protected ValidateResult validate() {
		ValidateResult result = null;

		result = createOidInfo();
		if (result != null) {
			return result;
		}

		return null;
	}
}