/*

 Copyright (C) 2006 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 */

package com.clustercontrol.performance.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.bean.Property;
import com.clustercontrol.performance.dialog.PerformanceListFilterDialog;
import com.clustercontrol.performance.view.PerformanceListView;

/**
 * 性能[一覧]ビューをフィルタ表示するアクションクラス
 * 
 * @version 4.0.0
 * @since 4.0.0
 */
public class PerformanceListFilterAction implements IViewActionDelegate {
	public static final String ID = "com.clustercontrol.performance.view.action.PerformanceListFilterAction";

	/** ビュー */
	private IViewPart viewPart;

	/**
	 * ビューを保持します。ワークベンチにロードされた際に呼ばれます。
	 * 
	 * @param view ビューのインスタンス
	 * 
	 * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
	 */
	@Override
	public void init(IViewPart view) {
		this.viewPart = view;
	}

	/**
	 * 性能[グラフ]ビューを追加します。
	 * 
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	@Override
	public void run(IAction action) {

		PerformanceListView view = (PerformanceListView) this.viewPart.getAdapter(PerformanceListView.class);

		if (action.isChecked()) {
			// ダイアログを生成
			PerformanceListFilterDialog dialog = new PerformanceListFilterDialog(this.viewPart
					.getSite().getShell());

			// ダイアログにて検索が選択された場合、検索結果をビューに表示
			if (dialog.open() == IDialogConstants.OK_ID) {

				Property condition = dialog.getInputData();

				view.setCondition(condition);
				view.update();
			} else {
				action.setChecked(false);
			}
		} else {
			// 検索条件クリア
			view.setCondition(null);
			view.update();
		}


	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction,
	 *      org.eclipse.jface.viewers.ISelection)
	 */
	@Override
	public void selectionChanged(IAction action, ISelection selection) {

	}

}