/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.monitor.view.action;

import java.util.ArrayList;
import java.util.HashMap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.monitor.composite.MonitorListComposite;
import com.clustercontrol.monitor.run.action.GetMonitorListTableDefine;
import com.clustercontrol.monitor.util.MonitorSettingEndpointWrapper;
import com.clustercontrol.monitor.view.MonitorListView;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.monitor.InvalidRole_Exception;

/**
 * 監視[一覧]ビューの収集有効アクションクラス<BR>
 * 
 * @version 4.0.0
 * @since 4.0.0
 */
public class CollectorEnableAction implements IViewActionDelegate {

	// ログ
	private static Log m_log = LogFactory.getLog( CollectorEnableAction.class );

	/** アクションID */
	public static final String ID = "com.clustercontrol.monitor.view.action.CollectorEnableAction";

	/** ビュー */
	private IViewPart viewPart;

	/**
	 * アクション実行
	 */
	@Override
	public void run(IAction action) {
		// 選択アイテムの取得
		MonitorListView view = (MonitorListView) this.viewPart.getAdapter(MonitorListView.class);

		MonitorListComposite composite = (MonitorListComposite) view.getListComposite();
		StructuredSelection selection = (StructuredSelection) composite.getTableViewer().getSelection();

		Object [] objs = selection.toArray();

		// 1つも選択されていない場合
		if(objs.length == 0){
			MessageDialog.openConfirm(
					null,
					Messages.getString("confirmed"),
					Messages.getString("message.monitor.1"));
			return;
		}


		// 1つ以上選択されている場合
		String monitorId = null;
		String monitorTypeId = null;
		String[] args;
		HashMap<String, String> targetIdList = new HashMap<String, String>();
		StringBuffer targetList = new StringBuffer();
		StringBuffer successList = new StringBuffer();
		StringBuffer failureList = new StringBuffer();

		for (int i = 0; i < objs.length; i++) {
			monitorId = (String) ((ArrayList)objs[i]).get(GetMonitorListTableDefine.MONITOR_ID);
			monitorTypeId = (String) ((ArrayList)objs[i]).get(GetMonitorListTableDefine.MONITOR_TYPE_ID);

			targetIdList.put(monitorId, monitorTypeId);

			if (targetList.length() > 0) {
				targetList.append(", ");
				
			}
			targetList.append(monitorId);
		}

		// 実行確認(NG→終了)
		args = new String[]{ targetList.toString() } ;
		if (!MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				Messages.getString("message.monitor.71", args))) {
			return;
		}

		boolean hasRole = true; //設定権限を持っているかどうか
		// 実行
		for(String targetId : targetIdList.keySet()){

			monitorId = targetId;
			monitorTypeId = targetIdList.get(targetId);

			try{
				MonitorSettingEndpointWrapper.setStatusCollector(monitorId, monitorTypeId, true);
				if (successList.length() > 0) {
					successList.append(", ");
				}
				successList.append(targetId);
			} catch (InvalidRole_Exception e) {
				if (failureList.length() > 0) {
					failureList.append(", ");
				}
				failureList.append(targetId + "(" + e.getMessage() + ")");
				m_log.warn("run() setStatusCollector monitorId=" + monitorId + ", " + e.getMessage());
				hasRole = false;
			}catch (Exception e) {
				if (failureList.length() > 0) {
					failureList.append(", ");
				}
				failureList.append(targetId + "(" + e.getMessage() + ")");
				m_log.warn("run() setStatusCollector monitorId=" + monitorId + ", " + e.getMessage());
			}
		}

		if (!hasRole) {
			// 権限がない場合にはエラーメッセージを表示する
			MessageDialog.openInformation(null, Messages.getString("message"),
					Messages.getString("message.accesscontrol.16"));
		}

		// 成功ダイアログ
		if(successList.length() != 0){
			args = new String[]{ successList.toString() } ;
			MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					Messages.getString("message.monitor.72", args));
		}

		// 失敗ダイアログ
		if(failureList.length() != 0){
			args = new String[]{ failureList.toString() } ;
			MessageDialog.openError(
					null,
					Messages.getString("failed"),
					Messages.getString("message.monitor.73", args));
		}

		// ビューコンポジット更新
		composite.update();

	}

	/**
	 * 選択時のアクションの有効/無効の判定
	 */
	@Override
	public void selectionChanged(IAction action, ISelection selection) {
	}

	/**
	 * viewPartの設定
	 */
	@Override
	public void init(IViewPart view) {
		this.viewPart = view;
	}

}
