/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.jobmanagement.view.action;

import java.util.ArrayList;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.bean.PropertyDefineConstant;
import com.clustercontrol.jobmanagement.action.GetJobKickTableDefine;
import com.clustercontrol.jobmanagement.bean.JobTriggerTypeConstant;
import com.clustercontrol.jobmanagement.composite.JobKickListComposite;
import com.clustercontrol.jobmanagement.dialog.FileCheckDialog;
import com.clustercontrol.jobmanagement.dialog.ScheduleDialog;
import com.clustercontrol.jobmanagement.view.JobKickListView;

/**
 * ジョブ[実行契機]ビューの「変更」のクライアント側アクションクラス<BR>
 * 
 * @version 4.1.0
 * @since 1.0.0
 */
public class ModifyJobKickAction implements IViewActionDelegate {
	/** アクションID */
	public static final String ID = "com.clustercontrol.jobmanagement.view.action.ModifyJobKickAction";
	/** ビュー */
	private IViewPart m_view;

	/**
	 * ビューを保持します。ワークベンチにロードされた際に呼ばれます。
	 * 
	 * @param view ビューのインスタンス
	 * 
	 * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
	 */
	@Override
	public void init(IViewPart view) {
		m_view = view;
	}

	/**
	 * ジョブ[実行契機]ビューの「変更」が押された場合に、スケジュールを作成します。
	 * <p>
	 * <ol>
	 * <li>ジョブ[実行契機]ビューから選択されたスケジュール、</li>
	 * <li>または、ファイルチェックを取得します。</li>
	 * <li>ジョブ[実行契機の作成・変更]ダイアログを表示します。</li>
	 * <li>ジョブ[実行契機]ビューを更新します。</li>
	 * </ol>
	 * 
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 * @see com.clustercontrol.jobmanagement.dialog.ScheduleDialog
	 * @see com.clustercontrol.jobmanagement.dialog.FileCheckDialog
	 * @see com.clustercontrol.jobmanagement.view.JobKickListView
	 * @see com.clustercontrol.jobmanagement.composite.JobKickListComposite
	 */
	@Override
	public void run(IAction action) {
		if (m_view instanceof JobKickListView) {
			JobKickListView view = (JobKickListView) m_view
					.getAdapter(JobKickListView.class);
			JobKickListComposite composite = view.getComposite();

			ArrayList<?> item = composite.getSelectItem();
			if (item instanceof ArrayList) {
				String id = view.getSelectedId();
				String type = (String) item.get(GetJobKickTableDefine.TYPE);
				int TypeNum = JobTriggerTypeConstant.stringToType(type);
				if(TypeNum == JobTriggerTypeConstant.TYPE_SCHEDULE){
					ScheduleDialog dialog = new ScheduleDialog(PlatformUI
							.getWorkbench().getActiveWorkbenchWindow().getShell(),id, PropertyDefineConstant.MODE_MODIFY);
					dialog.open();
				}
				else if(TypeNum == JobTriggerTypeConstant.TYPE_FILECHECK){
					FileCheckDialog dialog = new FileCheckDialog(PlatformUI
							.getWorkbench().getActiveWorkbenchWindow().getShell(),id, PropertyDefineConstant.MODE_MODIFY);
					dialog.open();
				}
			}
			view.update();
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#selectionChanged(org.eclipse.jface.action.IAction, org.eclipse.jface.viewers.ISelection)
	 */
	@Override
	public void selectionChanged(IAction action, ISelection selection) {

	}
}