/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.jobmanagement.view.action;

import java.util.ArrayList;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.jobmanagement.action.GetJobKickTableDefine;
import com.clustercontrol.jobmanagement.composite.JobKickListComposite;
import com.clustercontrol.jobmanagement.util.JobEndpointWrapper;
import com.clustercontrol.jobmanagement.view.JobKickListView;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.jobmanagement.InvalidRole_Exception;

/**
 * ジョブ[スケジュール]ビューの「無効」のクライアント側アクションクラス<BR>
 * 
 * @version 4.0.0
 * @since 4.0.0
 */
public class DisableJobKickAction implements IViewActionDelegate {

	// ログ
	private static Log m_log = LogFactory.getLog( DisableJobKickAction.class );

	/** アクションID */
	public static final String ID = "com.clustercontrol.jobmanagement.view.action.DisableScheduleAction";
	/** ビュー */
	private IViewPart m_view;

	/**
	 * メイン処理
	 */
	@Override
	public void run(IAction action) {
		// 選択アイテムの取得
		JobKickListView view = (JobKickListView) this.m_view.getAdapter(JobKickListView.class);

		JobKickListComposite composite = view.getComposite();
		StructuredSelection selection = (StructuredSelection) composite.getTableViewer().getSelection();

		Object [] objs = selection.toArray();

		// 1つも選択されていない場合
		if(objs.length == 0){
			MessageDialog.openConfirm(
					null,
					Messages.getString("confirmed"),
					Messages.getString("message.job.24"));
			return;
		}


		// 1つ以上選択されている場合
		String scheduleId = null;
		String[] args;
		ArrayList<String> targetIdList = new ArrayList<String>();//処理対象のリスト
		StringBuffer targetList = new StringBuffer();//表示対象のリスト(ターゲット)
		StringBuffer successList = new StringBuffer();//表示対象のリスト(成功)
		StringBuffer failureList = new StringBuffer();//表示対象のリスト(失敗)

		for (int i = 0; i < objs.length; i++) {
			scheduleId = (String) ((ArrayList)objs[i]).get(GetJobKickTableDefine.SCHE_ID);
			targetIdList.add(scheduleId);
			targetList.append(scheduleId + "\n");
		}

		// 実行確認(NG→終了)
		args = new String[]{ targetList.toString() } ;
		if (!MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				Messages.getString("message.job.71", args))) {
			return;
		}

		boolean hasRole = true;
		// 実行
		for(String targetId : targetIdList){

			scheduleId = targetId;

			try{
				JobEndpointWrapper.setJobKickStatus(scheduleId, false);
				successList.append(targetId + "\n");
			} catch (InvalidRole_Exception e) {
				failureList.append(targetId + "\n");
				m_log.warn("run() setScheduleStatus scheduleId=" + scheduleId + ", " + e.getMessage(), e);
				hasRole = false;
			}catch (Exception e) {
				failureList.append(targetId + "\n");
				m_log.warn("run() setScheduleStatus scheduleId=" + scheduleId + ", " + e.getMessage(), e);
			}
		}

		if (!hasRole) {
			// 権限がない場合にはエラーメッセージを表示する
			MessageDialog.openInformation(null, Messages.getString("message"),
					Messages.getString("message.accesscontrol.16"));
		}

		// 成功ダイアログ
		if(successList.length() != 0){
			args = new String[]{ successList.toString() } ;
			MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					Messages.getString("message.job.72", args));
		}

		// 失敗ダイアログ
		if(failureList.length() != 0){
			args = new String[]{ failureList.toString() } ;
			MessageDialog.openError(
					null,
					Messages.getString("failed"),
					Messages.getString("message.job.73", args));
		}

		// ビューコンポジット更新
		composite.update();
	}

	/**
	 * 選択時のアクションの有効/無効の判定
	 */
	@Override
	public void selectionChanged(IAction action, ISelection selection) {
	}

	/**
	 * ビューを保持します
	 */
	@Override
	public void init(IViewPart view) {
		this.m_view = view;
	}

}
