/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.collectiverun.action;

import java.util.ArrayList;
import java.util.Locale;

import org.eclipse.swt.SWT;

import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.util.Messages;

/**
 * 一括制御[詳細]テーブル定義を取得するクライアント側アクションクラス<BR>
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class GetDetailTableDefine {

	/** 実行状態 */
	public static int STATUS = 0;

	/** 終了状態 */
	public static int END_STATUS = 1;

	/** 戻り値 */
	public static int RETURN_VALUE = 2;

	/** ファシリティID */
	public static int FACILITY_ID = 3;

	/** ファシリティ名 */
	public static int FACILITY_NAME = 4;

	/** 開始日時 */
	public static int START_TIME = 5;

	/** 終了日時 */
	public static int END_TIME = 6;

	/** メッセージ */
	public static int MESSAGE = 7;

	/** 初期表示時ソートカラム */
	public static int SORT_COLUMN_INDEX = FACILITY_ID;

	/** 初期表示時ソートオーダー */
	public static int SORT_ORDER = 1;


	/**
	 * 詳細テーブル定義を返します。
	 * 
	 * @return 詳細テーブル定義
	 */
	public static ArrayList<TableColumnInfo> get() {
		//テーブル定義配列
		ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
		Locale locale = Locale.getDefault();

		tableDefine.add(STATUS,
				new TableColumnInfo(Messages.getString("run.status", locale), TableColumnInfo.CRUN_STATUS, 70, SWT.LEFT));
		tableDefine.add(END_STATUS,
				new TableColumnInfo(Messages.getString("end.status", locale), TableColumnInfo.END_STATUS, 70, SWT.LEFT));
		tableDefine.add(RETURN_VALUE,
				new TableColumnInfo(Messages.getString("return.value", locale), TableColumnInfo.NONE, 50, SWT.LEFT));
		tableDefine.add(FACILITY_ID,
				new TableColumnInfo(Messages.getString("facility.id", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(FACILITY_NAME,
				new TableColumnInfo(Messages.getString("facility.name", locale), TableColumnInfo.NONE, 100, SWT.LEFT));
		tableDefine.add(START_TIME,
				new TableColumnInfo(Messages.getString("start.time", locale), TableColumnInfo.NONE, 140, SWT.LEFT));
		tableDefine.add(END_TIME,
				new TableColumnInfo(Messages.getString("end.time", locale), TableColumnInfo.NONE, 140, SWT.LEFT));
		tableDefine.add(MESSAGE,
				new TableColumnInfo(Messages.getString("message", locale), TableColumnInfo.TEXT_DIALOG, 300, SWT.LEFT));

		return tableDefine;
	}
}