/*

Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.calendar.view;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;

import com.clustercontrol.accesscontrol.util.ObjectBean;
import com.clustercontrol.bean.HinemosModuleConstant;
import com.clustercontrol.calendar.action.GetCalendarPatternTableDefine;
import com.clustercontrol.calendar.composite.CalendarPatternComposite;
import com.clustercontrol.calendar.view.action.CalendarPatternAddAction;
import com.clustercontrol.calendar.view.action.CalendarPatternCopyAction;
import com.clustercontrol.calendar.view.action.CalendarPatternDeleteAction;
import com.clustercontrol.calendar.view.action.CalendarPatternModifyAction;
import com.clustercontrol.view.CommonViewPart;
import com.clustercontrol.view.ObjectPrivilegeTargetListView;
import com.clustercontrol.view.action.ObjectPrivilegeAction;

/**
 * カレンダ[カレンダパターン]ビュークラス<BR>
 * 
 * @version 4.1.0
 * @since 4.1.0
 */
public class CalendarPatternView extends CommonViewPart implements ObjectPrivilegeTargetListView {
	public static final String ID = "com.clustercontrol.calendar.view.CalendarPatternView";
	private CalendarPatternComposite m_calPatternComposite = null;
	private Composite m_parent = null;

	/**
	 * コンストラクタ
	 */
	public CalendarPatternView() {
		super();
	}

	/**
	 * ViewPartへのコントロール作成処理<BR>
	 * 
	 * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public void createPartControl(Composite parent) {
		m_parent = parent;

		m_calPatternComposite = new CalendarPatternComposite(m_parent, SWT.NONE);

		//ポップアップメニュー作成
		createContextMenu();
		//ビューを更新
		this.update();
	}

	/**
	 * ポップアップメニュー作成<BR>
	 * 
	 * 
	 */
	private void createContextMenu() {
		MenuManager menuManager = new MenuManager();
		menuManager.setRemoveAllWhenShown(true);
		menuManager.addMenuListener(new IMenuListener() {
			/*
			 * (non-Javadoc)
			 * 
			 * @see org.eclipse.jface.action.IMenuListener#menuAboutToShow(org.eclipse.jface.action.IMenuManager)
			 */
			@Override
			public void menuAboutToShow(IMenuManager manager) {
				//メニュー項目設定
				fillContextMenu(manager);
			}
		});

		Menu menu = menuManager.createContextMenu(m_calPatternComposite.getTable());
		m_calPatternComposite.getTable().setMenu(menu);
	}

	/**
	 * メニュー項目追加<BR>
	 * 
	 * @param manager
	 */
	private void fillContextMenu(IMenuManager manager) {
		//ビューのアクションのインスタンスを取得
		IToolBarManager toolbar = this.getViewSite().getActionBars()
				.getToolBarManager();
		ActionContributionItem add =
				(ActionContributionItem) toolbar.find(CalendarPatternAddAction.ID);
		ActionContributionItem modify =
				(ActionContributionItem) toolbar.find(CalendarPatternModifyAction.ID);
		ActionContributionItem delete =
				(ActionContributionItem) toolbar.find(CalendarPatternDeleteAction.ID);
		ActionContributionItem copy =
				(ActionContributionItem) toolbar.find(CalendarPatternCopyAction.ID);
		ActionContributionItem objPrivilege =
				(ActionContributionItem) toolbar.find(ObjectPrivilegeAction.ID);

		//ポップアップメニューにアクションを追加
		manager.add(add.getAction());
		manager.add(modify.getAction());
		manager.add(delete.getAction());
		manager.add(new Separator());
		manager.add(copy.getAction());
		manager.add(new Separator());
		manager.add(objPrivilege.getAction());
	}

	/**
	 * カレンダ[カレンダパターン]ビュー更新<BR>
	 */
	@Override
	public void update() {
		m_calPatternComposite.update();
	}

	public String getSelectedId() {
		StructuredSelection selection = (StructuredSelection) this.m_calPatternComposite.getTableViewer().getSelection();

		List list = (List) selection.getFirstElement();
		String id = null;
		if (list != null) {
			id = (String) list.get(GetCalendarPatternTableDefine.CAL_PATTERN_ID);
		}
		return id;
	}

	@Override
	public List<ObjectBean> getSelectedObjectBeans() {
		StructuredSelection selection = (StructuredSelection) this.m_calPatternComposite.getTableViewer().getSelection();
		Object [] objs = selection.toArray();

		String objectType = HinemosModuleConstant.PLATFORM_CALENDAR_PATTERN;
		String objectId = null;
		List<ObjectBean> objectBeans = new ArrayList<ObjectBean>();
		for (Object obj : objs) {
			objectId = (String) ((List)obj).get(GetCalendarPatternTableDefine.CAL_PATTERN_ID);
			ObjectBean objectBean = new ObjectBean(objectType, objectId);
			objectBeans.add(objectBean);
		}
		return objectBeans;
	}

	@Override
	public String getSelectedOwnerRoleId() {
		StructuredSelection selection = (StructuredSelection) this.m_calPatternComposite.getTableViewer().getSelection();

		List list = (List) selection.getFirstElement();
		String id = null;
		if (list != null) {
			id = (String) list.get(GetCalendarPatternTableDefine.OWNER_ROLE);
		}
		return id;
	}


	/**
	 * ビューのアクションの有効/無効を設定します。
	 * 
	 * @param num 選択イベント数
	 * @param selection ボタン（アクション）を有効にするための情報
	 */
	public void setEnabledAction(int num, ISelection selection) {
		//ビューアクションの使用可/不可を設定
		super.setEnabledAction(CalendarPatternModifyAction.ID, selection);
		super.setEnabledAction(CalendarPatternDeleteAction.ID, selection);
		super.setEnabledAction(CalendarPatternCopyAction.ID, selection);
		super.setEnabledAction(ObjectPrivilegeAction.ID, selection);

		if (num > 0){
			super.setEnabledAction(ObjectPrivilegeAction.ID, true);
			super.setEnabledAction(CalendarPatternModifyAction.ID, true);
			super.setEnabledAction(CalendarPatternDeleteAction.ID, true);
			super.setEnabledAction(CalendarPatternCopyAction.ID, true);
		} else {
			super.setEnabledAction(ObjectPrivilegeAction.ID, false);
			super.setEnabledAction(CalendarPatternModifyAction.ID, false);
			super.setEnabledAction(CalendarPatternDeleteAction.ID, false);
			super.setEnabledAction(CalendarPatternCopyAction.ID, false);
		}
	}
}