package com.clustercontrol.ws.managercli;

import java.lang.reflect.Method;
import java.util.ArrayList;

import javax.annotation.Resource;
import javax.xml.ws.WebServiceContext;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.accesscontrol.bean.FunctionConstant;
import com.clustercontrol.accesscontrol.bean.SystemPrivilegeInfo;
import com.clustercontrol.accesscontrol.bean.PrivilegeConstant.SystemPrivilegeMode;
import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.fault.InvalidRole;
import com.clustercontrol.fault.InvalidUserPass;
import com.clustercontrol.ws.util.HttpAuthenticator;

/**
 * アクセス用のWebAPIエンドポイント
 */
@javax.jws.WebService(targetNamespace = "http://managercli.ws.clustercontrol.com")
public class ManagerCliEndpoint {

	@Resource
	WebServiceContext wsctx;

	private final static Log _log = LogFactory.getLog( ManagerCliEndpoint.class );

	/**
	 * echo(WebサービスAPI疎通用)
	 * 
	 * 権限必要なし（ユーザ名チェックのみ実施）
	 * 
	 * @param str
	 * @return
	 * @throws InvalidUserPass
	 * @throws InvalidRole
	 * @throws HinemosUnknown
	 */
	public String echo(String str) throws InvalidUserPass, InvalidRole, HinemosUnknown {
		ArrayList<SystemPrivilegeInfo> systemPrivilegeList = new ArrayList<SystemPrivilegeInfo>();
		HttpAuthenticator.authCheck(wsctx, systemPrivilegeList);

		return str + ", " + str;
	}

	/**
	 * staticクラスに対するinvokeメソッド<br/>
	 * @param className クラス名
	 * @param methodName staticメソッド名
	 * @param args 文字列配列の引数
	 * @return 戻り値となる文字列
	 * @throws HinemosUnknown
	 * @throws InvalidRole
	 * @throws InvalidUserPass
	 */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public String invoke(String className, String methodName, String[] args) throws HinemosUnknown, InvalidUserPass, InvalidRole {
		_log.info(String.format("invoked : class = %s, method = %s, args = %s", className, methodName, args == null ? null : args.toString()));
		ArrayList<SystemPrivilegeInfo> systemPrivilegeList = new ArrayList<SystemPrivilegeInfo>();
		systemPrivilegeList.add(new SystemPrivilegeInfo(FunctionConstant.HINEMOS_CLI, SystemPrivilegeMode.WRITE));
		HttpAuthenticator.authCheck(wsctx, systemPrivilegeList);

		try {
			Class clazz = Class.forName(className);
			Method method = null;
			Object ret = null;
			if (args == null || args.length == 0) {
				Class[] classArgs = null;
				Object[] objArgs = null;
				method = clazz.getMethod(methodName, classArgs);
				ret = method.invoke(null, objArgs);
			} else {
				method = clazz.getMethod(methodName, new Class[]{ String[].class });
				Object[] objArgs = new Object[]{ args };
				ret = method.invoke(null, objArgs);
			}

			if (ret == null) {
				return null;
			} else {
				return ret.toString();
			}
		} catch (Exception e) {
			_log.warn("invocation failure. (class = " + className + ", method = " + methodName + ", args = " + args + ")");
			throw new HinemosUnknown("invocation failure. (class = " + className + ", method = " + methodName + ", args = " + args + ")", e);
		}
	}

}
