package com.clustercontrol.snmptrap.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.commons.util.JpaTransactionManager;
import com.clustercontrol.snmptrap.bean.SnmpTrapMasterInfo;
import com.clustercontrol.snmptrap.model.SnmpTrapMstEntity;
import com.clustercontrol.snmptrap.model.SnmpTrapMstEntityPK;

/**
 * SNMPTRAP監視のキャッシュ
 *
 * 
 * @version 4.0.0
 * @since 4.0.0
 */
public class SnmpTrapMasterCache {
	private static Log m_log = LogFactory.getLog( SnmpTrapMasterCache.class );

	private static Object lock = new Object();
	private static ConcurrentHashMap<SnmpTrapMstEntityPK, SnmpTrapMasterInfo> trapMstCache = new ConcurrentHashMap<SnmpTrapMstEntityPK, SnmpTrapMasterInfo>();

	static {
		refresh();
	}

	/**
	 * キャッシュのリフレッシュ
	 * このメソッドはsynchronizedの内部で呼ぶこと。
	 */
	private static void refresh() {
		JpaTransactionManager jtm = new JpaTransactionManager();
		if (!jtm.isNestedEm()) {
			m_log.warn("refresh() : transactioin has not been begined.");
			jtm.close();
			return;
		}

		if (trapMstCache.isEmpty()) {
			long start = System.currentTimeMillis();
			try{
				List<SnmpTrapMstEntity> c = QueryUtil.getAllSnmpTrapMst();

				for(SnmpTrapMstEntity entity : c){
					SnmpTrapMasterInfo info = new SnmpTrapMasterInfo();
					info.setMib(entity.getId().getMib());
					info.setTrapOid(entity.getId().getTrapOid());
					info.setGenericId(entity.getId().getGenericId());
					info.setSpecificId(entity.getId().getSpecificId());
					info.setUei(entity.getUei());
					info.setPriority(entity.getPriority());
					info.setLogmsg(entity.getLogmsg());
					info.setDescr(entity.getDescr());
					trapMstCache.put(entity.getId(), info);
				}
			} catch (Exception e){
				m_log.warn("refresh() : "
						+ e.getClass().getSimpleName() + ", " + e.getMessage(), e);
			}
			m_log.info("refresh SnmpTrapMasterCache. " + (System.currentTimeMillis() - start) +
					"ms. size=" + trapMstCache.size());
		}
	}

	public static void clear() {
		synchronized (lock) {
			trapMstCache.clear();
		}
	}

	public static ArrayList<SnmpTrapMasterInfo> getMasterList(String mib){
		synchronized(lock) {
			refresh();
			ArrayList<SnmpTrapMasterInfo> mstList = new ArrayList<SnmpTrapMasterInfo>();
			if(mib == null || mib.equals("")){
				for(SnmpTrapMstEntityPK pk : trapMstCache.keySet()){
					mstList.add(trapMstCache.get(pk));
				}
			}
			else{
				for(SnmpTrapMstEntityPK pk : trapMstCache.keySet()){
					if(mib.equals(trapMstCache.get(pk).getMib())){
						mstList.add(trapMstCache.get(pk));
					}
				}
			}
			return mstList;
		}
	}

	public static SnmpTrapMasterInfo findMasterInfo(String trapOid, int genericId, int specificId){
		synchronized(lock) {
			refresh();
			ArrayList<SnmpTrapMasterInfo> mstList = new ArrayList<SnmpTrapMasterInfo>();
			for(SnmpTrapMstEntityPK pk : trapMstCache.keySet()){
				if(trapOid.equals(trapMstCache.get(pk).getTrapOid()) &&
						genericId == trapMstCache.get(pk).getGenericId() &&
						specificId == trapMstCache.get(pk).getSpecificId()){
					mstList.add(trapMstCache.get(pk));
				}
			}
			if(mstList.size() >= 1){
				if(mstList.size() != 1 ){
					m_log.info("findMasterInfo() : Multiple OID were found in trap master database. (Must be found only one OID)");
				}

				return mstList.get(0);
			}
			else {
				SnmpTrapMasterInfo info = new SnmpTrapMasterInfo();
				info.setTrapOid(trapOid);
				info.setMib(null);
				return info;
			}
		}
	}

	public static SnmpTrapMasterInfo getMasterInfo (SnmpTrapMstEntityPK pk) {
		synchronized(lock) {
			refresh();
			return trapMstCache.get(pk);
		}
	}
}
