/*

Copyright (C) 2008 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.snmptrap.factory;

import java.util.List;

import javax.persistence.EntityManager;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.commons.util.JpaTransactionManager;
import com.clustercontrol.fault.HinemosUnknown;
import com.clustercontrol.fault.InvalidSetting;
import com.clustercontrol.fault.MonitorNotFound;
import com.clustercontrol.monitor.run.model.MonitorTrapValueInfoEntity;
import com.clustercontrol.snmptrap.bean.SnmpTrapMasterInfo;
import com.clustercontrol.snmptrap.entity.SnmpTrapMasterPK;
import com.clustercontrol.snmptrap.model.SnmpTrapMstEntity;
import com.clustercontrol.snmptrap.util.QueryUtil;

/**
 * OIDマスター情報を削除するクラス<BR>
 *
 * @version 2.4.0
 * @since 2.4.0
 * @author Yosuke
 */
public class DeleteOidMaster {

	private static Log m_log = LogFactory.getLog( DeleteOidMaster.class );


	private SnmpTrapMasterPK m_OidPk;

	/**
	 * OID情報を削除します。
	 * 
	 * @param OIDData　削除するOIDマスター
	 * @param user　　　削除実行ユーザ
	 * @return
	 * @throws MonitorNotFound
	 * @throws InvalidSetting
	 */
	public boolean delete(SnmpTrapMasterInfo oidData) throws MonitorNotFound, InvalidSetting {

		this.m_OidPk = new SnmpTrapMasterPK(oidData.getMib(),
				oidData.getTrapOid(),
				oidData.getGenericId(),
				oidData.getSpecificId());

		boolean result = false;

		// SNMPTRAP監視でトラップを個別設定している情報を取得
		List<MonitorTrapValueInfoEntity> trapInfoList;
		try {
			trapInfoList = com.clustercontrol.monitor.run.util.QueryUtil.getAllMonitorTrapValueInfo();
		} catch (HinemosUnknown e) {
			m_log.info("delete() : "
					+ e.getClass().getSimpleName() + ", " + e.getMessage());
			return result;
		}
		
		// 削除対象のトラップが使用されていないかを確認
		if(trapInfoList != null && trapInfoList.size() > 0) {
			SnmpTrapMasterPK oidPk;
			for(MonitorTrapValueInfoEntity info : trapInfoList) {
				
				oidPk = new SnmpTrapMasterPK(
						info.getId().getMib(), 
						info.getId().getTrapOid(), 
						info.getId().getGenericId(),
						info.getId().getSpecificId());
				
				if(this.m_OidPk.equals(oidPk)) {
					String message = "this oid is used. : " + "MIB = " + info.getId().getMib() + ", OID = " + info.getId().getTrapOid();
					m_log.info("delete() : " + message);
					throw new InvalidSetting(message);
				}
			}
		}
		
		// 監視情報を登録
		result = deleteOIDMaster();

		return result;
	}

	/**
	 * OIDマスターの削除を行う。
	 * @param user　削除実行ユーザ
	 * @return
	 * @throws MonitorNotFound
	 */
	public boolean deleteOIDMaster() throws MonitorNotFound {
		boolean result = false;
		EntityManager em = new JpaTransactionManager().getEntityManager();

		// 監視情報を検索
		SnmpTrapMstEntity entity = QueryUtil.getSnmpTrapMstPK(
				m_OidPk.getMib(),
				m_OidPk.getTrapOid(),
				m_OidPk.getGenericId(),
				m_OidPk.getSpecificId());
		entity.unchain();	// 削除前処理
		em.remove(entity);

		result = true;
		return result;
	}
}
