/*

Copyright (C) 2008 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.snmptrap.factory;

import java.sql.Timestamp;
import java.util.Date;

import javax.persistence.EntityExistsException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.commons.util.JpaTransactionManager;
import com.clustercontrol.snmptrap.entity.SnmpTrapMibMasterData;
import com.clustercontrol.snmptrap.model.SnmpTrapMibMstEntity;

/**
 *MIBマスター情報を登録するクラス<BR>
 *
 * @version 3.0.0
 * @since 2.4.0
 * @author Yosuke
 */
public class AddMibMaster {

	private static Log m_log = LogFactory.getLog( AddMibMaster.class );

	/** 監視情報ビーン */
	private SnmpTrapMibMasterData m_MibData;

	/**
	 * MIBマスター情報を登録します。
	 * @param mibData  登録するMIBマスター
	 * @param user     登録実行ユーザ
	 * @return
	 * @throws EntityExistsException
	 */
	public boolean add(SnmpTrapMibMasterData mibData, String user) throws EntityExistsException {

		m_MibData = mibData;

		boolean result = false;

		// 監視情報を登録
		result = addMibMaster(user);

		return result;
	}

	/**
	 * MIBマスターを登録します。<BR>
	 * 
	 * @param user ユーザ
	 * @return 登録に成功した場合、true
	 * @throws EntityExistsException
	 */
	public boolean addMibMaster(String user) throws EntityExistsException {
		boolean result = false;
		JpaTransactionManager jtm = new JpaTransactionManager();

		try
		{
			Timestamp now = new Timestamp(new Date().getTime());

			// 監視情報を挿入
			// インスタンス生成
			SnmpTrapMibMstEntity entity = new SnmpTrapMibMstEntity(m_MibData.getMib());
			// 重複チェック
			jtm.checkEntityExists(SnmpTrapMibMstEntity.class, entity.getMib());
			entity.setDescription(m_MibData.getDescription());
			entity.setOrderNo(m_MibData.getOrderNo());
			entity.setRegDate(now);
			entity.setRegUser(user);
			entity.setUpdateDate(now);
			entity.setUpdateUser(user);

			result = true;
		} catch (EntityExistsException e) {
			m_log.info("addMibMaster() : "
					+ e.getClass().getSimpleName() + ", " + e.getMessage());
			throw e;
		}
		return result;
	}
}
