/*

Copyright (C) since 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.collectiverun.bean;

import java.io.Serializable;
import java.util.HashMap;

import javax.xml.bind.annotation.XmlType;


/**
 * Hinemosの一括制御実行情報を格納するクラス。<BR>
 * DTOクラスとしてマネージャ、クライアント間の通信で利用する。
 *
 */
@XmlType(namespace = "http://collectiverun.ws.clustercontrol.com")
public class CollectiveRunInfo implements Serializable {

	private static final long serialVersionUID = -25377385691385629L;
	private String facilityId = null;
	private String name = null;
	private HashMap<String,String> param = new HashMap<String,String>();

	public CollectiveRunInfo(){
		super();
	}

	public void setFacilityId(String facilityId) {
		this.facilityId = facilityId;
	}
	public String getFacilityId() {
		return facilityId;
	}
	public void setName(String name) {
		this.name = name;
	}
	public String getName() {
		return name;
	}
	public void setParam(String paramId, String paramValue) {
		this.param.put(paramId, paramValue);
	}
	public String getParamValue(String paramId) {
		return this.param.get(paramId);
	}

	// webサービス(jaxb)のためgetterとsetterを用意しておく
	@Deprecated
	public HashMap<String, String> getParam() {
		return param;
	}

	@Deprecated
	public void setParam(HashMap<String, String> param) {
		this.param = param;
	}


}
