--
-- PostgreSQL database dump
--

SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

SET search_path = public, pg_catalog;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: cc_vm_protocol_mst_pkey; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_vm_protocol_mst
    ADD CONSTRAINT cc_vm_protocol_mst_pkey PRIMARY KEY (sub_platform_id, protocol);

ALTER TABLE cc_vm_protocol_mst CLUSTER ON cc_vm_protocol_mst_pkey;


--
-- Name: p_key_cc_cal_pattern_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_cal_pattern_info
    ADD CONSTRAINT p_key_cc_cal_pattern_info PRIMARY KEY (calendar_pattern_id);

ALTER TABLE cc_cal_pattern_info CLUSTER ON p_key_cc_cal_pattern_info;


--
-- Name: p_key_cc_cal_pattern_detail_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_cal_pattern_detail_info
    ADD CONSTRAINT p_key_cc_cal_pattern_detail_info PRIMARY KEY (calendar_pattern_id, year_no, month_no, day_no);

ALTER TABLE cc_cal_pattern_detail_info CLUSTER ON p_key_cc_cal_pattern_detail_info;

ALTER TABLE ONLY cc_cal_pattern_detail_info
    ADD CONSTRAINT ref_cc_cal_pattern_detail_info1 FOREIGN KEY (calendar_pattern_id) REFERENCES cc_cal_pattern_info(calendar_pattern_id);

--
-- Name: p_key_cc_cal_pattern_detail_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--


--
-- Name: p_key_cc_cal_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_cal_info
    ADD CONSTRAINT p_key_cc_cal_info PRIMARY KEY (calendar_id);

ALTER TABLE cc_cal_info CLUSTER ON p_key_cc_cal_info;


--
-- Name: p_key_cc_cal_detail_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_cal_detail_info
    ADD CONSTRAINT p_key_cc_cal_detail_info PRIMARY KEY (calendar_id, order_no);

ALTER TABLE cc_cal_detail_info CLUSTER ON p_key_cc_cal_detail_info;

ALTER TABLE ONLY cc_cal_detail_info
    ADD CONSTRAINT ref_cc_cal_detail_info1 FOREIGN KEY (calendar_id) REFERENCES cc_cal_info(calendar_id);
    
ALTER TABLE ONLY cc_cal_detail_info
    ADD CONSTRAINT ref_cc_cal_detail_info2 FOREIGN KEY (calendar_pattern_id) REFERENCES cc_cal_pattern_info(calendar_pattern_id);


--
-- Name: p_key_cc_cal_detail_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--


ALTER TABLE ONLY cc_calculated_data
    ADD CONSTRAINT p_key_cc_calculated_data PRIMARY KEY (collectorid, facilityid, item_code, display_name, date_time);

ALTER TABLE cc_calculated_data CLUSTER ON p_key_cc_calculated_data;

--
-- Name: p_key_cc_cfg_facility; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_cfg_facility
    ADD CONSTRAINT p_key_cc_cfg_facility PRIMARY KEY (facility_id);

ALTER TABLE cc_cfg_facility CLUSTER ON p_key_cc_cfg_facility;


--
-- Name: p_key_cc_cfg_facility_relation; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_cfg_facility_relation
    ADD CONSTRAINT p_key_cc_cfg_facility_relation PRIMARY KEY (parent_facility_id, child_facility_id);

ALTER TABLE cc_cfg_facility_relation CLUSTER ON p_key_cc_cfg_facility_relation;


--
-- Name: p_key_cc_cfg_node; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_cfg_node
    ADD CONSTRAINT p_key_cc_cfg_node PRIMARY KEY (facility_id);

ALTER TABLE cc_cfg_node CLUSTER ON p_key_cc_cfg_node;


--
-- Name: p_key_cc_cfg_node_device; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace:
--

ALTER TABLE ONLY cc_cfg_node_device
    ADD CONSTRAINT p_key_cc_cfg_node_device PRIMARY KEY (facility_id, device_index, device_type, device_name);

ALTER TABLE cc_cfg_node_device CLUSTER ON p_key_cc_cfg_node_device;


--
-- Name: p_key_cc_cfg_node_cpu; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace:
--

ALTER TABLE ONLY cc_cfg_node_cpu
    ADD CONSTRAINT p_key_cc_cfg_node_cpu PRIMARY KEY (facility_id, device_index, device_type, device_name);

ALTER TABLE cc_cfg_node_cpu CLUSTER ON p_key_cc_cfg_node_cpu;


--
-- Name: p_key_cc_cfg_node_memory; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace:
--

ALTER TABLE ONLY cc_cfg_node_memory
    ADD CONSTRAINT p_key_cc_cfg_node_memory PRIMARY KEY (facility_id, device_index, device_type, device_name);

ALTER TABLE cc_cfg_node_memory CLUSTER ON p_key_cc_cfg_node_memory;


--
-- Name: p_key_cc_cfg_node_network_interface; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace:
--

ALTER TABLE ONLY cc_cfg_node_network_interface
    ADD CONSTRAINT p_key_cc_cfg_node_network_interface PRIMARY KEY (facility_id, device_index, device_type, device_name);

ALTER TABLE cc_cfg_node_network_interface CLUSTER ON p_key_cc_cfg_node_network_interface;


--
-- Name: p_key_cc_cfg_node_disk; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace:
--

ALTER TABLE ONLY cc_cfg_node_disk
    ADD CONSTRAINT p_key_cc_cfg_node_disk PRIMARY KEY (facility_id, device_index, device_type, device_name);

ALTER TABLE cc_cfg_node_disk CLUSTER ON p_key_cc_cfg_node_disk;


--
-- Name: p_key_cc_cfg_node_filesystem; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace:
--

ALTER TABLE ONLY cc_cfg_node_filesystem
    ADD CONSTRAINT p_key_cc_cfg_node_filesystem PRIMARY KEY (facility_id, device_index, device_type, device_name);

ALTER TABLE cc_cfg_node_filesystem CLUSTER ON p_key_cc_cfg_node_filesystem;


--
-- Name: p_key_cc_cfg_node_variable; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace:
--

ALTER TABLE ONLY cc_cfg_node_variable
    ADD CONSTRAINT p_key_cc_cfg_node_variable PRIMARY KEY (facility_id, node_variable_name);

ALTER TABLE cc_cfg_node_variable CLUSTER ON p_key_cc_cfg_node_variable;


--
-- Name: p_key_cc_cfg_node_hostname; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_cfg_node_hostname
    ADD CONSTRAINT p_key_cc_cfg_node_hostname PRIMARY KEY (facility_id, hostname);

ALTER TABLE cc_cfg_node_hostname CLUSTER ON p_key_cc_cfg_node_hostname;


--
-- Name: p_key_cc_cfg_node_note; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_cfg_node_note
    ADD CONSTRAINT p_key_cc_cfg_node_note PRIMARY KEY (facility_id, note_id);

ALTER TABLE cc_cfg_node_note CLUSTER ON p_key_cc_cfg_node_note;


--
-- Name: p_key_cc_cfg_user; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_cfg_user
    ADD CONSTRAINT p_key_cc_cfg_user PRIMARY KEY (user_id);

ALTER TABLE cc_cfg_user CLUSTER ON p_key_cc_cfg_user;


--
-- Name: p_key_cc_cfg_role; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_cfg_role
    ADD CONSTRAINT p_key_cc_cfg_role PRIMARY KEY (role_id);

ALTER TABLE cc_cfg_role CLUSTER ON p_key_cc_cfg_role;


--
-- Name: p_key_cc_cfg_user_role_relation; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_cfg_user_role_relation
    ADD CONSTRAINT p_key_cc_cfg_user_role_relation PRIMARY KEY (role_id, user_id);

ALTER TABLE cc_cfg_user_role_relation CLUSTER ON p_key_cc_cfg_user_role_relation;


--
-- Name: p_key_cc_system_privilege; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_system_privilege
    ADD CONSTRAINT p_key_cc_system_privilege PRIMARY KEY (role_id, system_function, system_privilege);

ALTER TABLE cc_system_privilege CLUSTER ON p_key_cc_system_privilege;


--
-- Name: p_key_cc_object_privilege; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_object_privilege
    ADD CONSTRAINT p_key_cc_object_privilege PRIMARY KEY (object_type, object_id, role_id, object_privilege);

ALTER TABLE cc_object_privilege CLUSTER ON p_key_cc_object_privilege;


--
-- Name: p_key_cc_collector_calc_method_mst; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_collector_calc_method_mst
    ADD CONSTRAINT p_key_cc_collector_calc_method_mst PRIMARY KEY (calc_method);

ALTER TABLE cc_collector_calc_method_mst CLUSTER ON p_key_cc_collector_calc_method_mst;


--
-- Name: p_key_cc_collector_category_collect_mst; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_collector_category_collect_mst
    ADD CONSTRAINT p_key_cc_collector_category_collect_mst PRIMARY KEY (platform_id, sub_platform_id, category_code);

ALTER TABLE cc_collector_category_collect_mst CLUSTER ON p_key_cc_collector_category_collect_mst;


--
-- Name: p_key_cc_collector_category_mst; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_collector_category_mst
    ADD CONSTRAINT p_key_cc_collector_category_mst PRIMARY KEY (category_code);

ALTER TABLE cc_collector_category_mst CLUSTER ON p_key_cc_collector_category_mst;


--
-- Name: p_key_cc_collector_item_calc_method_mst; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_collector_item_calc_method_mst
    ADD CONSTRAINT p_key_cc_collector_item_calc_method_mst PRIMARY KEY (collect_method, platform_id, sub_platform_id, item_code);

ALTER TABLE cc_collector_item_calc_method_mst CLUSTER ON p_key_cc_collector_item_calc_method_mst;


--
-- Name: p_key_cc_collector_item_code_mst; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_collector_item_code_mst
    ADD CONSTRAINT p_key_cc_collector_item_code_mst PRIMARY KEY (item_code);

ALTER TABLE cc_collector_item_code_mst CLUSTER ON p_key_cc_collector_item_code_mst;


--
-- Name: p_key_cc_collector_platform_mst; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_collector_platform_mst
    ADD CONSTRAINT p_key_cc_collector_platform_mst PRIMARY KEY (platform_id);

ALTER TABLE cc_collector_platform_mst CLUSTER ON p_key_cc_collector_platform_mst;

--
-- Name: p_key_cc_collector_sub_platform_mst; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_collector_sub_platform_mst
    ADD CONSTRAINT p_key_cc_collector_sub_platform_mst PRIMARY KEY (sub_platform_id);

ALTER TABLE cc_collector_sub_platform_mst CLUSTER ON p_key_cc_collector_sub_platform_mst;

--
-- Name: p_key_cc_collector_polling_mst; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_collector_polling_mst
    ADD CONSTRAINT p_key_cc_collector_polling_mst PRIMARY KEY (collect_method, platform_id, sub_platform_id, item_code, variable_id);

ALTER TABLE cc_collector_polling_mst CLUSTER ON p_key_cc_collector_polling_mst;


--
-- Name: p_key_cc_crun_cmd_mst; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_crun_cmd_mst
    ADD CONSTRAINT p_key_cc_crun_cmd_mst PRIMARY KEY (command_id);

ALTER TABLE cc_crun_cmd_mst CLUSTER ON p_key_cc_crun_cmd_mst;


--
-- Name: p_key_cc_crun_cmd_param_mst; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_crun_cmd_param_mst
    ADD CONSTRAINT p_key_cc_crun_cmd_param_mst PRIMARY KEY (command_id, param_id);

ALTER TABLE cc_crun_cmd_param_mst CLUSTER ON p_key_cc_crun_cmd_param_mst;


--
-- Name: p_key_cc_crun_end_mst; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_crun_end_mst
    ADD CONSTRAINT p_key_cc_crun_end_mst PRIMARY KEY (command_id, end_status);

ALTER TABLE cc_crun_end_mst CLUSTER ON p_key_cc_crun_end_mst;


--
-- Name: p_key_cc_crun_param_mst; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_crun_param_mst
    ADD CONSTRAINT p_key_cc_crun_param_mst PRIMARY KEY (param_id);

ALTER TABLE cc_crun_param_mst CLUSTER ON p_key_cc_crun_param_mst;


--
-- Name: p_key_cc_crun_param_select_mst; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_crun_param_select_mst
    ADD CONSTRAINT p_key_cc_crun_param_select_mst PRIMARY KEY (param_id, order_no);

ALTER TABLE cc_crun_param_select_mst CLUSTER ON p_key_cc_crun_param_select_mst;


--
-- Name: p_key_cc_crun_session; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_crun_session
    ADD CONSTRAINT p_key_cc_crun_session PRIMARY KEY (session_id);

ALTER TABLE cc_crun_session CLUSTER ON p_key_cc_crun_session;


--
-- Name: p_key_cc_crun_session_detail; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_crun_session_detail
    ADD CONSTRAINT p_key_cc_crun_session_detail PRIMARY KEY (session_id, facility_id);

ALTER TABLE cc_crun_session_detail CLUSTER ON p_key_cc_crun_session_detail;


--
-- Name: p_key_cc_crun_session_param; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_crun_session_param
    ADD CONSTRAINT p_key_cc_crun_session_param PRIMARY KEY (session_id, param_id);

ALTER TABLE cc_crun_session_param CLUSTER ON p_key_cc_crun_session_param;


--
-- Name: p_key_cc_crun_type_mst; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_crun_type_mst
    ADD CONSTRAINT p_key_cc_crun_type_mst PRIMARY KEY (type_id);

ALTER TABLE cc_crun_type_mst CLUSTER ON p_key_cc_crun_type_mst;


--
-- Name: p_key_cc_event_log; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_event_log
    ADD CONSTRAINT p_key_cc_event_log PRIMARY KEY (monitor_id, monitor_detail_id, plugin_id, output_date, facility_id);

ALTER TABLE cc_event_log CLUSTER ON p_key_cc_event_log;


--
-- Name: p_key_cc_job_end_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_job_end_info
    ADD CONSTRAINT p_key_cc_job_end_info PRIMARY KEY (session_id, jobunit_id, job_id, end_status);

ALTER TABLE cc_job_end_info CLUSTER ON p_key_cc_job_end_info;


--
-- Name: p_key_cc_job_end_mst; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_job_end_mst
    ADD CONSTRAINT p_key_cc_job_end_mst PRIMARY KEY (jobunit_id, job_id, end_status);

ALTER TABLE cc_job_end_mst CLUSTER ON p_key_cc_job_end_mst;


--
-- Name: p_key_cc_job_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_job_info
    ADD CONSTRAINT p_key_cc_job_info PRIMARY KEY (session_id, jobunit_id, job_id);

ALTER TABLE cc_job_info CLUSTER ON p_key_cc_job_info;


--
-- Name: p_key_cc_job_mst; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_job_mst
    ADD CONSTRAINT p_key_cc_job_mst PRIMARY KEY (jobunit_id, job_id);

ALTER TABLE cc_job_mst CLUSTER ON p_key_cc_job_mst;

ALTER TABLE ONLY cc_job_mst
    ADD CONSTRAINT ref_cc_job_mst1 FOREIGN KEY (calendar_id) REFERENCES cc_cal_info(calendar_id);

--
-- Name: p_key_cc_job_notice_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_job_notice_info
    ADD CONSTRAINT p_key_cc_job_notice_info PRIMARY KEY (session_id, jobunit_id, job_id, notice_type);

ALTER TABLE cc_job_notice_info CLUSTER ON p_key_cc_job_notice_info;


--
-- Name: p_key_cc_job_notice_mst; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_job_notice_mst
    ADD CONSTRAINT p_key_cc_job_notice_mst PRIMARY KEY (jobunit_id, job_id, notice_type);

ALTER TABLE cc_job_notice_mst CLUSTER ON p_key_cc_job_notice_mst;


--
-- Name: p_key_cc_job_param_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_job_param_info
    ADD CONSTRAINT p_key_cc_job_param_info PRIMARY KEY (session_id, jobunit_id, job_id, param_id);

ALTER TABLE cc_job_param_info CLUSTER ON p_key_cc_job_param_info;


--
-- Name: p_key_cc_job_param_mst; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_job_param_mst
    ADD CONSTRAINT p_key_cc_job_param_mst PRIMARY KEY (jobunit_id, job_id, param_id);

ALTER TABLE cc_job_param_mst CLUSTER ON p_key_cc_job_param_mst;


--
-- Name: p_key_cc_job_session; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_job_session
    ADD CONSTRAINT p_key_cc_job_session PRIMARY KEY (session_id);

ALTER TABLE cc_job_session CLUSTER ON p_key_cc_job_session;


--
-- Name: p_key_cc_job_session_job; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_job_session_job
    ADD CONSTRAINT p_key_cc_job_session_job PRIMARY KEY (session_id, jobunit_id, job_id);

ALTER TABLE cc_job_session_job CLUSTER ON p_key_cc_job_session_job;


--
-- Name: p_key_cc_job_session_node; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_job_session_node
    ADD CONSTRAINT p_key_cc_job_session_node PRIMARY KEY (session_id, jobunit_id, job_id, facility_id);

ALTER TABLE cc_job_session_node CLUSTER ON p_key_cc_job_session_node;


--
-- Name: p_key_cc_job_start_job_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_job_start_job_info
    ADD CONSTRAINT p_key_cc_job_start_job_info PRIMARY KEY (session_id, jobunit_id, job_id, target_jobunit_id, target_job_id, target_job_type, target_job_end_value);

ALTER TABLE cc_job_start_job_info CLUSTER ON p_key_cc_job_start_job_info;


--
-- Name: p_key_cc_job_start_job_mst; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_job_start_job_mst
    ADD CONSTRAINT p_key_cc_job_start_job_mst PRIMARY KEY (jobunit_id, job_id, target_jobunit_id, target_job_id, target_job_type, target_job_end_value);

ALTER TABLE cc_job_start_job_mst CLUSTER ON p_key_cc_job_start_job_mst;

--
-- Name: p_key_cc_mail_template_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_mail_template_info
    ADD CONSTRAINT p_key_cc_mail_template_info PRIMARY KEY (mail_template_id);

ALTER TABLE cc_mail_template_info CLUSTER ON p_key_cc_mail_template_info;


--
-- Name: p_key_cc_map_association; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_map_association
    ADD CONSTRAINT p_key_cc_map_association PRIMARY KEY (map_id, source, target);

ALTER TABLE cc_map_association CLUSTER ON p_key_cc_map_association;


--
-- Name: p_key_cc_map_bg_image; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_map_bg_image
    ADD CONSTRAINT p_key_cc_map_bg_image PRIMARY KEY (filename);

ALTER TABLE cc_map_bg_image CLUSTER ON p_key_cc_map_bg_image;


--
-- Name: p_key_cc_map_icon_image; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_map_icon_image
    ADD CONSTRAINT p_key_cc_map_icon_image PRIMARY KEY (filename);

ALTER TABLE cc_map_icon_image CLUSTER ON p_key_cc_map_icon_image;


--
-- Name: p_key_cc_map_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_map_info
    ADD CONSTRAINT p_key_cc_map_info PRIMARY KEY (map_id);

ALTER TABLE cc_map_info CLUSTER ON p_key_cc_map_info;


--
-- Name: p_key_cc_map_position; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_map_position
    ADD CONSTRAINT p_key_cc_map_position PRIMARY KEY (map_id, element_id);

ALTER TABLE cc_map_position CLUSTER ON p_key_cc_map_position;


--
-- Name: p_key_cc_monitor_http_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_monitor_http_info
    ADD CONSTRAINT p_key_cc_monitor_http_info PRIMARY KEY (monitor_id);

ALTER TABLE cc_monitor_http_info CLUSTER ON p_key_cc_monitor_http_info;


--
-- Name: p_key_cc_monitor_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_monitor_info
    ADD CONSTRAINT p_key_cc_monitor_info PRIMARY KEY (monitor_id);

ALTER TABLE ONLY cc_monitor_info
    ADD CONSTRAINT ref_cc_monitor_info1 FOREIGN KEY (calendar_id) REFERENCES cc_cal_info(calendar_id);

ALTER TABLE cc_monitor_info CLUSTER ON p_key_cc_monitor_info;


--
-- Name: p_key_cc_monitor_logfile_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_monitor_logfile_info
    ADD CONSTRAINT p_key_cc_monitor_logfile_info PRIMARY KEY (monitor_id);

ALTER TABLE cc_monitor_logfile_info CLUSTER ON p_key_cc_monitor_logfile_info;


--
-- Name: p_key_cc_monitor_numeric_value_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_monitor_numeric_value_info
    ADD CONSTRAINT p_key_cc_monitor_numeric_value_info PRIMARY KEY (monitor_id, priority);

ALTER TABLE cc_monitor_numeric_value_info CLUSTER ON p_key_cc_monitor_numeric_value_info;


--
-- Name: p_key_cc_monitor_perf_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_monitor_perf_info
    ADD CONSTRAINT p_key_cc_monitor_perf_info PRIMARY KEY (monitor_id);

ALTER TABLE cc_monitor_perf_info CLUSTER ON p_key_cc_monitor_perf_info;


--
-- Name: p_key_cc_monitor_ping_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_monitor_ping_info
    ADD CONSTRAINT p_key_cc_monitor_ping_info PRIMARY KEY (monitor_id);

ALTER TABLE cc_monitor_ping_info CLUSTER ON p_key_cc_monitor_ping_info;


--
-- Name: p_key_cc_monitor_plugin_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace:
--

ALTER TABLE ONLY cc_monitor_plugin_info
    ADD CONSTRAINT p_key_cc_monitor_plugin_info PRIMARY KEY (monitor_id);


--
-- Name: p_key_cc_monitor_plugin_numeric_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace:
--

ALTER TABLE ONLY cc_monitor_plugin_numeric_info
    ADD CONSTRAINT p_key_cc_monitor_plugin_numeric_info PRIMARY KEY (monitor_id, key);


--
-- Name: p_key_cc_monitor_plugin_string_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace:
--

ALTER TABLE ONLY cc_monitor_plugin_string_info
    ADD CONSTRAINT p_key_cc_monitor_plugin_string_info PRIMARY KEY (monitor_id, key);


--
-- Name: p_key_cc_monitor_port_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_monitor_port_info
    ADD CONSTRAINT p_key_cc_monitor_port_info PRIMARY KEY (monitor_id);

ALTER TABLE cc_monitor_port_info CLUSTER ON p_key_cc_monitor_port_info;


--
-- Name: p_key_cc_monitor_custom_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_monitor_custom_info
    ADD CONSTRAINT p_key_cc_monitor_custom_info PRIMARY KEY (monitor_id);

ALTER TABLE cc_monitor_custom_info CLUSTER ON p_key_cc_monitor_custom_info;


--
-- Name: p_key_cc_monitor_process_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_monitor_process_info
    ADD CONSTRAINT p_key_cc_monitor_process_info PRIMARY KEY (monitor_id);

ALTER TABLE cc_monitor_process_info CLUSTER ON p_key_cc_monitor_process_info;


--
-- Name: p_key_cc_monitor_process_method_mst; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_monitor_process_method_mst
    ADD CONSTRAINT p_key_cc_monitor_process_method_mst PRIMARY KEY (platform_id, sub_platform_id);

ALTER TABLE cc_monitor_process_method_mst CLUSTER ON p_key_cc_monitor_process_method_mst;


--
-- Name: p_key_cc_monitor_process_polling_mst; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_monitor_process_polling_mst
    ADD CONSTRAINT p_key_cc_monitor_process_polling_mst PRIMARY KEY (collect_method, platform_id, sub_platform_id, variable_id);

ALTER TABLE cc_monitor_process_polling_mst CLUSTER ON p_key_cc_monitor_process_polling_mst;


--
-- Name: p_key_cc_monitor_protocol_mst; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_monitor_protocol_mst
    ADD CONSTRAINT p_key_cc_monitor_protocol_mst PRIMARY KEY (service_id);

ALTER TABLE cc_monitor_protocol_mst CLUSTER ON p_key_cc_monitor_protocol_mst;


--
-- Name: p_key_cc_monitor_snmp_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_monitor_snmp_info
    ADD CONSTRAINT p_key_cc_monitor_snmp_info PRIMARY KEY (monitor_id);

ALTER TABLE cc_monitor_snmp_info CLUSTER ON p_key_cc_monitor_snmp_info;


--
-- Name: p_key_cc_monitor_snmp_value; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_monitor_snmp_value
    ADD CONSTRAINT p_key_cc_monitor_snmp_value PRIMARY KEY (monitor_id, facility_id);

ALTER TABLE cc_monitor_snmp_value CLUSTER ON p_key_cc_monitor_snmp_value;


--
-- Name: p_key_cc_monitor_sql_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_monitor_sql_info
    ADD CONSTRAINT p_key_cc_monitor_sql_info PRIMARY KEY (monitor_id);

ALTER TABLE cc_monitor_sql_info CLUSTER ON p_key_cc_monitor_sql_info;


--
-- Name: p_key_cc_monitor_status; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_monitor_status
    ADD CONSTRAINT p_key_cc_monitor_status PRIMARY KEY (facility_id, plugin_id, monitor_id, sub_key);

ALTER TABLE cc_monitor_status CLUSTER ON p_key_cc_monitor_status;


--
-- Name: p_key_cc_monitor_string_value_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_monitor_string_value_info
    ADD CONSTRAINT p_key_cc_monitor_string_value_info PRIMARY KEY (monitor_id, order_no);

ALTER TABLE cc_monitor_string_value_info CLUSTER ON p_key_cc_monitor_string_value_info;


--
-- Name: p_key_cc_monitor_truth_value_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_monitor_truth_value_info
    ADD CONSTRAINT p_key_cc_monitor_truth_value_info PRIMARY KEY (monitor_id, priority, truth_value);

ALTER TABLE cc_monitor_truth_value_info CLUSTER ON p_key_cc_monitor_truth_value_info;


--
-- Name: p_key_cc_monitor_trap_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_monitor_trap_info
    ADD CONSTRAINT p_key_cc_monitor_trap_info PRIMARY KEY (monitor_id);

ALTER TABLE cc_monitor_trap_info CLUSTER ON p_key_cc_monitor_trap_info;


--
-- Name: p_key_cc_monitor_trap_value_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_monitor_trap_value_info
    ADD CONSTRAINT p_key_cc_monitor_trap_value_info PRIMARY KEY (monitor_id, mib, trap_oid, generic_id, specific_id, uei);

ALTER TABLE cc_monitor_trap_value_info CLUSTER ON p_key_cc_monitor_trap_value_info;

--
-- Name: p_key_cc_monitor_winservice_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace:
--

ALTER TABLE ONLY cc_monitor_winservice_info
    ADD CONSTRAINT p_key_cc_monitor_winservice_info PRIMARY KEY (monitor_id);

ALTER TABLE cc_monitor_winservice_info CLUSTER ON p_key_cc_monitor_winservice_info;

--
-- Name: p_key_cc_monitor_winevent_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace:
--

ALTER TABLE ONLY cc_monitor_winevent_info
    ADD CONSTRAINT p_key_cc_monitor_winevent_info PRIMARY KEY (monitor_id);

ALTER TABLE cc_monitor_winevent_info CLUSTER ON p_key_cc_monitor_winevent_info;

--
-- Name: p_key_cc_monitor_winevent_log_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace:
--

ALTER TABLE ONLY cc_monitor_winevent_log_info
    ADD CONSTRAINT p_key_cc_monitor_winevent_log_info PRIMARY KEY (monitor_id, log_name);

ALTER TABLE cc_monitor_winevent_log_info CLUSTER ON p_key_cc_monitor_winevent_log_info;

--
-- Name: p_key_cc_monitor_winevent_source_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace:
--

ALTER TABLE ONLY cc_monitor_winevent_source_info
    ADD CONSTRAINT p_key_cc_monitor_winevent_source_info PRIMARY KEY (monitor_id, source);

ALTER TABLE cc_monitor_winevent_source_info CLUSTER ON p_key_cc_monitor_winevent_source_info;


--
-- Name: p_key_cc_monitor_winevent_id_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace:
--

ALTER TABLE ONLY cc_monitor_winevent_id_info
    ADD CONSTRAINT p_key_cc_monitor_winevent_id_info PRIMARY KEY (monitor_id, event_id);

ALTER TABLE cc_monitor_winevent_id_info CLUSTER ON p_key_cc_monitor_winevent_id_info;


--
-- Name: p_key_cc_monitor_winevent_category_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace:
--

ALTER TABLE ONLY cc_monitor_winevent_category_info
    ADD CONSTRAINT p_key_cc_monitor_winevent_category_info PRIMARY KEY (monitor_id, category);

ALTER TABLE cc_monitor_winevent_category_info CLUSTER ON p_key_cc_monitor_winevent_category_info;


--
-- Name: p_key_cc_monitor_winevent_keyword_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace:
--

ALTER TABLE ONLY cc_monitor_winevent_keyword_info
    ADD CONSTRAINT p_key_cc_monitor_winevent_keyword_info PRIMARY KEY (monitor_id, keyword);

ALTER TABLE cc_monitor_winevent_keyword_info CLUSTER ON p_key_cc_monitor_winevent_keyword_info;


--
-- Name: p_key_cc_notify_command_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_notify_command_info
    ADD CONSTRAINT p_key_cc_notify_command_info PRIMARY KEY (notify_id, priority);

ALTER TABLE cc_notify_command_info CLUSTER ON p_key_cc_notify_command_info;


--
-- Name: p_key_cc_notify_event_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_notify_event_info
    ADD CONSTRAINT p_key_cc_notify_event_info PRIMARY KEY (notify_id, priority);

ALTER TABLE cc_notify_event_info CLUSTER ON p_key_cc_notify_event_info;


--
-- Name: p_key_cc_notify_history; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_notify_history
    ADD CONSTRAINT p_key_cc_notify_history PRIMARY KEY (facility_id, plugin_id, monitor_id, notify_id, sub_key);

ALTER TABLE cc_notify_history CLUSTER ON p_key_cc_notify_history;


--
-- Name: p_key_cc_notify_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_notify_info
    ADD CONSTRAINT p_key_cc_notify_info PRIMARY KEY (notify_id);

ALTER TABLE cc_notify_info CLUSTER ON p_key_cc_notify_info;


--
-- Name: p_key_cc_notify_job_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_notify_job_info
    ADD CONSTRAINT p_key_cc_notify_job_info PRIMARY KEY (notify_id, priority);

ALTER TABLE cc_notify_job_info CLUSTER ON p_key_cc_notify_job_info;


--
-- Name: p_key_cc_notify_log_escalate_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_notify_log_escalate_info
    ADD CONSTRAINT p_key_cc_notify_log_escalate_info PRIMARY KEY (notify_id, priority);

ALTER TABLE cc_notify_log_escalate_info CLUSTER ON p_key_cc_notify_log_escalate_info;


--
-- Name: p_key_cc_notify_mail_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_notify_mail_info
    ADD CONSTRAINT p_key_cc_notify_mail_info PRIMARY KEY (notify_id, priority);

ALTER TABLE cc_notify_mail_info CLUSTER ON p_key_cc_notify_mail_info;


--
-- Name: p_key_cc_notify_relation_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_notify_relation_info
    ADD CONSTRAINT p_key_cc_notify_relation_info PRIMARY KEY (notify_group_id, notify_id);

ALTER TABLE cc_notify_relation_info CLUSTER ON p_key_cc_notify_relation_info;


--
-- Name: p_key_cc_notify_status_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_notify_status_info
    ADD CONSTRAINT p_key_cc_notify_status_info PRIMARY KEY (notify_id, priority);

ALTER TABLE cc_notify_status_info CLUSTER ON p_key_cc_notify_status_info;


--
-- Name: p_key_cc_priority_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_priority_info
    ADD CONSTRAINT p_key_cc_priority_info PRIMARY KEY (judgment_id);

ALTER TABLE cc_priority_info CLUSTER ON p_key_cc_priority_info;


--
-- Name: p_key_cc_snmp_trap_mib_mst; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_snmp_trap_mib_mst
    ADD CONSTRAINT p_key_cc_snmp_trap_mib_mst PRIMARY KEY (mib);

ALTER TABLE cc_snmp_trap_mib_mst CLUSTER ON p_key_cc_snmp_trap_mib_mst;


--
-- Name: p_key_cc_snmp_trap_mst; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_snmp_trap_mst
    ADD CONSTRAINT p_key_cc_snmp_trap_mst PRIMARY KEY (mib, trap_oid, generic_id, specific_id);

ALTER TABLE cc_snmp_trap_mst CLUSTER ON p_key_cc_snmp_trap_mst;


--
-- Name: p_key_cc_snmp_value_type_mst; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_snmp_value_type_mst
    ADD CONSTRAINT p_key_cc_snmp_value_type_mst PRIMARY KEY (value_type);

ALTER TABLE cc_snmp_value_type_mst CLUSTER ON p_key_cc_snmp_value_type_mst;


--
-- Name: p_key_cc_status_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_status_info
    ADD CONSTRAINT p_key_cc_status_info PRIMARY KEY (facility_id, monitor_id, monitor_detail_id, plugin_id);

ALTER TABLE cc_status_info CLUSTER ON p_key_cc_status_info;


--
-- Name: p_key_cc_system_notify_event_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_system_notify_event_info
    ADD CONSTRAINT p_key_cc_system_notify_event_info PRIMARY KEY (notify_id, priority);

ALTER TABLE cc_system_notify_event_info CLUSTER ON p_key_cc_system_notify_event_info;


--
-- Name: p_key_cc_system_notify_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_system_notify_info
    ADD CONSTRAINT p_key_cc_system_notify_info PRIMARY KEY (notify_id);

ALTER TABLE cc_system_notify_info CLUSTER ON p_key_cc_system_notify_info;


--
-- Name: p_key_cc_maintenance_info; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_maintenance_info
    ADD CONSTRAINT p_key_cc_maintenance_info PRIMARY KEY (maintenance_id);

ALTER TABLE ONLY cc_maintenance_info
    ADD CONSTRAINT ref_cc_maintenance_info1 FOREIGN KEY (calendar_id) REFERENCES cc_cal_info(calendar_id);

ALTER TABLE cc_maintenance_info CLUSTER ON p_key_cc_maintenance_info;

--
-- Name: p_key_cc_maintenance_type_mst; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_maintenance_type_mst
    ADD CONSTRAINT p_key_cc_maintenance_type_mst PRIMARY KEY (type_id);

ALTER TABLE cc_maintenance_type_mst CLUSTER ON p_key_cc_maintenance_type_mst;


create index idx_qrtz_j_req_recovery on qrtz_job_details(SCHED_NAME,REQUESTS_RECOVERY);
create index idx_qrtz_j_grp on qrtz_job_details(SCHED_NAME,JOB_GROUP);

create index idx_qrtz_t_j on qrtz_triggers(SCHED_NAME,JOB_NAME,JOB_GROUP);
create index idx_qrtz_t_jg on qrtz_triggers(SCHED_NAME,JOB_GROUP);
create index idx_qrtz_t_c on qrtz_triggers(SCHED_NAME,CALENDAR_NAME);
create index idx_qrtz_t_g on qrtz_triggers(SCHED_NAME,TRIGGER_GROUP);
create index idx_qrtz_t_state on qrtz_triggers(SCHED_NAME,TRIGGER_STATE);
create index idx_qrtz_t_n_state on qrtz_triggers(SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP,TRIGGER_STATE);
create index idx_qrtz_t_n_g_state on qrtz_triggers(SCHED_NAME,TRIGGER_GROUP,TRIGGER_STATE);
create index idx_qrtz_t_next_fire_time on qrtz_triggers(SCHED_NAME,NEXT_FIRE_TIME);
create index idx_qrtz_t_nft_st on qrtz_triggers(SCHED_NAME,TRIGGER_STATE,NEXT_FIRE_TIME);
create index idx_qrtz_t_nft_misfire on qrtz_triggers(SCHED_NAME,MISFIRE_INSTR,NEXT_FIRE_TIME);
create index idx_qrtz_t_nft_st_misfire on qrtz_triggers(SCHED_NAME,MISFIRE_INSTR,NEXT_FIRE_TIME,TRIGGER_STATE);
create index idx_qrtz_t_nft_st_misfire_grp on qrtz_triggers(SCHED_NAME,MISFIRE_INSTR,NEXT_FIRE_TIME,TRIGGER_GROUP,TRIGGER_STATE);

create index idx_qrtz_ft_trig_inst_name on qrtz_fired_triggers(SCHED_NAME,INSTANCE_NAME);
create index idx_qrtz_ft_inst_job_req_rcvry on qrtz_fired_triggers(SCHED_NAME,INSTANCE_NAME,REQUESTS_RECOVERY);
create index idx_qrtz_ft_j_g on qrtz_fired_triggers(SCHED_NAME,JOB_NAME,JOB_GROUP);
create index idx_qrtz_ft_jg on qrtz_fired_triggers(SCHED_NAME,JOB_GROUP);
create index idx_qrtz_ft_t_g on qrtz_fired_triggers(SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP);
create index idx_qrtz_ft_tg on qrtz_fired_triggers(SCHED_NAME,TRIGGER_GROUP);


--
-- Name: idx_cc_cfg_facility_relation_1; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_cc_cfg_facility_relation_1 ON cc_cfg_facility_relation USING btree (child_facility_id);


--
-- Name: idx_cc_cfg_node_1; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_cc_cfg_node_1 ON cc_cfg_node USING btree (ip_address_v4);


--
-- Name: idx_cc_cfg_node_2; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_cc_cfg_node_2 ON cc_cfg_node USING btree (LOWER(ip_address_v6));


--
-- Name: idx_cc_cfg_node_3; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_cc_cfg_node_3 ON cc_cfg_node USING btree (LOWER(node_name));


--
-- Name: idx_cc_collector_item_code_mst_1; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_cc_collector_item_code_mst_1 ON cc_collector_item_code_mst USING btree (parent_item_code);


--
-- Name: idx_cc_collector_platform_mst_1; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_cc_collector_platform_mst_1 ON cc_collector_platform_mst USING btree (order_no);


--
-- Name: idx_cc_crun_cmd_param_mst_1; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_cc_crun_cmd_param_mst_1 ON cc_crun_cmd_param_mst USING btree (order_no);


--
-- Name: idx_cc_crun_session_1; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_cc_crun_session_1 ON cc_crun_session USING btree (start_date);


--
-- Name: idx_cc_crun_session_2; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_cc_crun_session_2 ON cc_crun_session USING btree (status);


--
-- Name: idx_cc_crun_session_3; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_cc_crun_session_3 ON cc_crun_session USING btree (facility_id);


--
-- Name: idx_cc_crun_type_mst_1; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_cc_crun_type_mst_1 ON cc_crun_type_mst USING btree (order_no);


--
-- Name: idx_cc_event_log_1; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_cc_event_log_1 ON cc_event_log USING btree (confirm_flg);


--
-- Name: idx_cc_event_log_2; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_cc_event_log_2 ON cc_event_log USING btree (priority);


--
-- Name: idx_cc_event_log_3; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_cc_event_log_3 ON cc_event_log USING btree (inhibited_flg);


--
-- Name: idx_cc_event_log_4; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_cc_event_log_4 ON cc_event_log USING btree (generation_date);


--
-- Name: idx_cc_event_log_5; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_cc_event_log_5 ON cc_event_log USING btree (facility_id);


--
-- Name: idx_cc_event_log_6; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_cc_event_log_6 ON cc_event_log USING btree (output_date);


--
-- Name: idx_cc_job_info_1; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_cc_job_info_1 ON cc_job_info USING btree (facility_id);


--
-- Name: idx_cc_job_mst_1; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_cc_job_mst_1 ON cc_job_mst USING btree (job_type);


--
-- Name: idx_cc_job_mst_2; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_cc_job_mst_2 ON cc_job_mst USING btree (parent_jobunit_id, parent_job_id);


--
-- Name: idx_cc_job_session_1; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_cc_job_session_1 ON cc_job_session USING btree (jobunit_id);


--
-- Name: idx_cc_job_session_2; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_cc_job_session_2 ON cc_job_session USING btree (job_id);


--
-- Name: idx_cc_job_session_job_1; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_cc_job_session_job_1 ON cc_job_session_job USING btree (status);


--
-- Name: idx_cc_job_session_job_2; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_cc_job_session_job_2 ON cc_job_session_job USING btree (parent_jobunit_id);


--
-- Name: idx_cc_job_session_job_3; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_cc_job_session_job_3 ON cc_job_session_job USING btree (parent_job_id);


--
-- Name: idx_cc_job_session_job_4; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_cc_job_session_job_4 ON cc_job_session_job USING btree (start_date);


--
-- Name: idx_cc_job_session_node_1; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_cc_job_session_node_1 ON cc_job_session_node USING btree (status);


--
-- Name: idx_cc_maintenance_type_mst_1; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_cc_maintenance_type_mst_1 ON cc_maintenance_type_mst USING btree (order_no);


--
-- Name: idx_cc_monitor_info_1; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_cc_monitor_info_1 ON cc_monitor_info USING btree (monitor_type_id);


--
-- Name: idx_cc_monitor_info_2; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_cc_monitor_info_2 ON cc_monitor_info USING btree (collector_flg);


--
-- Name: idx_cc_notify_job_info_1; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_cc_notify_job_info_1 ON cc_notify_job_info USING btree (job_exec_facility);


--
-- Name: idx_cc_notify_log_escalate_info_1; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_cc_notify_log_escalate_info_1 ON cc_notify_log_escalate_info USING btree (escalate_facility);


--
-- Name: idx_cc_snmp_trap_mib_mst_1; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_cc_snmp_trap_mib_mst_1 ON cc_snmp_trap_mib_mst USING btree (order_no);


--
-- Name: idx_cc_status_info_1; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_cc_status_info_1 ON cc_status_info USING btree (expiration_date);


--
-- Name: idx_cc_log_async_task_1; Type: INDEX; Schema: public; Owner: hinemos; Tablespace: 
--

CREATE INDEX idx_cc_log_async_task_1 ON cc_log_async_task USING btree (create_datetime);

--
-- Name: f_key_cc_cfg_facility_relation_child_facility_id; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_cfg_facility_relation
    ADD CONSTRAINT f_key_cc_cfg_facility_relation_child_facility_id FOREIGN KEY (child_facility_id) REFERENCES cc_cfg_facility(facility_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: f_key_cc_cfg_facility_relation_parent_facility_id; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_cfg_facility_relation
    ADD CONSTRAINT f_key_cc_cfg_facility_relation_parent_facility_id FOREIGN KEY (parent_facility_id) REFERENCES cc_cfg_facility(facility_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: f_key_cc_cfg_node_device_facility_id; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_cfg_node_device
    ADD CONSTRAINT f_key_cc_cfg_node_device_facility_id FOREIGN KEY (facility_id) REFERENCES cc_cfg_node(facility_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: f_key_cc_cfg_node_cpu_facility_id; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_cfg_node_cpu
    ADD CONSTRAINT f_key_cc_cfg_node_cpu_facility_id FOREIGN KEY (facility_id) REFERENCES cc_cfg_node(facility_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: f_key_cc_cfg_node_memory_facility_id; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_cfg_node_memory
    ADD CONSTRAINT f_key_cc_cfg_node_memory_facility_id FOREIGN KEY (facility_id) REFERENCES cc_cfg_node(facility_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: f_key_cc_cfg_node_network_interface_facility_id; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_cfg_node_network_interface
    ADD CONSTRAINT f_key_cc_cfg_node_network_interface_facility_id FOREIGN KEY (facility_id) REFERENCES cc_cfg_node(facility_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: f_key_cc_cfg_node_disk_facility_id; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_cfg_node_disk
    ADD CONSTRAINT f_key_cc_cfg_node_disk_facility_id FOREIGN KEY (facility_id) REFERENCES cc_cfg_node(facility_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: f_key_cc_cfg_node_filesystem_facility_id; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_cfg_node_filesystem
    ADD CONSTRAINT f_key_cc_cfg_node_filesystem_facility_id FOREIGN KEY (facility_id) REFERENCES cc_cfg_node(facility_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: f_key_cc_cfg_node_variable_facility_id; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_cfg_node_variable
    ADD CONSTRAINT f_key_cc_cfg_node_variable_facility_id FOREIGN KEY (facility_id) REFERENCES cc_cfg_node(facility_id) ON UPDATE CASCADE ON DELETE CASCADE;

--
-- Name: f_key_cc_cfg_node_facility_id; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_cfg_node
    ADD CONSTRAINT f_key_cc_cfg_node_facility_id FOREIGN KEY (facility_id) REFERENCES cc_cfg_facility(facility_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: f_key_cc_cfg_node_hostname_facility_id; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_cfg_node_hostname
    ADD CONSTRAINT f_key_cc_cfg_node_hostname_facility_id FOREIGN KEY (facility_id) REFERENCES cc_cfg_node(facility_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: f_key_cc_cfg_node_note_facility_id; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_cfg_node_note
    ADD CONSTRAINT f_key_cc_cfg_node_note_facility_id FOREIGN KEY (facility_id) REFERENCES cc_cfg_node(facility_id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- Name: ref_cc_maintenance_type_mst; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_maintenance_info
    ADD CONSTRAINT ref_cc_maintenance_type_mst FOREIGN KEY (type_id) REFERENCES cc_maintenance_type_mst(type_id);


--
-- Name: refcc_collector_category_collect_mst1; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_collector_category_collect_mst
    ADD CONSTRAINT refcc_collector_category_collect_mst1 FOREIGN KEY (platform_id) REFERENCES cc_collector_platform_mst(platform_id);


--
-- Name: refcc_collector_category_collect_mst2; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_collector_category_collect_mst
    ADD CONSTRAINT refcc_collector_category_collect_mst2 FOREIGN KEY (category_code) REFERENCES cc_collector_category_mst(category_code);


--
-- Name: refcc_collector_item_calc_method_mst1; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_collector_item_calc_method_mst
    ADD CONSTRAINT refcc_collector_item_calc_method_mst1 FOREIGN KEY (platform_id) REFERENCES cc_collector_platform_mst(platform_id);


--
-- Name: refcc_collector_item_calc_method_mst2; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_collector_item_calc_method_mst
    ADD CONSTRAINT refcc_collector_item_calc_method_mst2 FOREIGN KEY (item_code) REFERENCES cc_collector_item_code_mst(item_code);


--
-- Name: refcc_collector_item_calc_method_mst3; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_collector_item_calc_method_mst
    ADD CONSTRAINT refcc_collector_item_calc_method_mst3 FOREIGN KEY (calc_method) REFERENCES cc_collector_calc_method_mst(calc_method);


--
-- Name: refcc_collector_item_code_mst1; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_collector_item_code_mst
    ADD CONSTRAINT refcc_collector_item_code_mst1 FOREIGN KEY (category_code) REFERENCES cc_collector_category_mst(category_code);


--
-- Name: refcc_collector_polling_mst1; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_collector_polling_mst
    ADD CONSTRAINT refcc_collector_polling_mst1 FOREIGN KEY (platform_id) REFERENCES cc_collector_platform_mst(platform_id);


--
-- Name: refcc_collector_polling_mst2; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_collector_polling_mst
    ADD CONSTRAINT refcc_collector_polling_mst2 FOREIGN KEY (item_code) REFERENCES cc_collector_item_code_mst(item_code);


--
-- Name: refcc_collector_polling_mst3; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_collector_polling_mst
    ADD CONSTRAINT refcc_collector_polling_mst3 FOREIGN KEY (value_type) REFERENCES cc_snmp_value_type_mst(value_type);


--
-- Name: refcc_crun_cmd_mst41; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_crun_end_mst
    ADD CONSTRAINT refcc_crun_cmd_mst41 FOREIGN KEY (command_id) REFERENCES cc_crun_cmd_mst(command_id);


--
-- Name: refcc_crun_cmd_mst51; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_crun_cmd_param_mst
    ADD CONSTRAINT refcc_crun_cmd_mst51 FOREIGN KEY (command_id) REFERENCES cc_crun_cmd_mst(command_id);


--
-- Name: refcc_crun_param_mst61; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_crun_cmd_param_mst
    ADD CONSTRAINT refcc_crun_param_mst61 FOREIGN KEY (param_id) REFERENCES cc_crun_param_mst(param_id);


--
-- Name: refcc_crun_param_mst71; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_crun_param_select_mst
    ADD CONSTRAINT refcc_crun_param_mst71 FOREIGN KEY (param_id) REFERENCES cc_crun_param_mst(param_id);


--
-- Name: refcc_crun_session131; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_crun_session_param
    ADD CONSTRAINT refcc_crun_session131 FOREIGN KEY (session_id) REFERENCES cc_crun_session(session_id) ON DELETE CASCADE;


--
-- Name: refcc_crun_session81; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_crun_session_detail
    ADD CONSTRAINT refcc_crun_session81 FOREIGN KEY (session_id) REFERENCES cc_crun_session(session_id) ON DELETE CASCADE;


--
-- Name: refcc_crun_type_mst14; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_crun_cmd_mst
    ADD CONSTRAINT refcc_crun_type_mst14 FOREIGN KEY (type_id) REFERENCES cc_crun_type_mst(type_id);


--
-- Name: refcc_job_info10; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_job_notice_info
    ADD CONSTRAINT refcc_job_info10 FOREIGN KEY (session_id, jobunit_id, job_id) REFERENCES cc_job_info(session_id, jobunit_id, job_id) ON DELETE CASCADE;


--
-- Name: refcc_job_info12; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_job_start_job_info
    ADD CONSTRAINT refcc_job_info12 FOREIGN KEY (session_id, jobunit_id, job_id) REFERENCES cc_job_info(session_id, jobunit_id, job_id) ON DELETE CASCADE;


--
-- Name: refcc_job_info17; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_job_param_info
    ADD CONSTRAINT refcc_job_info17 FOREIGN KEY (session_id, jobunit_id, job_id) REFERENCES cc_job_info(session_id, jobunit_id, job_id) ON DELETE CASCADE;


--
-- Name: refcc_job_info9; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_job_end_info
    ADD CONSTRAINT refcc_job_info9 FOREIGN KEY (session_id, jobunit_id, job_id) REFERENCES cc_job_info(session_id, jobunit_id, job_id) ON DELETE CASCADE;


--
-- Name: refcc_job_map_association1; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_map_association
    ADD CONSTRAINT refcc_job_map_association1 FOREIGN KEY (map_id, source) REFERENCES cc_map_position(map_id, element_id) ON DELETE CASCADE;


--
-- Name: refcc_job_map_association2; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_map_association
    ADD CONSTRAINT refcc_job_map_association2 FOREIGN KEY (map_id, target) REFERENCES cc_map_position(map_id, element_id) ON DELETE CASCADE;


--
-- Name: refcc_job_map_position1; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_map_position
    ADD CONSTRAINT refcc_job_map_position1 FOREIGN KEY (map_id) REFERENCES cc_map_info(map_id) ON DELETE CASCADE;


--
-- Name: refcc_job_mst10; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_job_param_mst
    ADD CONSTRAINT refcc_job_mst10 FOREIGN KEY (jobunit_id, job_id) REFERENCES cc_job_mst(jobunit_id, job_id) ON DELETE CASCADE;


--
-- Name: refcc_job_mst14; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

--
-- removed for facilityID="${FACILITY_ID}"
--

-- ALTER TABLE ONLY cc_job_mst DROP CONSTRAINT refcc_job_mst14;
-- ALTER TABLE ONLY cc_job_mst
--     ADD CONSTRAINT refcc_job_mst14 FOREIGN KEY (facility_id) REFERENCES cc_cfg_facility(facility_id);


--
-- Name: refcc_job_mst15; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_job_mst
    ADD CONSTRAINT refcc_job_mst15 FOREIGN KEY (src_facility_id) REFERENCES cc_cfg_facility(facility_id);


--
-- Name: refcc_job_mst16; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_job_mst
    ADD CONSTRAINT refcc_job_mst16 FOREIGN KEY (dest_facility_id) REFERENCES cc_cfg_facility(facility_id);


--
-- Name: refcc_job_mst2; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_job_end_mst
    ADD CONSTRAINT refcc_job_mst2 FOREIGN KEY (jobunit_id, job_id) REFERENCES cc_job_mst(jobunit_id, job_id) ON DELETE CASCADE;


--
-- Name: refcc_job_mst3; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_job_notice_mst
    ADD CONSTRAINT refcc_job_mst3 FOREIGN KEY (jobunit_id, job_id) REFERENCES cc_job_mst(jobunit_id, job_id) ON DELETE CASCADE;


--
-- Name: refcc_job_mst5; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_job_start_job_mst
    ADD CONSTRAINT refcc_job_mst5 FOREIGN KEY (jobunit_id, job_id) REFERENCES cc_job_mst(jobunit_id, job_id) ON DELETE CASCADE;


--
-- Name: refcc_job_session16; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_job_session_job
    ADD CONSTRAINT refcc_job_session16 FOREIGN KEY (session_id) REFERENCES cc_job_session(session_id) ON DELETE CASCADE;


--
-- Name: refcc_job_session_job19; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_job_session_node
    ADD CONSTRAINT refcc_job_session_job19 FOREIGN KEY (session_id, jobunit_id, job_id) REFERENCES cc_job_session_job(session_id, jobunit_id, job_id) ON DELETE CASCADE;


--
-- Name: refcc_job_session_job20; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_job_info
    ADD CONSTRAINT refcc_job_session_job20 FOREIGN KEY (session_id, jobunit_id, job_id) REFERENCES cc_job_session_job(session_id, jobunit_id, job_id) ON DELETE CASCADE;


--
-- Name: refcc_mail_template_info1; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_notify_mail_info
    ADD CONSTRAINT refcc_mail_template_info1 FOREIGN KEY (mail_template_id) REFERENCES cc_mail_template_info(mail_template_id);


--
-- Name: refcc_mail_template_info2; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_system_notify_info
    ADD CONSTRAINT refcc_mail_template_info2 FOREIGN KEY (mail_template_id) REFERENCES cc_mail_template_info(mail_template_id);


--
-- Name: refcc_map_info1; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_map_info
    ADD CONSTRAINT refcc_map_info1 FOREIGN KEY (background_image) REFERENCES cc_map_bg_image(filename) ON DELETE CASCADE;


--
-- Name: refcc_monitor_info1; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_monitor_truth_value_info
    ADD CONSTRAINT refcc_monitor_info1 FOREIGN KEY (monitor_id) REFERENCES cc_monitor_info(monitor_id);


--
-- Name: refcc_monitor_info10; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_monitor_port_info
    ADD CONSTRAINT refcc_monitor_info10 FOREIGN KEY (monitor_id) REFERENCES cc_monitor_info(monitor_id);


--
-- Name: refcc_monitor_info11; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_monitor_trap_value_info
    ADD CONSTRAINT refcc_monitor_info11 FOREIGN KEY (monitor_id) REFERENCES cc_monitor_info(monitor_id);


--
-- Name: refcc_monitor_info12; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_monitor_info
    ADD CONSTRAINT refcc_monitor_info12 FOREIGN KEY (facility_id) REFERENCES cc_cfg_facility(facility_id);


--
-- Name: refcc_monitor_info13; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_monitor_winservice_info
    ADD CONSTRAINT refcc_monitor_info13 FOREIGN KEY (monitor_id) REFERENCES cc_monitor_info(monitor_id);

--
-- Name: refcc_monitor_info14; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_monitor_custom_info
    ADD CONSTRAINT refcc_monitor_info14 FOREIGN KEY (monitor_id) REFERENCES cc_monitor_info(monitor_id);

--
-- Name: refcc_monitor_info15; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_monitor_plugin_info
    ADD CONSTRAINT refcc_monitor_info15 FOREIGN KEY (monitor_id) REFERENCES cc_monitor_info(monitor_id);

--
-- Name: refcc_monitor_info2; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_monitor_numeric_value_info
    ADD CONSTRAINT refcc_monitor_info2 FOREIGN KEY (monitor_id) REFERENCES cc_monitor_info(monitor_id);


--
-- Name: refcc_monitor_info3; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_monitor_process_info
    ADD CONSTRAINT refcc_monitor_info3 FOREIGN KEY (monitor_id) REFERENCES cc_monitor_info(monitor_id);


--
-- Name: refcc_monitor_info4; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_monitor_sql_info
    ADD CONSTRAINT refcc_monitor_info4 FOREIGN KEY (monitor_id) REFERENCES cc_monitor_info(monitor_id);


--
-- Name: refcc_monitor_info5; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_monitor_ping_info
    ADD CONSTRAINT refcc_monitor_info5 FOREIGN KEY (monitor_id) REFERENCES cc_monitor_info(monitor_id);


--
-- Name: refcc_monitor_info6; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_monitor_snmp_info
    ADD CONSTRAINT refcc_monitor_info6 FOREIGN KEY (monitor_id) REFERENCES cc_monitor_info(monitor_id);


--
-- Name: refcc_monitor_info7; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_monitor_string_value_info
    ADD CONSTRAINT refcc_monitor_info7 FOREIGN KEY (monitor_id) REFERENCES cc_monitor_info(monitor_id);


--
-- Name: refcc_monitor_info8; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_monitor_http_info
    ADD CONSTRAINT refcc_monitor_info8 FOREIGN KEY (monitor_id) REFERENCES cc_monitor_info(monitor_id);


--
-- Name: refcc_monitor_info9; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_monitor_perf_info
    ADD CONSTRAINT refcc_monitor_info9 FOREIGN KEY (monitor_id) REFERENCES cc_monitor_info(monitor_id);


--
-- Name: refcc_monitor_process_method_mst1; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_monitor_process_method_mst
    ADD CONSTRAINT refcc_monitor_process_method_mst1 FOREIGN KEY (platform_id) REFERENCES cc_collector_platform_mst(platform_id);


--
-- Name: refcc_monitor_process_polling_mst1; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_monitor_process_polling_mst
    ADD CONSTRAINT refcc_monitor_process_polling_mst1 FOREIGN KEY (platform_id) REFERENCES cc_collector_platform_mst(platform_id);


--
-- Name: refcc_monitor_protocol_mst1; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_monitor_port_info
    ADD CONSTRAINT refcc_monitor_protocol_mst1 FOREIGN KEY (service_id) REFERENCES cc_monitor_protocol_mst(service_id);


--
-- Name: refcc_monitor_status1; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_monitor_status
    ADD CONSTRAINT refcc_monitor_status1 FOREIGN KEY (facility_id) REFERENCES cc_cfg_facility(facility_id) ON DELETE CASCADE;


--
-- Name: refcc_notify_command_info1; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_notify_command_info
    ADD CONSTRAINT refcc_notify_command_info1 FOREIGN KEY (notify_id) REFERENCES cc_notify_info(notify_id) ON DELETE CASCADE;


--
-- Name: refcc_notify_event_info1; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_notify_event_info
    ADD CONSTRAINT refcc_notify_event_info1 FOREIGN KEY (notify_id) REFERENCES cc_notify_info(notify_id) ON DELETE CASCADE;


--
-- Name: refcc_notify_history1; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_notify_history
    ADD CONSTRAINT refcc_notify_history1 FOREIGN KEY (notify_id) REFERENCES cc_notify_info(notify_id) ON DELETE CASCADE;


--
-- Name: refcc_notify_history2; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_notify_history
    ADD CONSTRAINT refcc_notify_history2 FOREIGN KEY (facility_id) REFERENCES cc_cfg_facility(facility_id) ON DELETE CASCADE;


--
-- Name: refcc_notify_job_info1; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_notify_job_info
    ADD CONSTRAINT refcc_notify_job_info1 FOREIGN KEY (notify_id) REFERENCES cc_notify_info(notify_id) ON DELETE CASCADE;


--
-- Name: refcc_notify_job_info2; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_notify_job_info
    ADD CONSTRAINT refcc_notify_job_info2 FOREIGN KEY (job_exec_facility) REFERENCES cc_cfg_facility(facility_id);


--
-- Name: refcc_notify_log_escalate_info1; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_notify_log_escalate_info
    ADD CONSTRAINT refcc_notify_log_escalate_info1 FOREIGN KEY (notify_id) REFERENCES cc_notify_info(notify_id) ON DELETE CASCADE;


--
-- Name: refcc_notify_log_escalate_info2; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_notify_log_escalate_info
    ADD CONSTRAINT refcc_notify_log_escalate_info2 FOREIGN KEY (escalate_facility) REFERENCES cc_cfg_facility(facility_id);


--
-- Name: refcc_notify_mail_info1; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_notify_mail_info
    ADD CONSTRAINT refcc_notify_mail_info1 FOREIGN KEY (notify_id) REFERENCES cc_notify_info(notify_id) ON DELETE CASCADE;


--
-- Name: refcc_notify_relation_info1; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_notify_relation_info
    ADD CONSTRAINT refcc_notify_relation_info1 FOREIGN KEY (notify_id) REFERENCES cc_notify_info(notify_id);


--
-- Name: refcc_notify_status_info1; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_notify_status_info
    ADD CONSTRAINT refcc_notify_status_info1 FOREIGN KEY (notify_id) REFERENCES cc_notify_info(notify_id) ON DELETE CASCADE;


--
-- Name: refcc_snmp_trap_mib_mst1; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_snmp_trap_mst
    ADD CONSTRAINT refcc_snmp_trap_mib_mst1 FOREIGN KEY (mib) REFERENCES cc_snmp_trap_mib_mst(mib);


--
-- Name: refcc_system_notify_info1; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_system_notify_event_info
    ADD CONSTRAINT refcc_system_notify_info1 FOREIGN KEY (notify_id) REFERENCES cc_system_notify_info(notify_id);


--
-- Name: p_key_cc_job_schedule; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace:
--

ALTER TABLE ONLY cc_job_schedule
    ADD CONSTRAINT p_key_cc_job_schedule PRIMARY KEY (schedule_id);

ALTER TABLE cc_job_schedule CLUSTER ON p_key_cc_job_schedule;

--
-- Name: p_key_cc_job_file_check; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace:
--

ALTER TABLE ONLY cc_job_file_check
    ADD CONSTRAINT p_key_cc_job_file_check PRIMARY KEY (schedule_id);

ALTER TABLE cc_job_file_check CLUSTER ON p_key_cc_job_file_check;


--
-- Name: p_key_cc_log_async_task; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace: 
--

ALTER TABLE ONLY cc_log_async_task
    ADD CONSTRAINT p_key_cc_log_async_task PRIMARY KEY (worker, task_id);

ALTER TABLE cc_log_async_task CLUSTER ON p_key_cc_log_async_task;

--
-- Name: ref_cc_job_schedule; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_job_schedule
    ADD CONSTRAINT ref_cc_job_schedule2 FOREIGN KEY (calendar_id) REFERENCES cc_cal_info(calendar_id);
    
--
-- Name: ref_cc_job_file_check; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_job_file_check
    ADD CONSTRAINT ref_cc_job_file_check2 FOREIGN KEY (calendar_id) REFERENCES cc_cal_info(calendar_id);


--
-- Name: p_key_cc_job_edit; Type: CONSTRAINT; Schema: public; Owner: hinemos; Tablespace:
--

ALTER TABLE ONLY cc_job_edit
    ADD CONSTRAINT p_key_cc_job_edit PRIMARY KEY (jobunit_id);


--
-- Name: refcc_monitor_plugin_info2; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_monitor_plugin_string_info
    ADD CONSTRAINT refcc_monitor_plugin_info2 FOREIGN KEY (monitor_id) REFERENCES cc_monitor_plugin_info(monitor_id);


--
-- Name: refcc_monitor_plugin_info1; Type: FK CONSTRAINT; Schema: public; Owner: hinemos
--

ALTER TABLE ONLY cc_monitor_plugin_numeric_info
    ADD CONSTRAINT refcc_monitor_plugin_info1 FOREIGN KEY (monitor_id) REFERENCES cc_monitor_plugin_info(monitor_id);


--
-- Name: public; Type: ACL; Schema: -; Owner: hinemos
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM hinemos;
GRANT ALL ON SCHEMA public TO hinemos;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- PostgreSQL database dump complete
--

