/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.sf.jpasecurity.util.CollectionMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCollectionHashMap<K, C extends Collection<V>, V>
extends HashMap<K, C>
implements CollectionMap<K, C, V> {
    public AbstractCollectionHashMap() {
    }

    public AbstractCollectionHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public AbstractCollectionHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public AbstractCollectionHashMap(Map<? extends K, ? extends C> map) {
        super(map);
    }

    @Override
    public void add(K key, V value) {
        this.getNotNull(key).add(value);
    }

    @Override
    public void addAll(K key, Collection<? extends V> values) {
        if (!values.isEmpty()) {
            this.getNotNull(key).addAll(values);
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends C> map) {
        for (Map.Entry<K, C> entry : map.entrySet()) {
            this.addAll(entry.getKey(), (Collection)entry.getValue());
        }
    }

    @Override
    public C getNotNull(K key) {
        Collection<Object> collection = (Collection)this.get(key);
        if (collection == null) {
            collection = this.createCollection();
            this.put(key, collection);
        }
        return (C)collection;
    }

    @Override
    public boolean containsValue(Object value) {
        if (super.containsValue(value)) {
            return true;
        }
        for (Collection collection : this.values()) {
            if (!collection.contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size(K key) {
        Collection collection = (Collection)this.get(key);
        if (collection == null) {
            return 0;
        }
        return collection.size();
    }

    protected abstract C createCollection();
}

