/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAnnotationParser<A extends Annotation, D> {
    private Collection<Class<A>> annotationTypes;

    protected AbstractAnnotationParser() {
        this.annotationTypes = Collections.singleton(this.extractAnnotationType());
    }

    protected AbstractAnnotationParser(Class<A> ... annotationTypes) {
        this.annotationTypes = Arrays.asList(annotationTypes);
    }

    protected void parse(Class<?>[] classes, D data) {
        for (Class<?> annotatedClass : classes) {
            this.parse(annotatedClass, data);
        }
    }

    protected void parse(Collection<Class<?>> classes, D data) {
        for (Class<?> annotatedClass : classes) {
            this.parse(annotatedClass, data);
        }
    }

    protected void parse(Class<?> annotatedClass, D data) {
        if (annotatedClass == null) {
            return;
        }
        this.parse(annotatedClass.getSuperclass(), data);
        for (Class<?> annotatedInterface : annotatedClass.getInterfaces()) {
            this.parse(annotatedInterface, data);
        }
        for (Class<A> annotationType : this.annotationTypes) {
            A annotation = annotatedClass.getAnnotation(annotationType);
            if (annotation == null) continue;
            this.process(annotatedClass, annotation, data);
        }
    }

    protected void process(Class<?> annotatedClass, A annotation, D data) {
        this.process(annotation, data);
    }

    protected void process(A annotation, D data) {
        this.process(annotation);
    }

    protected void process(A annotation) {
    }

    private Class<A> extractAnnotationType() {
        Type type = this.getClass().getGenericSuperclass();
        while (!(type instanceof ParameterizedType) || !AbstractAnnotationParser.class.equals((Object)((ParameterizedType)type).getRawType())) {
            type = this.getSupertype(type);
        }
        Type annotationType = ((ParameterizedType)type).getActualTypeArguments()[0];
        if (annotationType instanceof Class) {
            return (Class)annotationType;
        }
        throw new IllegalStateException("Could not determine annotation type. Please specifiy by constructor.");
    }

    private Type getSupertype(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getGenericSuperclass();
        }
        if (type instanceof ParameterizedType) {
            return this.getSupertype(((ParameterizedType)type).getRawType());
        }
        throw new IllegalStateException("Could not determine annotation type. Please specifiy by constructor.");
    }
}

