/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.sf.jpasecurity.AccessType;
import net.sf.jpasecurity.ExceptionFactory;
import net.sf.jpasecurity.configuration.AccessRule;
import net.sf.jpasecurity.configuration.SecurityContext;
import net.sf.jpasecurity.entity.SecureObjectCache;
import net.sf.jpasecurity.jpql.JpqlCompiledStatement;
import net.sf.jpasecurity.jpql.compiler.JpqlCompiler;
import net.sf.jpasecurity.jpql.compiler.NotEvaluatableException;
import net.sf.jpasecurity.jpql.compiler.QueryEvaluationParameters;
import net.sf.jpasecurity.jpql.compiler.QueryEvaluator;
import net.sf.jpasecurity.jpql.compiler.QueryPreparator;
import net.sf.jpasecurity.jpql.compiler.SubselectEvaluator;
import net.sf.jpasecurity.jpql.parser.JpqlBooleanLiteral;
import net.sf.jpasecurity.jpql.parser.JpqlBrackets;
import net.sf.jpasecurity.jpql.parser.JpqlIdentifier;
import net.sf.jpasecurity.jpql.parser.JpqlIn;
import net.sf.jpasecurity.jpql.parser.JpqlNamedInputParameter;
import net.sf.jpasecurity.jpql.parser.JpqlParser;
import net.sf.jpasecurity.jpql.parser.JpqlPath;
import net.sf.jpasecurity.jpql.parser.JpqlStatement;
import net.sf.jpasecurity.jpql.parser.JpqlWhere;
import net.sf.jpasecurity.jpql.parser.Node;
import net.sf.jpasecurity.jpql.parser.ParseException;
import net.sf.jpasecurity.mapping.Alias;
import net.sf.jpasecurity.mapping.ClassMappingInformation;
import net.sf.jpasecurity.mapping.MappingInformation;
import net.sf.jpasecurity.security.FilterResult;
import net.sf.jpasecurity.security.QueryOptimizer;
import net.sf.jpasecurity.util.Types;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityFilter {
    private static final Log LOG = LogFactory.getLog(EntityFilter.class);
    private final MappingInformation mappingInformation;
    private final SecurityContext securityContext;
    private final JpqlParser parser;
    private final JpqlCompiler compiler;
    private final SecureObjectCache objectCache;
    private final Map<String, JpqlCompiledStatement> statementCache = new HashMap<String, JpqlCompiledStatement>();
    private final QueryEvaluator queryEvaluator;
    private final QueryPreparator queryPreparator = new QueryPreparator();
    private final Collection<AccessRule> accessRules;
    private final ExceptionFactory exceptionFactory;

    public EntityFilter(SecureObjectCache objectCache, MappingInformation mappingInformation, SecurityContext securityContext, ExceptionFactory exceptionFactory, Collection<AccessRule> accessRules, SubselectEvaluator ... evaluators) {
        this.mappingInformation = mappingInformation;
        this.securityContext = securityContext;
        this.parser = new JpqlParser();
        this.compiler = new JpqlCompiler(mappingInformation, exceptionFactory);
        this.objectCache = objectCache;
        this.queryEvaluator = new QueryEvaluator(this.compiler, exceptionFactory, evaluators);
        this.accessRules = accessRules;
        this.exceptionFactory = exceptionFactory;
    }

    public QueryPreparator getQueryPreparator() {
        return this.queryPreparator;
    }

    public boolean isAccessible(Object entity, AccessType accessType) throws NotEvaluatableException {
        ClassMappingInformation mapping = this.mappingInformation.getClassMapping(entity.getClass());
        LOG.debug((Object)("Evaluating " + (Object)((Object)accessType) + " access for entity of type " + mapping.getEntityName()));
        Alias alias = new Alias(Character.toLowerCase(mapping.getEntityName().charAt(0)) + mapping.getEntityName().substring(1));
        AccessDefinition accessDefinition = this.createAccessDefinition(alias, mapping.getEntityType(), accessType);
        if (accessDefinition == null) {
            LOG.info((Object)("No access rules defined for access type " + (Object)((Object)accessType) + ". Returning true."));
            return true;
        }
        LOG.debug((Object)("Using access definition " + accessDefinition));
        QueryEvaluationParameters evaluationParameters = new QueryEvaluationParameters(this.mappingInformation, Collections.singletonMap(alias, entity), accessDefinition.getQueryParameters(), Collections.<Integer, Object>emptyMap());
        return (Boolean)this.queryEvaluator.evaluate(accessDefinition.getAccessRules(), evaluationParameters);
    }

    public FilterResult<String> filterQuery(String query, AccessType accessType) {
        LOG.debug((Object)("Filtering query " + query));
        JpqlCompiledStatement statement = this.compile(query);
        AccessDefinition accessDefinition = this.createAccessDefinition(statement, accessType);
        FilterResult<String> filterResult = this.getAlwaysEvaluatableResult(query, accessDefinition);
        if (filterResult != null) {
            return filterResult;
        }
        JpqlWhere where = statement.getWhereClause();
        if (where == null) {
            where = this.queryPreparator.createWhere(accessDefinition.getAccessRules());
            Node parent = statement.getFromClause().jjtGetParent();
            for (int i = parent.jjtGetNumChildren(); i > 2; --i) {
                parent.jjtAddChild(parent.jjtGetChild(i - 1), i);
            }
            parent.jjtAddChild(where, 2);
        } else {
            Node condition = where.jjtGetChild(0);
            if (!(condition instanceof JpqlBrackets)) {
                condition = this.queryPreparator.createBrackets(condition);
            }
            Node and = this.queryPreparator.createAnd(condition, accessDefinition.getAccessRules());
            and.jjtSetParent(where);
            where.jjtSetChild(and, 0);
        }
        LOG.debug((Object)("Optimizing filtered query " + statement.getStatement()));
        this.optimize(accessDefinition);
        Set<String> parameterNames = this.compiler.getNamedParameters(accessDefinition.getAccessRules());
        Map<String, Object> parameters = accessDefinition.getQueryParameters();
        parameters.keySet().retainAll(parameterNames);
        LOG.debug((Object)("Returning optimized query " + statement.getStatement()));
        return new FilterResult<String>(statement.getStatement().toString(), parameters.size() > 0 ? parameters : null, statement.getSelectedPaths(), statement.getTypeDefinitions());
    }

    protected AccessDefinition createAccessDefinition(JpqlCompiledStatement statement, AccessType accessType) {
        return this.createAccessDefinition(this.getSelectedEntityTypes(statement), accessType);
    }

    private AccessDefinition createAccessDefinition(Alias alias, Class<?> type, AccessType accessType) {
        return this.createAccessDefinition(Collections.singletonMap(alias.getName(), type), accessType);
    }

    protected AccessDefinition createAccessDefinition(Map<String, Class<?>> selectedTypes, AccessType accessType) {
        AccessDefinition accessDefinition = null;
        boolean restricted = false;
        for (Map.Entry<String, Class<?>> selectedType : selectedTypes.entrySet()) {
            Node instanceOf;
            HashSet restrictedTypes = new HashSet();
            AccessDefinition typedAccessDefinition = null;
            for (AccessRule accessRule : this.accessRules) {
                if (accessRule.isAssignable(selectedType.getValue(), this.mappingInformation)) {
                    restricted = true;
                    restrictedTypes.add(selectedType.getValue());
                    if (!accessRule.grantsAccess(accessType)) continue;
                    typedAccessDefinition = this.appendAccessDefinition(typedAccessDefinition, accessRule, selectedType.getKey(), this.securityContext);
                    continue;
                }
                if (!accessRule.mayBeAssignable(selectedType.getValue(), this.mappingInformation)) continue;
                restricted = true;
                restrictedTypes.add(accessRule.getSelectedType(this.mappingInformation));
                if (!accessRule.grantsAccess(accessType)) continue;
                Class<?> clazz = accessRule.getSelectedType(this.mappingInformation);
                instanceOf = this.queryPreparator.createInstanceOf(selectedType.getKey(), this.mappingInformation.getClassMapping(clazz));
                AccessDefinition preparedAccessRule = this.prepareAccessRule(accessRule, selectedType.getKey(), this.securityContext);
                preparedAccessRule.mergeNode(instanceOf);
                typedAccessDefinition = preparedAccessRule.append(typedAccessDefinition);
            }
            if (restrictedTypes.size() > 0 && !restrictedTypes.contains(selectedType.getValue())) {
                Node superclassNode = null;
                for (Class clazz : restrictedTypes) {
                    instanceOf = this.queryPreparator.createInstanceOf(selectedType.getKey(), this.mappingInformation.getClassMapping(clazz));
                    if (superclassNode == null) {
                        superclassNode = this.queryPreparator.createNot(instanceOf);
                        continue;
                    }
                    superclassNode = this.queryPreparator.createAnd(superclassNode, this.queryPreparator.createNot(instanceOf));
                }
                if (typedAccessDefinition == null) {
                    typedAccessDefinition = new AccessDefinition(superclassNode);
                } else {
                    typedAccessDefinition.appendNode(superclassNode);
                }
            }
            if (accessDefinition == null) {
                accessDefinition = typedAccessDefinition;
                continue;
            }
            accessDefinition.merge(typedAccessDefinition);
        }
        if (accessDefinition == null) {
            return new AccessDefinition(this.queryPreparator.createBoolean(!restricted));
        }
        accessDefinition.setAccessRules(this.queryPreparator.createBrackets(accessDefinition.getAccessRules()));
        return accessDefinition;
    }

    protected <Q> FilterResult<Q> getAlwaysEvaluatableResult(Q query, AccessDefinition accessDefinition) {
        if (accessDefinition.getAccessRules() instanceof JpqlBooleanLiteral) {
            boolean accessRestricted;
            JpqlBooleanLiteral booleanLiteral = (JpqlBooleanLiteral)accessDefinition.getAccessRules();
            boolean bl = accessRestricted = !Boolean.parseBoolean(booleanLiteral.getValue());
            if (accessRestricted) {
                LOG.info((Object)"No access rules defined for access type. Returning <null> query.");
                return new FilterResult();
            }
            LOG.info((Object)"No access rules defined for selected type. Returning unfiltered query");
            return new FilterResult<Q>(query);
        }
        LOG.debug((Object)("Using access definition " + accessDefinition));
        try {
            QueryEvaluationParameters evaluationParameters = new QueryEvaluationParameters(this.mappingInformation, Collections.<Alias, Object>emptyMap(), accessDefinition.getQueryParameters(), Collections.<Integer, Object>emptyMap(), true);
            boolean result = (Boolean)this.queryEvaluator.evaluate(accessDefinition.getAccessRules(), evaluationParameters);
            if (result) {
                LOG.debug((Object)"Access rules are always true for current user and roles. Returning unfiltered query");
                return new FilterResult<Q>(query);
            }
            LOG.debug((Object)"Access rules are always false for current user and roles. Returning empty result");
            return new FilterResult();
        }
        catch (NotEvaluatableException e) {
            return null;
        }
    }

    protected void optimize(AccessDefinition accessDefinition) {
        QueryOptimizer optimizer = new QueryOptimizer(this.mappingInformation, Collections.EMPTY_MAP, accessDefinition.getQueryParameters(), Collections.EMPTY_MAP, this.queryEvaluator, this.objectCache);
        optimizer.optimize(accessDefinition.getAccessRules());
    }

    private AccessDefinition appendAccessDefinition(AccessDefinition accessDefinition, AccessRule accessRule, String selectedAlias, SecurityContext securityContext) {
        return this.prepareAccessRule(accessRule, selectedAlias, securityContext).append(accessDefinition);
    }

    private Node appendNode(Node accessRules, Node accessRule) {
        if (accessRules == null) {
            return accessRule;
        }
        return this.queryPreparator.createOr(accessRules, accessRule);
    }

    private AccessDefinition prepareAccessRule(AccessRule accessRule, String selectedAlias, SecurityContext securityContext) {
        if (accessRule.getWhereClause() == null) {
            return new AccessDefinition(this.queryPreparator.createBoolean(true));
        }
        accessRule = accessRule.clone();
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        this.expand(accessRule, securityContext, queryParameters);
        Node preparedAccessRule = this.queryPreparator.createBrackets(accessRule.getWhereClause().jjtGetChild(0));
        this.queryPreparator.replace(preparedAccessRule, accessRule.getSelectedPath(), selectedAlias);
        return new AccessDefinition(preparedAccessRule, queryParameters);
    }

    private JpqlCompiledStatement compile(String query) {
        JpqlCompiledStatement compiledStatement = this.statementCache.get(query);
        if (compiledStatement == null) {
            try {
                JpqlStatement statement = this.parser.parseQuery(query);
                compiledStatement = this.compiler.compile(statement);
                this.statementCache.put(query, compiledStatement);
            }
            catch (ParseException e) {
                throw this.exceptionFactory.createRuntimeException(e);
            }
        }
        return compiledStatement.clone();
    }

    private void expand(AccessRule accessRule, SecurityContext securityContext, Map<String, Object> queryParameters) {
        for (Alias alias : securityContext.getAliases()) {
            Collection<JpqlIn> inNodes = accessRule.getInNodes(alias);
            if (inNodes.size() > 0) {
                this.expand(alias.getName(), inNodes, securityContext.getAliasValues(alias), queryParameters);
                continue;
            }
            for (JpqlIdentifier identifier : accessRule.getIdentifierNodes(alias)) {
                Node nodeToReplace = identifier;
                if (nodeToReplace.jjtGetParent() instanceof JpqlPath) {
                    nodeToReplace = nodeToReplace.jjtGetParent();
                }
                this.queryPreparator.replace(nodeToReplace, this.queryPreparator.createNamedParameter(alias.getName()));
            }
            queryParameters.put(alias.getName(), securityContext.getAliasValue(alias));
        }
    }

    private void expand(String alias, Collection<JpqlIn> inNodes, Collection<Object> aliasValues, Map<String, Object> queryParameters) {
        for (JpqlIn inNode : inNodes) {
            if (aliasValues.size() == 0) {
                Node notEquals = this.queryPreparator.createNotEquals(this.queryPreparator.createNumber(1), this.queryPreparator.createNumber(1));
                this.queryPreparator.replace(inNode, notEquals);
                continue;
            }
            ArrayList<Object> parameterValues = new ArrayList<Object>(aliasValues);
            String parameterName = alias + "0";
            queryParameters.put(parameterName, parameterValues.get(0));
            JpqlNamedInputParameter parameter = this.queryPreparator.createNamedParameter(parameterName);
            Node parent = this.queryPreparator.createEquals(inNode.jjtGetChild(0), parameter);
            for (int i = 1; i < aliasValues.size(); ++i) {
                parameterName = alias + i;
                queryParameters.put(parameterName, parameterValues.get(i));
                parameter = this.queryPreparator.createNamedParameter(parameterName);
                Node node = this.queryPreparator.createEquals(inNode.jjtGetChild(0), parameter);
                parent = this.queryPreparator.createOr(parent, node);
            }
            this.queryPreparator.replace(inNode, this.queryPreparator.createBrackets(parent));
        }
    }

    private Map<String, Class<?>> getSelectedEntityTypes(JpqlCompiledStatement statement) {
        HashMap selectedTypes = new HashMap();
        for (String selectedPath : statement.getSelectedPaths()) {
            Class selectedType = this.mappingInformation.getType(selectedPath, statement.getTypeDefinitions());
            if (Types.isSimplePropertyType(selectedType)) {
                selectedPath = selectedPath.substring(0, selectedPath.lastIndexOf(46));
                selectedType = this.mappingInformation.getType(selectedPath, statement.getTypeDefinitions());
            }
            selectedTypes.put(selectedPath, selectedType);
        }
        return selectedTypes;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Evaluatable {
        ALWAYS_TRUE,
        ALWAYS_FALSE,
        DEPENDING;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AccessDefinition {
        private Node accessRules;
        private Map<String, Object> queryParameters;

        public AccessDefinition(Node accessRules) {
            this(accessRules, new HashMap<String, Object>());
        }

        public AccessDefinition(Node accessRules, Map<String, Object> queryParameters) {
            if (accessRules == null) {
                throw new IllegalArgumentException("accessRules may not be null");
            }
            if (queryParameters == null) {
                throw new IllegalArgumentException("queryParameters may not be null");
            }
            this.accessRules = accessRules;
            this.queryParameters = queryParameters;
        }

        public Node getAccessRules() {
            return this.accessRules;
        }

        public void setAccessRules(Node accessRules) {
            if (accessRules == null) {
                throw new IllegalArgumentException("accessRules may not be null");
            }
            this.accessRules = accessRules;
        }

        public Map<String, Object> getQueryParameters() {
            return this.queryParameters;
        }

        public AccessDefinition append(AccessDefinition accessDefinition) {
            if (accessDefinition != null) {
                this.queryParameters.putAll(accessDefinition.getQueryParameters());
                this.appendNode(accessDefinition.getAccessRules());
            }
            return this;
        }

        public void appendNode(Node node) {
            this.accessRules = EntityFilter.this.appendNode(this.accessRules, node);
        }

        public AccessDefinition merge(AccessDefinition accessDefinition) {
            if (accessDefinition != null) {
                this.queryParameters.putAll(accessDefinition.getQueryParameters());
                this.mergeNode(accessDefinition.getAccessRules());
            }
            return this;
        }

        public void mergeNode(Node node) {
            this.accessRules = EntityFilter.this.queryPreparator.createAnd(node, this.accessRules);
        }

        public String toString() {
            return "[query=\"" + this.accessRules.toString() + "\",parameters=" + this.queryParameters.toString() + "]";
        }
    }
}

