/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.mapping;

import net.sf.jpasecurity.mapping.Alias;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeDefinition {
    private Alias alias;
    private Class<?> type;
    private String joinPath;
    private boolean innerJoin;
    private boolean fetchJoin;

    public TypeDefinition(Alias alias, Class<?> type) {
        this.alias = alias;
        this.type = type;
    }

    public TypeDefinition(Class<?> type, String joinPath, boolean innerJoin, boolean fetchJoin) {
        this(null, type, joinPath, innerJoin, fetchJoin);
    }

    public TypeDefinition(Alias alias, Class<?> type, String joinPath, boolean innerJoin) {
        this(alias, type, joinPath, innerJoin, false);
    }

    public TypeDefinition(Alias alias, Class<?> type, String joinPath, boolean innerJoin, boolean fetchJoin) {
        this(alias, type);
        if (joinPath == null) {
            throw new IllegalArgumentException("joinPath may not be null");
        }
        this.joinPath = joinPath;
        this.innerJoin = innerJoin;
        this.fetchJoin = fetchJoin;
    }

    public Alias getAlias() {
        return this.alias;
    }

    public String getJoinPath() {
        return this.joinPath;
    }

    public boolean isJoin() {
        return this.getJoinPath() != null;
    }

    public boolean isInnerJoin() {
        return this.isJoin() && this.innerJoin;
    }

    public boolean isOuterJoin() {
        return this.isJoin() && !this.innerJoin;
    }

    public boolean isFetchJoin() {
        return this.fetchJoin;
    }

    public boolean isPreliminary() {
        return this.type == null;
    }

    public Class<?> getType() {
        if (this.isPreliminary()) {
            throw new IllegalStateException("type is not yet determined");
        }
        return this.type;
    }

    public void setType(Class<?> type) {
        if (!this.isPreliminary()) {
            throw new IllegalStateException("type already set");
        }
        this.type = type;
    }

    public String toString() {
        StringBuilder toStringBuilder = new StringBuilder();
        if (this.isInnerJoin()) {
            toStringBuilder.append("inner join ");
        } else if (this.isOuterJoin()) {
            toStringBuilder.append("outer join ");
        }
        if (this.isFetchJoin()) {
            toStringBuilder.append("fetch ");
        }
        if (this.isPreliminary()) {
            toStringBuilder.append("<undetermined type>");
        } else {
            toStringBuilder.append(this.type.getName());
        }
        if (this.alias != null) {
            toStringBuilder.append(' ').append(this.alias);
        }
        return toStringBuilder.toString();
    }
}

