/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.mapping;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.sf.jpasecurity.mapping.BeanInitializer;
import net.sf.jpasecurity.mapping.ClassMappingInformation;
import net.sf.jpasecurity.mapping.PropertyAccessStrategy;
import net.sf.jpasecurity.mapping.PropertyAccessStrategyFactory;
import net.sf.jpasecurity.mapping.ReflectionFieldAccessStrategy;
import net.sf.jpasecurity.mapping.ReflectionMethodAccessStrategy;
import net.sf.jpasecurity.mapping.SecureBeanInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPropertyAccessStrategyFactory
implements PropertyAccessStrategyFactory {
    private static final String GET_METHOD_PREFIX = "get";
    private static final String IS_METHOD_PREFIX = "is";
    private static final String SET_METHOD_PREFIX = "set";
    private BeanInitializer beanInitializer;

    public DefaultPropertyAccessStrategyFactory() {
        this(new SecureBeanInitializer());
    }

    public DefaultPropertyAccessStrategyFactory(BeanInitializer initializer) {
        this.beanInitializer = initializer;
    }

    @Override
    public PropertyAccessStrategy createPropertyAccessStrategy(ClassMappingInformation classMapping, String propertyName) {
        if (classMapping.usesFieldAccess()) {
            Field field = this.getField(classMapping.getEntityType(), propertyName);
            return new ReflectionFieldAccessStrategy(field, this.beanInitializer);
        }
        Method readMethod = this.getReadMethod(classMapping.getEntityType(), propertyName);
        Method writeMethod = this.getWriteMethod(classMapping.getEntityType(), propertyName);
        return new ReflectionMethodAccessStrategy(readMethod, writeMethod);
    }

    protected Field getField(Class<?> type, String fieldname) {
        if (type == null) {
            return null;
        }
        String interFieldname = fieldname.intern();
        for (Field field : type.getDeclaredFields()) {
            if (field.getName() != interFieldname) continue;
            return field;
        }
        return this.getField(type.getSuperclass(), fieldname);
    }

    protected Method getReadMethod(Class<?> type, String propertyName) {
        String capitalizedPropertyName = this.capitalize(propertyName);
        String methodName = GET_METHOD_PREFIX + capitalizedPropertyName;
        Method method = this.getMethod(type, methodName, 0);
        if (method == null) {
            methodName = IS_METHOD_PREFIX + capitalizedPropertyName;
            method = this.getMethod(type, methodName, 0);
        }
        return method;
    }

    protected Method getWriteMethod(Class<?> type, String propertyName) {
        return this.getMethod(type, SET_METHOD_PREFIX + this.capitalize(propertyName), 1);
    }

    protected Method getMethod(Class<?> type, String name, int parameterCount) {
        if (type == null) {
            return null;
        }
        for (Method method : type.getDeclaredMethods()) {
            if (!name.equals(method.getName()) || method.getParameterTypes().length != parameterCount) continue;
            return method;
        }
        return this.getMethod(type.getSuperclass(), name, parameterCount);
    }

    protected String capitalize(String propertyName) {
        return Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
    }
}

