/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.mapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jpasecurity.ExceptionFactory;
import net.sf.jpasecurity.mapping.AbstractPropertyMappingInformation;
import net.sf.jpasecurity.mapping.ClassMappingInformation;
import net.sf.jpasecurity.mapping.EntityLifecycleAdapter;
import net.sf.jpasecurity.mapping.EntityLifecycleMethods;
import net.sf.jpasecurity.mapping.EntityListener;
import net.sf.jpasecurity.mapping.PropertyMappingInformation;
import net.sf.jpasecurity.mapping.RelationshipMappingInformation;
import net.sf.jpasecurity.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultClassMappingInformation
implements ClassMappingInformation {
    private String entityName;
    private Class<?> entityType;
    private DefaultClassMappingInformation superclassMapping;
    private Set<ClassMappingInformation> subclassMappings = new HashSet<ClassMappingInformation>();
    private ClassMappingInformation idClassMapping;
    private boolean embeddable;
    private boolean fieldAccess;
    private boolean metadataComplete;
    private boolean excludeSuperclassEntityListeners;
    private Map<String, AbstractPropertyMappingInformation> propertyMappings = new HashMap<String, AbstractPropertyMappingInformation>();
    private List<EntityListener> defaultEntityListeners = Collections.EMPTY_LIST;
    private Map<Class<?>, EntityListener> entityListeners = new LinkedHashMap();
    private EntityListener entityLifecyleAdapter;
    private ExceptionFactory exceptionFactory;

    public DefaultClassMappingInformation(String entityName, Class<?> entityType, DefaultClassMappingInformation superclassMapping, ClassMappingInformation idClass, boolean embeddable, boolean usesFieldAccess, boolean metadataComplete, ExceptionFactory exceptionFactory) {
        if (entityName == null) {
            throw new IllegalArgumentException("entityName may not be null");
        }
        if (entityType == null) {
            throw new IllegalArgumentException("entityType may not be null");
        }
        this.entityName = entityName;
        this.entityType = entityType;
        this.superclassMapping = superclassMapping;
        if (superclassMapping != null) {
            superclassMapping.subclassMappings.add(this);
        }
        this.idClassMapping = idClass;
        this.embeddable = embeddable;
        this.fieldAccess = usesFieldAccess;
        this.metadataComplete = metadataComplete;
        this.exceptionFactory = exceptionFactory;
    }

    @Override
    public String getEntityName() {
        return this.entityName;
    }

    void setEntityName(String entityName) {
        if (entityName == null) {
            throw new IllegalArgumentException("entityName may not be null");
        }
        this.entityName = entityName;
    }

    public Class<?> getEntityType() {
        return this.entityType;
    }

    @Override
    public Set<ClassMappingInformation> getSubclassMappings() {
        return Collections.unmodifiableSet(this.subclassMappings);
    }

    @Override
    public ClassMappingInformation getIdClassMapping() {
        return this.idClassMapping;
    }

    void setIdClassMapping(ClassMappingInformation idClassMapping) {
        this.idClassMapping = idClassMapping;
    }

    @Override
    public boolean isEmbeddable() {
        return this.embeddable;
    }

    @Override
    public boolean usesFieldAccess() {
        return this.fieldAccess;
    }

    @Override
    public boolean usesPropertyAccess() {
        return !this.fieldAccess;
    }

    void setFieldAccess(boolean fieldAccess) {
        this.fieldAccess = fieldAccess;
    }

    @Override
    public boolean isMetadataComplete() {
        return this.metadataComplete;
    }

    void setMetadataComplete(boolean metadataComplete) {
        this.metadataComplete = metadataComplete;
    }

    @Override
    public boolean areSuperclassEntityListenersExcluded() {
        return this.excludeSuperclassEntityListeners;
    }

    void setSuperclassEntityListenersExcluded(boolean excludeSuperclassEntityListeners) {
        this.excludeSuperclassEntityListeners = excludeSuperclassEntityListeners;
    }

    void clearPropertyMappings() {
        this.propertyMappings.clear();
    }

    @Override
    public boolean containsPropertyMapping(String propertyName) {
        return this.propertyMappings.containsKey(propertyName) || this.superclassMapping != null && this.superclassMapping.containsPropertyMapping(propertyName);
    }

    @Override
    public AbstractPropertyMappingInformation getPropertyMapping(String propertyName) {
        AbstractPropertyMappingInformation propertyMapping = this.propertyMappings.get(propertyName);
        if (propertyMapping == null && this.superclassMapping != null) {
            return this.superclassMapping.getPropertyMapping(propertyName);
        }
        if (propertyMapping == null) {
            throw this.exceptionFactory.createPropertyNotFoundException(this.getEntityType(), propertyName);
        }
        return propertyMapping;
    }

    @Override
    public List<PropertyMappingInformation> getPropertyMappings() {
        ArrayList<PropertyMappingInformation> propertyMappings = new ArrayList<PropertyMappingInformation>();
        propertyMappings.addAll(this.propertyMappings.values());
        if (this.superclassMapping != null) {
            propertyMappings.addAll(this.superclassMapping.getPropertyMappings());
        }
        return Collections.unmodifiableList(propertyMappings);
    }

    void addPropertyMapping(AbstractPropertyMappingInformation propertyMappingInformation) {
        this.propertyMappings.put(propertyMappingInformation.getPropertyName(), propertyMappingInformation);
    }

    @Override
    public List<PropertyMappingInformation> getIdPropertyMappings() {
        ArrayList<AbstractPropertyMappingInformation> idPropertyMappings = new ArrayList<AbstractPropertyMappingInformation>();
        for (AbstractPropertyMappingInformation propertyMapping : this.propertyMappings.values()) {
            if (!propertyMapping.isIdProperty()) continue;
            idPropertyMappings.add(propertyMapping);
        }
        if (idPropertyMappings.size() > 0) {
            return Collections.unmodifiableList(idPropertyMappings);
        }
        if (this.superclassMapping != null) {
            return this.superclassMapping.getIdPropertyMappings();
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<PropertyMappingInformation> getVersionPropertyMappings() {
        ArrayList<AbstractPropertyMappingInformation> versionPropertyMappings = new ArrayList<AbstractPropertyMappingInformation>();
        for (AbstractPropertyMappingInformation propertyMapping : this.propertyMappings.values()) {
            if (!propertyMapping.isVersionProperty()) continue;
            versionPropertyMappings.add(propertyMapping);
        }
        if (versionPropertyMappings.size() > 0) {
            return Collections.unmodifiableList(versionPropertyMappings);
        }
        if (this.superclassMapping != null) {
            return this.superclassMapping.getVersionPropertyMappings();
        }
        return Collections.EMPTY_LIST;
    }

    void setDefaultEntityListeners(List<EntityListener> defaultEntityListeners) {
        this.defaultEntityListeners = defaultEntityListeners;
    }

    void addEntityListener(Class<?> type, EntityListener entityListener) {
        this.entityListeners.put(type, entityListener);
    }

    void setEntityLifecycleMethods(EntityLifecycleMethods entityLifecycleMethods) {
        this.entityLifecyleAdapter = new EntityLifecycleAdapter(entityLifecycleMethods, this.exceptionFactory);
    }

    @Override
    public Object newInstance() {
        return ReflectionUtils.newInstance(this.getEntityType(), new Object[0]);
    }

    @Override
    public Object getId(Object entity) {
        if (this.embeddable) {
            return null;
        }
        List<PropertyMappingInformation> idProperties = this.getIdPropertyMappings();
        if (idProperties.size() == 0) {
            String error = "Id property required for class " + this.getEntityType().getName();
            throw this.exceptionFactory.createMappingException(error);
        }
        if (idProperties.size() == 1) {
            return idProperties.get(0).getPropertyValue(entity);
        }
        try {
            ClassMappingInformation idClassMapping = this.getIdClassMapping();
            Object id = ReflectionUtils.newInstance(idClassMapping.getEntityType(), new Object[0]);
            for (PropertyMappingInformation idProperty : idProperties) {
                Object value = idProperty.getPropertyValue(entity);
                if (idProperty.isRelationshipMapping()) {
                    value = ((RelationshipMappingInformation)idProperty).getRelatedClassMapping().getId(value);
                }
                idClassMapping.getPropertyMapping(idProperty.getPropertyName()).setPropertyValue(id, value);
            }
            return id;
        }
        catch (RuntimeException e) {
            throw this.exceptionFactory.createRuntimeException(e);
        }
    }

    @Override
    public void prePersist(final Object entity) {
        this.fireLifecycleEvent(entity, new EntityListenerClosure(){

            public void call(EntityListener entityListener) {
                entityListener.prePersist(entity);
            }
        });
    }

    @Override
    public void postPersist(final Object entity) {
        this.fireLifecycleEvent(entity, new EntityListenerClosure(){

            public void call(EntityListener entityListener) {
                entityListener.postPersist(entity);
            }
        });
    }

    @Override
    public void preRemove(final Object entity) {
        this.fireLifecycleEvent(entity, new EntityListenerClosure(){

            public void call(EntityListener entityListener) {
                entityListener.preRemove(entity);
            }
        });
    }

    @Override
    public void postRemove(final Object entity) {
        this.fireLifecycleEvent(entity, new EntityListenerClosure(){

            public void call(EntityListener entityListener) {
                entityListener.postRemove(entity);
            }
        });
    }

    @Override
    public void preUpdate(final Object entity) {
        this.fireLifecycleEvent(entity, new EntityListenerClosure(){

            public void call(EntityListener entityListener) {
                entityListener.preUpdate(entity);
            }
        });
    }

    @Override
    public void postUpdate(final Object entity) {
        this.fireLifecycleEvent(entity, new EntityListenerClosure(){

            public void call(EntityListener entityListener) {
                entityListener.postUpdate(entity);
            }
        });
    }

    @Override
    public void postLoad(final Object entity) {
        this.fireLifecycleEvent(entity, new EntityListenerClosure(){

            public void call(EntityListener entityListener) {
                entityListener.postLoad(entity);
            }
        });
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[entityType=" + this.entityType.getSimpleName() + "]";
    }

    private void fireLifecycleEvent(Object entity, EntityListenerClosure closure) {
        DefaultClassMappingInformation superclassMapping;
        for (EntityListener entityListener : this.defaultEntityListeners) {
            closure.call(entityListener);
        }
        if (!this.excludeSuperclassEntityListeners) {
            superclassMapping = this.superclassMapping;
            while (superclassMapping != null && !superclassMapping.excludeSuperclassEntityListeners) {
                for (EntityListener entityListener : superclassMapping.entityListeners.values()) {
                    closure.call(entityListener);
                }
                superclassMapping = superclassMapping.superclassMapping;
            }
        }
        for (EntityListener entityListener : this.entityListeners.values()) {
            closure.call(entityListener);
        }
        closure.call(this.entityLifecyleAdapter);
        superclassMapping = this.superclassMapping;
        while (superclassMapping != null && !superclassMapping.excludeSuperclassEntityListeners) {
            closure.call(superclassMapping.entityLifecyleAdapter);
            superclassMapping = superclassMapping.superclassMapping;
        }
    }

    private static interface EntityListenerClosure {
        public void call(EntityListener var1);
    }
}

