/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.jpql.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.sf.jpasecurity.jpql.compiler.PathEvaluator;
import net.sf.jpasecurity.mapping.Alias;
import net.sf.jpasecurity.mapping.TypeDefinition;
import net.sf.jpasecurity.util.ListHashMap;
import net.sf.jpasecurity.util.ListMap;
import net.sf.jpasecurity.util.SetMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueIterator
implements Iterator<Map<Alias, Object>> {
    private final PathEvaluator pathEvaluator;
    private List<Alias> possibleAliases;
    private ListMap<Alias, Object> possibleValues;
    private ListMap<Alias, TypeDefinition> dependentTypeDefinitions;
    private Map<Alias, Object> currentValues;
    private ListMap<Alias, Object> currentPossibleDependentValues;
    private boolean initialized = false;

    public ValueIterator(SetMap<Alias, Object> possibleValues, Set<TypeDefinition> typeDefinitions, PathEvaluator pathEvaluator) {
        this.pathEvaluator = pathEvaluator;
        this.possibleValues = new ListHashMap<Alias, Object>();
        this.dependentTypeDefinitions = new ListHashMap<Alias, TypeDefinition>();
        this.currentValues = new HashMap<Alias, Object>();
        this.currentPossibleDependentValues = new ListHashMap<Alias, Object>();
        for (TypeDefinition typeDefinition : this.getJoinAliasDefinitions(typeDefinitions)) {
            possibleValues.remove(typeDefinition.getAlias());
            this.dependentTypeDefinitions.add(this.getAlias(typeDefinition.getJoinPath()), typeDefinition);
        }
        for (Map.Entry entry : possibleValues.entrySet()) {
            this.possibleValues.put((Alias)entry.getKey(), new ArrayList((Collection)entry.getValue()));
        }
        this.possibleAliases = new ArrayList(possibleValues.keySet());
    }

    @Override
    public boolean hasNext() {
        if (!this.initialized) {
            return this.hasFirst();
        }
        for (Alias alias : this.possibleAliases) {
            if (this.hasNextDependentValue(alias)) {
                return true;
            }
            if (!this.hasNextValue(alias)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<Alias, Object> next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (!this.initialized) {
            return new HashMap<Alias, Object>(this.first());
        }
        for (Alias alias : this.possibleAliases) {
            if (!this.hasNextDependentValue(alias)) continue;
            return this.nextDependentValue(alias);
        }
        for (Alias alias : this.possibleAliases) {
            if (!this.hasNextValue(alias)) continue;
            return this.nextValue(alias);
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private boolean hasFirst() {
        if (this.possibleAliases.isEmpty()) {
            return false;
        }
        for (Alias alias : this.possibleAliases) {
            if (this.hasFirstValue(alias)) continue;
            return false;
        }
        return true;
    }

    private boolean hasFirstValue(Alias alias) {
        if (this.possibleValues.size(alias) == 0) {
            return false;
        }
        for (Object value : (List)this.possibleValues.get(alias)) {
            if (!this.hasFirstDependentValues(alias, value)) continue;
            return true;
        }
        return false;
    }

    private boolean hasFirstDependentValues(Alias alias, Object value) {
        if (!this.dependentTypeDefinitions.containsKey(alias)) {
            return true;
        }
        for (TypeDefinition dependentTypeDefinition : (List)this.dependentTypeDefinitions.get(alias)) {
            if (this.hasFirstDependentValue(value, dependentTypeDefinition)) continue;
            return false;
        }
        return true;
    }

    private boolean hasFirstDependentValue(Object value, TypeDefinition dependentTypeDefinition) {
        if (dependentTypeDefinition.isOuterJoin()) {
            return true;
        }
        String subpath = this.getSubpath(dependentTypeDefinition.getJoinPath());
        List dependentValues = this.pathEvaluator.evaluateAll(Collections.singleton(value), subpath);
        if (dependentValues.isEmpty()) {
            return false;
        }
        for (Object dependentValue : dependentValues) {
            if (this.hasFirstDependentValues(dependentTypeDefinition.getAlias(), dependentValue)) continue;
            return false;
        }
        return true;
    }

    private Map<Alias, Object> first() {
        for (Alias alias : this.possibleAliases) {
            this.currentValues.put(alias, this.firstValue(alias));
        }
        this.initialized = true;
        return this.currentValues;
    }

    private Object firstValue(Alias alias) {
        for (Object value : (List)this.possibleValues.get(alias)) {
            if (!this.hasFirstDependentValues(alias, value)) continue;
            this.firstDependentValues(alias, value);
            return value;
        }
        throw new NoSuchElementException();
    }

    private Map<Alias, Object> firstDependentValues(Alias alias, Object value) {
        if (!this.hasFirstDependentValues(alias, value)) {
            throw new NoSuchElementException();
        }
        if (!this.dependentTypeDefinitions.containsKey(alias)) {
            return this.currentValues;
        }
        for (TypeDefinition dependentTypeDefinition : (List)this.dependentTypeDefinitions.get(alias)) {
            this.currentValues.put(dependentTypeDefinition.getAlias(), this.firstDependentValue(value, dependentTypeDefinition));
        }
        return this.currentValues;
    }

    private Object firstDependentValue(Object value, TypeDefinition dependentTypeDefinition) {
        String subpath = this.getSubpath(dependentTypeDefinition.getJoinPath());
        List dependentValues = this.pathEvaluator.evaluateAll(Collections.singleton(value), subpath);
        this.currentPossibleDependentValues.put(dependentTypeDefinition.getAlias(), dependentValues);
        if (dependentValues.isEmpty()) {
            if (dependentTypeDefinition.isOuterJoin()) {
                return null;
            }
            throw new NoSuchElementException();
        }
        for (Object dependentValue : dependentValues) {
            if (!this.hasFirstDependentValues(dependentTypeDefinition.getAlias(), dependentValue)) continue;
            this.firstDependentValues(dependentTypeDefinition.getAlias(), dependentValue);
            return dependentValue;
        }
        throw new NoSuchElementException();
    }

    private boolean hasNextValue(Alias alias) {
        for (int i = this.possibleValues.indexOf(alias, this.currentValues.get(alias)) + 1; i < this.possibleValues.size(alias); ++i) {
            if (!this.hasFirstDependentValues(alias, this.possibleValues.get(alias, i))) continue;
            return true;
        }
        return false;
    }

    private boolean hasNextDependentValue(Alias alias) {
        if (!this.dependentTypeDefinitions.containsKey(alias)) {
            return false;
        }
        for (TypeDefinition dependentTypeDefinition : (List)this.dependentTypeDefinitions.get(alias)) {
            Alias dependentAlias = dependentTypeDefinition.getAlias();
            if (this.hasNextDependentValue(dependentAlias)) {
                return true;
            }
            if (!this.hasNextDependentValue(dependentAlias, this.currentValues.get(dependentAlias))) continue;
            return true;
        }
        return false;
    }

    private boolean hasNextDependentValue(Alias dependentAlias, Object currentDependentValue) {
        int currentPossibleSize;
        if (currentDependentValue == null) {
            return false;
        }
        int currentIndex = this.currentPossibleDependentValues.indexOf(dependentAlias, currentDependentValue);
        return currentIndex < (currentPossibleSize = this.currentPossibleDependentValues.size(dependentAlias)) - 1;
    }

    private Map<Alias, Object> nextValue(Alias alias) {
        Alias possibleAlias;
        int i;
        Object currentValue = this.currentValues.get(alias);
        for (int i2 = this.possibleValues.indexOf(alias, currentValue) + 1; i2 < this.possibleValues.size(alias); ++i2) {
            Object nextValue = this.possibleValues.get(alias, i2);
            if (!this.hasFirstDependentValues(alias, nextValue)) continue;
            this.currentValues.put(alias, nextValue);
            this.firstDependentValues(alias, nextValue);
        }
        int currentIndex = this.possibleAliases.indexOf(alias);
        for (i = 0; i < currentIndex; ++i) {
            possibleAlias = this.possibleAliases.get(i);
            this.currentValues.put(possibleAlias, this.firstValue(possibleAlias));
        }
        for (i = currentIndex + 1; i < this.possibleAliases.size(); ++i) {
            possibleAlias = this.possibleAliases.get(i);
            this.firstDependentValues(possibleAlias, this.currentValues.get(possibleAlias));
        }
        return this.currentValues;
    }

    private Map<Alias, Object> nextDependentValue(Alias alias) {
        if (!this.dependentTypeDefinitions.containsKey(alias)) {
            throw new NoSuchElementException();
        }
        for (TypeDefinition dependentTypeDefinition : (List)this.dependentTypeDefinitions.get(alias)) {
            Alias dependentAlias = dependentTypeDefinition.getAlias();
            if (this.hasNextDependentValue(dependentAlias)) {
                return this.nextDependentValue(dependentAlias);
            }
            Object currentValue = this.currentValues.get(dependentAlias);
            if (!this.hasNextDependentValue(dependentAlias, currentValue)) continue;
            return this.nextDependentValue(dependentAlias, currentValue);
        }
        throw new NoSuchElementException();
    }

    private Map<Alias, Object> nextDependentValue(Alias dependentAlias, Object currentDependentValue) {
        int currentIndex = this.currentPossibleDependentValues.indexOf(dependentAlias, currentDependentValue);
        for (int i = currentIndex + 1; i < this.currentPossibleDependentValues.size(dependentAlias); ++i) {
            Object nextDependentValue = this.currentPossibleDependentValues.get(dependentAlias, i);
            if (!this.hasFirstDependentValues(dependentAlias, nextDependentValue)) continue;
            this.currentValues.put(dependentAlias, nextDependentValue);
            return this.firstDependentValues(dependentAlias, nextDependentValue);
        }
        throw new NoSuchElementException();
    }

    private Alias getAlias(String path) {
        int index = path.indexOf(46);
        return index == -1 ? new Alias(path) : new Alias(path.substring(0, index));
    }

    private String getSubpath(String path) {
        int index = path.indexOf(46);
        return path.substring(index + 1);
    }

    private Set<TypeDefinition> getJoinAliasDefinitions(Set<TypeDefinition> typeDefinitions) {
        HashSet<TypeDefinition> joinTypeDefinitions = new HashSet<TypeDefinition>();
        for (TypeDefinition typeDefinition : typeDefinitions) {
            if (!typeDefinition.isJoin()) continue;
            joinTypeDefinitions.add(typeDefinition);
        }
        return joinTypeDefinitions;
    }
}

