/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.jpql.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jpasecurity.ExceptionFactory;
import net.sf.jpasecurity.jpql.JpqlCompiledStatement;
import net.sf.jpasecurity.jpql.compiler.AbstractSubselectEvaluator;
import net.sf.jpasecurity.jpql.compiler.InMemoryEvaluationParameters;
import net.sf.jpasecurity.jpql.compiler.MappedPathEvaluator;
import net.sf.jpasecurity.jpql.compiler.NotEvaluatableException;
import net.sf.jpasecurity.jpql.compiler.QueryEvaluationParameters;
import net.sf.jpasecurity.jpql.compiler.QueryPreparator;
import net.sf.jpasecurity.jpql.compiler.ValueIterator;
import net.sf.jpasecurity.jpql.parser.JpqlEquals;
import net.sf.jpasecurity.jpql.parser.JpqlExists;
import net.sf.jpasecurity.jpql.parser.JpqlGroupBy;
import net.sf.jpasecurity.jpql.parser.JpqlHaving;
import net.sf.jpasecurity.jpql.parser.JpqlInnerJoin;
import net.sf.jpasecurity.jpql.parser.JpqlOuterFetchJoin;
import net.sf.jpasecurity.jpql.parser.JpqlOuterJoin;
import net.sf.jpasecurity.jpql.parser.JpqlSubselect;
import net.sf.jpasecurity.jpql.parser.JpqlVisitorAdapter;
import net.sf.jpasecurity.jpql.parser.JpqlWhere;
import net.sf.jpasecurity.jpql.parser.JpqlWith;
import net.sf.jpasecurity.jpql.parser.Node;
import net.sf.jpasecurity.mapping.Alias;
import net.sf.jpasecurity.mapping.Path;
import net.sf.jpasecurity.mapping.TypeDefinition;
import net.sf.jpasecurity.util.SetHashMap;
import net.sf.jpasecurity.util.SetMap;
import net.sf.jpasecurity.util.ValueHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleSubselectEvaluator
extends AbstractSubselectEvaluator {
    private final ExceptionFactory exceptionFactory;
    private final QueryPreparator queryPreparator = new QueryPreparator();
    private final ReplacementVisitor replacementVisitor = new ReplacementVisitor();
    private final WithClauseVisitor withClauseVisitor = new WithClauseVisitor();
    private final OuterJoinWithClauseVisitor outerJoinWithClauseVisitor = new OuterJoinWithClauseVisitor();
    private final GroupByClauseVisitor groupByClauseVisitor = new GroupByClauseVisitor();
    private final HavingClauseVisitor havingClauseVisitor = new HavingClauseVisitor();

    public SimpleSubselectEvaluator(ExceptionFactory exceptionFactory) {
        this.exceptionFactory = exceptionFactory;
    }

    @Override
    public Collection<?> evaluate(JpqlCompiledStatement subselect, QueryEvaluationParameters parameters) throws NotEvaluatableException {
        if (this.evaluator == null) {
            throw new IllegalStateException("evaluator may not be null");
        }
        this.handleWithClause(this.getSubselect(subselect.getStatement()));
        this.handleGroupByClause(this.getSubselect(subselect.getStatement()));
        if (this.isFalse(subselect.getWhereClause(), new InMemoryEvaluationParameters(parameters))) {
            return Collections.emptySet();
        }
        Set<Replacement> replacements = this.getReplacements(subselect.getTypeDefinitions(), subselect.getStatement());
        SetMap<Alias, Object> variants = this.evaluateAliases(parameters, replacements);
        return this.evaluateSubselect(subselect, parameters, variants);
    }

    protected Collection<?> getResult(Replacement replacement, QueryEvaluationParameters parameters) throws NotEvaluatableException {
        if (replacement.getReplacement() == null) {
            throw new NotEvaluatableException("No replacement found for alias '" + replacement.getTypeDefinition().getAlias() + "'");
        }
        Object result = this.evaluator.evaluate(replacement.getReplacement(), parameters);
        if (result instanceof Collection) {
            Collection resultCollection = (Collection)result;
            this.removeWrongTypes(replacement.getTypeDefinition().getType(), resultCollection);
            return resultCollection;
        }
        if (result == null || !replacement.getTypeDefinition().getType().isInstance(result)) {
            return Collections.EMPTY_SET;
        }
        return Collections.singleton(result);
    }

    private boolean isFalse(JpqlWhere whereClause, QueryEvaluationParameters parameters) {
        if (whereClause == null) {
            return false;
        }
        try {
            return (Boolean)this.evaluator.evaluate(whereClause, parameters) == false;
        }
        catch (NotEvaluatableException e) {
            return false;
        }
    }

    private Set<Replacement> getReplacements(Set<TypeDefinition> types, Node statement) {
        HashSet<Replacement> replacements = new HashSet<Replacement>();
        for (TypeDefinition type : types) {
            if (type.isJoin()) continue;
            replacements.add(new Replacement(type));
        }
        statement.visit(this.replacementVisitor, replacements);
        this.evaluateJoinPathReplacements(replacements);
        return replacements;
    }

    private void evaluateJoinPathReplacements(Set<Replacement> replacements) {
        for (Replacement replacement : replacements) {
            if (!replacement.getTypeDefinition().isJoin()) continue;
            String joinPath = replacement.getTypeDefinition().getJoinPath();
            int index = joinPath.indexOf(46);
            String rootAlias = joinPath.substring(0, index);
            Node replacementNode = replacement.getReplacement();
            Replacement rootReplacement = this.getReplacement(rootAlias, replacements);
            while (rootReplacement != null && rootReplacement.getReplacement() != null) {
                Node rootNode = rootReplacement.getReplacement().clone();
                for (int i = 1; i < replacementNode.jjtGetNumChildren(); ++i) {
                    rootNode.jjtAddChild(replacementNode.jjtGetChild(i), rootNode.jjtGetNumChildren());
                }
                replacement.setReplacement(rootNode);
                String newRootAlias = rootNode.jjtGetChild(0).toString();
                rootReplacement = this.getReplacement(newRootAlias, replacements);
                replacementNode = rootNode;
            }
        }
    }

    private Replacement getReplacement(String alias, Set<Replacement> replacements) {
        for (Replacement replacement : replacements) {
            if (!replacement.getTypeDefinition().getAlias().equals(alias)) continue;
            return replacement;
        }
        return null;
    }

    private SetMap<Alias, Object> evaluateAliases(QueryEvaluationParameters parameters, Set<Replacement> replacements) throws NotEvaluatableException {
        SetHashMap<Alias, Object> aliasValues = new SetHashMap<Alias, Object>();
        for (Map.Entry<Alias, Object> aliasEntry : parameters.getAliasValues().entrySet()) {
            aliasValues.add(aliasEntry.getKey(), aliasEntry.getValue());
        }
        HashSet<Alias> ignoredAliases = new HashSet<Alias>();
        for (Replacement replacement : replacements) {
            Collection<?> result = this.getResult(replacement, parameters);
            for (Object value : result) {
                if (replacement.getTypeDefinition().getType().isAssignableFrom(value.getClass())) {
                    aliasValues.add(replacement.getTypeDefinition().getAlias(), value);
                    continue;
                }
                ignoredAliases.add(replacement.getTypeDefinition().getAlias());
            }
        }
        for (Alias ignoredAlias : ignoredAliases) {
            if (aliasValues.containsKey(ignoredAlias)) continue;
            return new SetHashMap<Alias, Object>();
        }
        return aliasValues;
    }

    private List<Object> evaluateSubselect(JpqlCompiledStatement subselect, QueryEvaluationParameters parameters, SetMap<Alias, Object> variants) {
        MappedPathEvaluator pathEvaluator = new MappedPathEvaluator(parameters.getMappingInformation(), this.exceptionFactory);
        List<Path> selectedPaths = this.getPaths(subselect.getSelectedPaths());
        ArrayList<Object> resultList = new ArrayList<Object>();
        Set<TypeDefinition> types = subselect.getTypeDefinitions();
        ValueIterator v = new ValueIterator(variants, types, pathEvaluator);
        while (v.hasNext()) {
            HashMap<Alias, Object> aliases = new HashMap<Alias, Object>(parameters.getAliasValues());
            aliases.putAll((Map)v.next());
            QueryEvaluationParameters subselectParameters = new QueryEvaluationParameters(parameters.getMappingInformation(), aliases, parameters.getNamedParameters(), parameters.getPositionalParameters());
            try {
                if (!((Boolean)this.evaluator.evaluate(subselect.getWhereClause(), subselectParameters)).booleanValue()) continue;
                Object[] result = new Object[selectedPaths.size()];
                for (int i = 0; i < result.length; ++i) {
                    Path selectedPath = selectedPaths.get(0);
                    Object root = subselectParameters.getAliasValue(selectedPath.getRootAlias());
                    result[i] = selectedPath.hasSubpath() ? pathEvaluator.evaluate(root, selectedPath.getSubpath()) : root;
                }
                if (result.length == 1) {
                    resultList.add(result[0]);
                    continue;
                }
                resultList.add(result);
            }
            catch (NotEvaluatableException e) {}
        }
        return resultList;
    }

    private List<Path> getPaths(Collection<String> paths) {
        ArrayList<Path> result = new ArrayList<Path>();
        for (String path : paths) {
            result.add(new Path(path));
        }
        return result;
    }

    private void removeWrongTypes(Class<?> type, Collection<?> collection) {
        Iterator<?> i = collection.iterator();
        while (i.hasNext()) {
            if (type.isInstance(i.next())) continue;
            i.remove();
        }
    }

    private void handleWithClause(JpqlSubselect node) throws NotEvaluatableException {
        JpqlWith withClause;
        if (this.containsWithClauseWithOuterJoin(node)) {
            throw new NotEvaluatableException("evaluation of subselect with OUTER JOIN ... WITH currenty not supported");
        }
        while ((withClause = this.getWithClause(node)) != null) {
            JpqlSubselect subselect = this.getSubselect(withClause);
            JpqlWhere whereClause = new JpqlCompiledStatement(subselect).getWhereClause();
            if (whereClause == null) {
                this.queryPreparator.appendChildren(subselect, this.queryPreparator.createWhere(withClause.jjtGetChild(0)));
                continue;
            }
            this.queryPreparator.appendToWhereClause(subselect, withClause);
        }
    }

    private boolean containsWithClauseWithOuterJoin(JpqlSubselect node) {
        ValueHolder<Boolean> result = new ValueHolder<Boolean>(false);
        node.visit(this.outerJoinWithClauseVisitor, result);
        return result.getValue();
    }

    private boolean containsWithClause(Node node) {
        ValueHolder result = new ValueHolder();
        node.visit(this.withClauseVisitor, result);
        return result.getValue() != null;
    }

    private JpqlWith getWithClause(Node node) {
        ValueHolder result = new ValueHolder();
        node.visit(this.withClauseVisitor, result);
        return (JpqlWith)result.getValue();
    }

    private JpqlSubselect getSubselect(Node node) {
        while (!(node instanceof JpqlSubselect) && node != null) {
            if ((node = node.jjtGetParent()) != null) continue;
            throw new IllegalStateException("no parent found for node " + node);
        }
        return (JpqlSubselect)node;
    }

    private void handleGroupByClause(JpqlSubselect node) throws NotEvaluatableException {
        if (this.containsGroupByClause(node)) {
            throw new NotEvaluatableException("evaluation of subselect with GROUP BY currenty not supported");
        }
        if (this.containsHavingClause(node)) {
            throw new NotEvaluatableException("evaluation of subselect with GROUP BY currenty not supported");
        }
    }

    private boolean containsGroupByClause(Node node) {
        ValueHolder result = new ValueHolder();
        node.visit(this.groupByClauseVisitor, result);
        return result.getValue() != null;
    }

    private boolean containsHavingClause(Node node) {
        ValueHolder result = new ValueHolder();
        node.visit(this.havingClauseVisitor, result);
        return result.getValue() != null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class HavingClauseVisitor
    extends JpqlVisitorAdapter<ValueHolder<JpqlHaving>> {
        private HavingClauseVisitor() {
        }

        @Override
        public boolean visit(JpqlHaving node, ValueHolder<JpqlHaving> data) {
            data.setValue(node);
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class GroupByClauseVisitor
    extends JpqlVisitorAdapter<ValueHolder<JpqlGroupBy>> {
        private GroupByClauseVisitor() {
        }

        @Override
        public boolean visit(JpqlGroupBy node, ValueHolder<JpqlGroupBy> data) {
            data.setValue(node);
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OuterJoinWithClauseVisitor
    extends JpqlVisitorAdapter<ValueHolder<Boolean>> {
        private OuterJoinWithClauseVisitor() {
        }

        @Override
        public boolean visit(JpqlOuterJoin node, ValueHolder<Boolean> data) {
            if (SimpleSubselectEvaluator.this.containsWithClause(node)) {
                data.setValue(true);
            }
            return false;
        }

        @Override
        public boolean visit(JpqlOuterFetchJoin node, ValueHolder<Boolean> data) {
            if (SimpleSubselectEvaluator.this.containsWithClause(node)) {
                data.setValue(true);
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WithClauseVisitor
    extends JpqlVisitorAdapter<ValueHolder<JpqlWith>> {
        private WithClauseVisitor() {
        }

        @Override
        public boolean visit(JpqlWith node, ValueHolder<JpqlWith> data) {
            data.setValue(node);
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReplacementVisitor
    extends JpqlVisitorAdapter<Set<Replacement>> {
        private ReplacementVisitor() {
        }

        @Override
        public boolean visit(JpqlEquals node, Set<Replacement> replacements) {
            String child0 = node.jjtGetChild(0).toString();
            String child1 = node.jjtGetChild(1).toString();
            for (Replacement replacement : replacements) {
                Alias alias = replacement.getTypeDefinition().getAlias();
                if (child0.equals(alias.getName()) && !child1.equals(alias.getName())) {
                    replacement.setReplacement(node.jjtGetChild(1));
                    continue;
                }
                if (!child1.equals(alias.getName()) || child0.equals(alias.getName())) continue;
                replacement.setReplacement(node.jjtGetChild(0));
            }
            return false;
        }

        @Override
        public boolean visit(JpqlExists node, Set<Replacement> replacements) {
            return false;
        }

        @Override
        public boolean visit(JpqlInnerJoin node, Set<Replacement> replacements) {
            return this.visitJoin(node, replacements);
        }

        @Override
        public boolean visit(JpqlOuterJoin node, Set<Replacement> replacements) {
            return this.visitJoin(node, replacements);
        }

        public boolean visitJoin(Node node, Set<Replacement> replacements) {
            if (node.jjtGetNumChildren() == 1) {
                throw new IllegalStateException("Subselect join without alias found: " + node);
            }
            for (Replacement replacement : replacements) {
                if (!node.jjtGetChild(1).toString().equals(replacement.getTypeDefinition().getAlias())) continue;
                replacement.setReplacement(node.jjtGetChild(0));
            }
            return false;
        }
    }

    protected class Replacement {
        private TypeDefinition type;
        private Node replacement;

        public Replacement(TypeDefinition type) {
            this.type = type;
        }

        public TypeDefinition getTypeDefinition() {
            return this.type;
        }

        public Node getReplacement() {
            return this.replacement;
        }

        public void setReplacement(Node replacement) {
            this.replacement = replacement;
        }

        public String toString() {
            return this.type + " = " + this.replacement;
        }
    }
}

