/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.jpql.compiler;

import java.util.Collection;
import net.sf.jpasecurity.ExceptionFactory;
import net.sf.jpasecurity.SecureEntity;
import net.sf.jpasecurity.entity.SecureObjectCache;
import net.sf.jpasecurity.jpql.JpqlCompiledStatement;
import net.sf.jpasecurity.jpql.compiler.NotEvaluatableException;
import net.sf.jpasecurity.jpql.compiler.QueryEvaluationParameters;
import net.sf.jpasecurity.jpql.compiler.SimpleSubselectEvaluator;
import net.sf.jpasecurity.jpql.parser.JpqlExists;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectCacheSubselectEvaluator
extends SimpleSubselectEvaluator {
    private final SecureObjectCache objectCache;

    public ObjectCacheSubselectEvaluator(SecureObjectCache objectCache, ExceptionFactory exceptionFactory) {
        super(exceptionFactory);
        if (objectCache == null) {
            throw new IllegalArgumentException("SecureObjectCache may not be null");
        }
        this.objectCache = objectCache;
    }

    @Override
    public Collection<?> evaluate(JpqlCompiledStatement subselect, QueryEvaluationParameters parameters) throws NotEvaluatableException {
        if (!(subselect.getStatement().jjtGetParent() instanceof JpqlExists)) {
            parameters.setResultUndefined();
            throw new NotEvaluatableException("ObjectCacheSubselectEvaluator only can evaluate subselects of an EXISTS");
        }
        Collection<?> result = super.evaluate(subselect, parameters);
        if (result.size() > 0) {
            parameters.setResult(result);
            return result;
        }
        parameters.setResultUndefined();
        throw new NotEvaluatableException();
    }

    @Override
    protected Collection<?> getResult(SimpleSubselectEvaluator.Replacement replacement, QueryEvaluationParameters parameters) throws NotEvaluatableException {
        if (replacement.getReplacement() == null) {
            Collection<?> secureObjects = this.objectCache.getSecureObjects(replacement.getTypeDefinition().getType());
            for (Object secureObject : secureObjects) {
                SecureEntity secureEntity;
                if (!(secureObject instanceof SecureEntity) || (secureEntity = (SecureEntity)secureObject).isInitialized()) continue;
                ((SecureEntity)secureObject).refresh();
            }
            return secureObjects;
        }
        return super.getResult(replacement, parameters);
    }
}

