/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.jpasecurity.AccessManager;
import net.sf.jpasecurity.AccessType;
import net.sf.jpasecurity.ExceptionFactory;
import net.sf.jpasecurity.SecureCollection;
import net.sf.jpasecurity.SecureEntity;
import net.sf.jpasecurity.SecureMap;
import net.sf.jpasecurity.SecureObject;
import net.sf.jpasecurity.configuration.Configuration;
import net.sf.jpasecurity.entity.AbstractSecureCollection;
import net.sf.jpasecurity.entity.DefaultSecureCollection;
import net.sf.jpasecurity.entity.DefaultSecureMap;
import net.sf.jpasecurity.entity.SecureEntityDecorator;
import net.sf.jpasecurity.entity.SecureEntityInterceptor;
import net.sf.jpasecurity.entity.SecureList;
import net.sf.jpasecurity.entity.SecureSet;
import net.sf.jpasecurity.entity.SecureSortedSet;
import net.sf.jpasecurity.mapping.BeanInitializer;
import net.sf.jpasecurity.mapping.ClassMappingInformation;
import net.sf.jpasecurity.mapping.CollectionValuedRelationshipMappingInformation;
import net.sf.jpasecurity.mapping.MappingInformation;
import net.sf.jpasecurity.mapping.PropertyMappingInformation;
import net.sf.jpasecurity.proxy.Decorator;
import net.sf.jpasecurity.proxy.EntityProxy;
import net.sf.jpasecurity.proxy.MethodInterceptor;
import net.sf.jpasecurity.proxy.SecureEntityProxyFactory;
import net.sf.jpasecurity.util.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSecureObjectManager {
    private final MappingInformation mappingInformation;
    private final AccessManager accessManager;
    private final Configuration configuration;
    private final List<Runnable> postFlushOperations = new ArrayList<Runnable>();

    public AbstractSecureObjectManager(MappingInformation mappingInformation, AccessManager accessManager, Configuration configuration) {
        this.mappingInformation = mappingInformation;
        this.accessManager = accessManager;
        this.configuration = configuration;
    }

    protected void addPostFlushOperation(Runnable operation) {
        this.postFlushOperations.add(operation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postFlush() {
        try {
            for (Runnable operation : this.postFlushOperations) {
                operation.run();
            }
        }
        finally {
            this.postFlushOperations.clear();
        }
    }

    public boolean isSecureObject(Object object) {
        return object instanceof SecureObject;
    }

    public <T> T getSecureObject(T object) {
        if (object == null) {
            return null;
        }
        if (object instanceof List) {
            return (T)this.createSecureList((List)object, this, this.accessManager);
        }
        if (object instanceof SortedSet) {
            return (T)this.createSecureSortedSet((SortedSet)object, this, this.accessManager);
        }
        if (object instanceof Set) {
            return (T)this.createSecureSet((Set)object, this, this.accessManager);
        }
        if (object instanceof Collection) {
            return (T)this.createSecureCollection((Collection)object, this, this.accessManager);
        }
        if (object instanceof Map) {
            return (T)this.createSecureMap((Map)object, this, this.accessManager);
        }
        ClassMappingInformation mapping = this.getClassMapping(object.getClass());
        BeanInitializer beanInitializer = this.configuration.getBeanInitializer();
        SecureEntityInterceptor interceptor = new SecureEntityInterceptor(beanInitializer, this, object);
        SecureEntityDecorator decorator = new SecureEntityDecorator(mapping, beanInitializer, this.accessManager, this, object);
        return (T)this.createSecureEntity(mapping.getEntityType(), interceptor, decorator);
    }

    boolean containsUnsecureObject(Object secureObject) {
        if (secureObject == null) {
            return true;
        }
        if (secureObject instanceof EntityProxy) {
            secureObject = ((EntityProxy)secureObject).getEntity();
        }
        return secureObject instanceof SecureObject;
    }

    <T> T getUnsecureObject(T secureObject) {
        if (secureObject == null) {
            return null;
        }
        if (secureObject instanceof EntityProxy) {
            secureObject = ((EntityProxy)secureObject).getEntity();
        }
        if (secureObject instanceof SecureEntity) {
            SecureEntityProxyFactory proxyFactory = this.configuration.getSecureEntityProxyFactory();
            SecureEntityInterceptor secureEntityInterceptor = (SecureEntityInterceptor)proxyFactory.getInterceptor((SecureEntity)secureObject);
            return (T)secureEntityInterceptor.entity;
        }
        if (secureObject instanceof AbstractSecureCollection) {
            return ((AbstractSecureCollection)secureObject).getOriginal();
        }
        if (secureObject instanceof SecureList) {
            return (T)((SecureList)secureObject).getOriginal();
        }
        if (secureObject instanceof DefaultSecureMap) {
            return (T)((DefaultSecureMap)secureObject).getOriginal();
        }
        return this.createUnsecureObject(secureObject);
    }

    abstract <T> T createUnsecureObject(T var1);

    void secureCopy(Object unsecureObject, Object secureObject) {
        ClassMappingInformation classMapping = this.getClassMapping(secureObject.getClass());
        for (PropertyMappingInformation propertyMapping : classMapping.getPropertyMappings()) {
            Object value = propertyMapping.getPropertyValue(unsecureObject);
            if (propertyMapping.isRelationshipMapping()) {
                value = this.getSecureObject(value);
            }
            propertyMapping.setPropertyValue(secureObject, value);
        }
    }

    void unsecureCopy(AccessType accessType, Object secureObject, Object unsecureObject) {
        if (secureObject instanceof SecureObject && !((SecureObject)secureObject).isInitialized()) {
            return;
        }
        boolean modified = false;
        ClassMappingInformation classMapping = this.getClassMapping(secureObject.getClass());
        for (PropertyMappingInformation propertyMapping : classMapping.getPropertyMappings()) {
            Object oldValue;
            if (propertyMapping.isVersionProperty() || propertyMapping.isIdProperty() && propertyMapping.isGeneratedValue()) continue;
            Object secureValue = propertyMapping.getPropertyValue(secureObject);
            if (secureValue instanceof SecureCollection) {
                modified = this.secureCopy(classMapping, propertyMapping, accessType, secureObject, unsecureObject, (SecureCollection)secureValue, modified);
                continue;
            }
            if (secureValue instanceof SecureMap) {
                modified = this.secureCopy(classMapping, propertyMapping, accessType, secureObject, unsecureObject, (SecureMap)secureValue, modified);
                continue;
            }
            Object newValue = secureValue instanceof Collection ? this.createUnsecureCollection((Collection)secureValue) : (secureValue instanceof Map ? this.createUnsecureMap((Map)secureValue) : (propertyMapping.isRelationshipMapping() ? this.getUnsecureObject(secureValue) : secureValue));
            if (!this.isDirty(propertyMapping, newValue, oldValue = propertyMapping.getPropertyValue(unsecureObject))) continue;
            if (!modified) {
                this.checkAccess(accessType, secureObject);
                this.fireLifecycleEvent(accessType, classMapping, secureObject);
            }
            propertyMapping.setPropertyValue(unsecureObject, newValue);
            modified = true;
        }
    }

    private <K, V> Map<K, V> createUnsecureMap(Map<K, V> secureValue) {
        HashMap<K, V> unsecureMap = new HashMap<K, V>();
        for (Map.Entry<K, V> entry : secureValue.entrySet()) {
            K key = entry.getKey();
            if (!Types.isSimplePropertyType(key.getClass())) {
                key = this.getUnsecureObject(key);
            }
            unsecureMap.put(key, this.getUnsecureObject(entry.getValue()));
        }
        return unsecureMap;
    }

    private <E, T extends List<E>> SecureList<E> createSecureList(T list, AbstractSecureObjectManager objectManager, AccessManager accessManager) {
        return new SecureList(list, objectManager, accessManager);
    }

    private <E, T extends SortedSet<E>> SecureSortedSet<E> createSecureSortedSet(T sortedSet, AbstractSecureObjectManager manager, AccessManager accessManager) {
        return new SecureSortedSet(sortedSet, manager, accessManager);
    }

    private <E, T extends Set<E>> SecureSet<E> createSecureSet(T set, AbstractSecureObjectManager objectManager, AccessManager accessManager) {
        return new SecureSet(set, objectManager, accessManager);
    }

    private <E, T extends Collection<E>> SecureCollection<E> createSecureCollection(T collection, AbstractSecureObjectManager mgr, AccessManager accessManager) {
        return new DefaultSecureCollection(collection, mgr, accessManager);
    }

    private <K, V> SecureMap<K, V> createSecureMap(Map<K, V> original, AbstractSecureObjectManager objectManager, AccessManager accessManager) {
        return new DefaultSecureMap<K, V>(original, objectManager, accessManager);
    }

    private <T> Collection<T> createUnsecureCollection(Collection<T> secureValue) {
        Collection<T> unsecureCollection = this.createCollection(secureValue);
        for (T entry : secureValue) {
            unsecureCollection.add(this.getUnsecureObject(entry));
        }
        return unsecureCollection;
    }

    <V> boolean secureCopy(ClassMappingInformation classMapping, PropertyMappingInformation propertyMapping, AccessType accessType, Object secureOwner, Object unsecureOwner, SecureCollection<V> secureValue, boolean modified) {
        Collection unsecureCollection = this.getUnsecureObject(secureValue);
        SecureCollection<V> secureCollection = (SecureCollection<V>)this.getSecureObject(unsecureCollection);
        if (secureValue != secureCollection && secureValue.isDirty()) {
            secureCollection = secureValue.merge(secureCollection);
        }
        if (secureCollection.isDirty()) {
            if (!modified) {
                this.checkAccess(accessType, secureOwner);
                this.fireLifecycleEvent(accessType, classMapping, secureOwner);
            }
            if (accessType == AccessType.UPDATE) {
                if (secureCollection instanceof AbstractSecureCollection) {
                    ((AbstractSecureCollection)secureCollection).flush();
                } else if (secureCollection instanceof SecureList) {
                    ((SecureList)secureCollection).flush();
                } else {
                    throw new IllegalStateException("unsupported secure collection type: " + secureCollection.getClass());
                }
            }
            modified = true;
        }
        if (secureCollection != secureValue) {
            propertyMapping.setPropertyValue(unsecureOwner, this.getUnsecureObject(secureCollection));
        }
        return modified;
    }

    <K, V> boolean secureCopy(ClassMappingInformation classMapping, PropertyMappingInformation propertyMapping, AccessType accessType, Object secureOwner, Object unsecureOwner, SecureMap<K, V> secureValue, boolean modified) {
        Map unsecureMap = this.getUnsecureObject(secureValue);
        SecureMap<K, V> secureMap = (SecureMap<K, V>)this.getSecureObject(unsecureMap);
        if (secureValue != secureMap && secureValue.isDirty()) {
            secureMap = secureValue.merge(secureMap);
        }
        if (secureMap.isDirty()) {
            if (!modified) {
                this.checkAccess(accessType, secureOwner);
                this.fireLifecycleEvent(accessType, classMapping, secureOwner);
            }
            if (accessType == AccessType.UPDATE) {
                if (secureMap instanceof DefaultSecureMap) {
                    ((DefaultSecureMap)secureMap).flush();
                } else {
                    throw new IllegalStateException("unsupported secure map type: " + secureMap.getClass());
                }
            }
            modified = true;
        }
        if (secureMap != secureValue) {
            propertyMapping.setPropertyValue(unsecureOwner, this.getUnsecureObject(secureMap));
        }
        return modified;
    }

    void copyIdAndVersion(Object unsecureObject, Object secureObject) {
        if (secureObject instanceof EntityProxy) {
            secureObject = ((EntityProxy)secureObject).getEntity();
        }
        if (secureObject instanceof SecureObject && !((SecureObject)secureObject).isInitialized()) {
            return;
        }
        ClassMappingInformation classMapping = this.getClassMapping(secureObject.getClass());
        for (PropertyMappingInformation propertyMapping : classMapping.getIdPropertyMappings()) {
            Object newId = propertyMapping.getPropertyValue(unsecureObject);
            if (propertyMapping.isRelationshipMapping()) {
                newId = this.getSecureObject(newId);
            }
            propertyMapping.setPropertyValue(secureObject, newId);
        }
        for (PropertyMappingInformation propertyMapping : classMapping.getVersionPropertyMappings()) {
            Object newVersion = propertyMapping.getPropertyValue(unsecureObject);
            propertyMapping.setPropertyValue(secureObject, newVersion);
        }
    }

    boolean isDirty(Object newEntity, Object oldEntity) {
        ClassMappingInformation classMapping = this.getClassMapping(newEntity.getClass());
        for (PropertyMappingInformation propertyMapping : classMapping.getPropertyMappings()) {
            Object oldValue;
            Object newValue;
            if (propertyMapping.isIdProperty() || propertyMapping.isVersionProperty() || !this.isDirty(propertyMapping, newValue = propertyMapping.getPropertyValue(newEntity), oldValue = propertyMapping.getPropertyValue(oldEntity))) continue;
            return true;
        }
        return false;
    }

    boolean isDirty(PropertyMappingInformation propertyMapping, Object newValue, Object oldValue) {
        if (newValue == oldValue) {
            return false;
        }
        if (!propertyMapping.isRelationshipMapping()) {
            return !this.nullSaveEquals(newValue, oldValue);
        }
        if (propertyMapping.isSingleValued()) {
            return true;
        }
        CollectionValuedRelationshipMappingInformation relationshipMapping = (CollectionValuedRelationshipMappingInformation)propertyMapping;
        if (Collection.class.isAssignableFrom(relationshipMapping.getCollectionType())) {
            Collection oldCollection = (Collection)oldValue;
            Collection newCollection = (Collection)newValue;
            return oldCollection == null || newCollection == null || oldCollection.size() != newCollection.size() || !oldCollection.containsAll(newCollection) || !newCollection.containsAll(oldCollection);
        }
        if (Map.class.isAssignableFrom(relationshipMapping.getCollectionType())) {
            Map oldMap = (Map)oldValue;
            Map newMap = (Map)newValue;
            return oldMap == null || newMap == null || oldMap.size() != newMap.size() || !oldMap.entrySet().containsAll(newMap.entrySet()) || !newMap.entrySet().containsAll(oldMap.entrySet());
        }
        ExceptionFactory exceptionFactory = this.configuration.getExceptionFactory();
        throw exceptionFactory.createTypeNotFoundException(relationshipMapping.getCollectionType());
    }

    ClassMappingInformation getClassMapping(Class<?> type) {
        return this.mappingInformation.getClassMapping(type);
    }

    boolean isAccessible(AccessType accessType, Object entity) {
        return this.accessManager.isAccessible(accessType, entity);
    }

    void checkAccess(AccessType accessType, Object entity) {
        if (!this.accessManager.isAccessible(accessType, entity)) {
            throw new SecurityException("The current user is not permitted to " + accessType.toString().toLowerCase() + " the specified object of type " + this.getClassMapping(entity.getClass()).getEntityType().getName());
        }
    }

    void fireLifecycleEvent(AccessType accessType, ClassMappingInformation classMapping, Object entity) {
        switch (accessType) {
            case CREATE: {
                this.firePersist(classMapping, entity);
                break;
            }
            case UPDATE: {
                this.fireUpdate(classMapping, entity);
                break;
            }
            case DELETE: {
                this.fireRemove(classMapping, entity);
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported accessType " + (Object)((Object)accessType));
            }
        }
    }

    void firePersist(final ClassMappingInformation classMapping, final Object entity) {
        classMapping.prePersist(entity);
        this.addPostFlushOperation(new Runnable(){

            public void run() {
                classMapping.postPersist(entity);
            }
        });
    }

    void fireUpdate(final ClassMappingInformation classMapping, final Object entity) {
        classMapping.preUpdate(entity);
        this.addPostFlushOperation(new Runnable(){

            public void run() {
                classMapping.postUpdate(entity);
            }
        });
    }

    void fireRemove(final ClassMappingInformation classMapping, final Object entity) {
        classMapping.preRemove(entity);
        this.addPostFlushOperation(new Runnable(){

            public void run() {
                classMapping.postRemove(entity);
            }
        });
    }

    <E> E createSecureEntity(Class<E> type, MethodInterceptor interceptor, Decorator<SecureEntity> decorator) {
        return (E)this.configuration.getSecureEntityProxyFactory().createSecureEntityProxy(type, interceptor, decorator);
    }

    void setRemoved(SecureEntity secureEntity) {
        SecureEntityDecorator secureEntityDecorator = (SecureEntityDecorator)this.configuration.getSecureEntityProxyFactory().getDecorator(secureEntity);
        secureEntityDecorator.deleted = true;
    }

    void initialize(SecureEntity secureEntity, boolean checkAccess) {
        SecureEntityDecorator secureEntityDecorator = (SecureEntityDecorator)this.configuration.getSecureEntityProxyFactory().getDecorator(secureEntity);
        secureEntityDecorator.refresh(checkAccess);
    }

    private <T> Collection<T> createCollection(Collection<T> original) {
        if (original instanceof SortedSet) {
            return new TreeSet(((SortedSet)original).comparator());
        }
        if (original instanceof Set) {
            return new LinkedHashSet();
        }
        return new ArrayList();
    }

    private boolean nullSaveEquals(Object object1, Object object2) {
        if (object1 == object2) {
            return true;
        }
        if (object1 == null) {
            return false;
        }
        return object1.equals(object2);
    }
}

