/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.validation;

import com.clustercontrol.commons.util.CommonValidator;
import com.clustercontrol.fault.InvalidSetting;
import com.clustercontrol.util.Messages;

public class CommonValidatorEx extends CommonValidator {
	/**
	 * 数値の上限下限チェック
	 * @throws InvalidSetting
	 */
	public static void validateLong(String name, long i, long minSize, long maxSize) throws InvalidSetting {
		if (i < minSize || maxSize < i) {
			Object[] args = {name, Long.toString(minSize), Long.toString(maxSize)};
			throw new InvalidSetting(Messages.getString("message.common.4", args));
		}
	}
}
