/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.cloudn.rest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;

import com.clustercontrol.cloud.cloudn.rest.api.MarshalParam;
import com.clustercontrol.cloud.cloudn.rest.api.TagParamMarshaller;
import com.google.common.base.Preconditions;

@NonNullByDefault(false)
@MarshalParam
public class CreateTagsRequest extends RestApplicationRequest {
	public String resourceids;
	public String resourcetype; // 仮想マシン：UserVm　追加ディスク：Volume　テンプレート：Template スナップショット：Snapshot
	@MarshalParam(TagParamMarshaller.class)
	public List<RTag> tags = new ArrayList<>();

	public CreateTagsRequest withResourceids(@NonNull String resourceids) {
		Preconditions.checkNotNull(resourceids);
		this.resourceids = resourceids;
		return this;
	}
	public CreateTagsRequest withResourcetype(@NonNull String resourcetype) {
		Preconditions.checkNotNull(resourcetype);
		this.resourcetype = resourcetype;
		return this;
	}
	public CreateTagsRequest withTag(@NonNull RTag tag) {
		this.tags.add(tag);
		return this;
	}
	public CreateTagsRequest withTags(@NonNull RTag...tags) {
		withTags(Arrays.asList(tags));
		return this;
	}
	public CreateTagsRequest withTags(@NonNull List<RTag> tags) {
		this.tags.addAll(tags);
		return this;
	}
}
