/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.cloudn;

import org.apache.log4j.Logger;
import org.eclipse.jdt.annotation.Nullable;

import com.clustercontrol.cloud.commons.PropValidator;
import com.clustercontrol.cloud.commons.PropertyContract;
import com.clustercontrol.commons.util.HinemosProperties;

public enum CloudnOptionPropertyConstants implements PropertyContract {
	
	cloudn_node_ip("hinemos.cloud.cloudn.node.ip", qrivate, new PropValidator.StringValidator(qublic, qrivate)),
	
	// cloudn_node_ip が、private の時に有効
	cloudn_private_cidr("hinemos.cloud.cloudn.private.cidr", "0.0.0.0/0"),
	
	cloudn_os_win_pattern("hinemos.cloud.cloudn.os.win.pattern", "(.*windows.*)|(.*win.*)|(.*microsoft.*)"),
	cloudn_os_linux_pattern("hinemos.cloud.cloudn.os.linux.pattern", "(.*linux.*)|(.*cent\\s*os.*)|(.*ubuntu.*)"),
	
	// FLAT版でインスタンスバックアップを行う際、Cloudnテンプレートの作成に時間が掛かる間にクラウド管理オプション上のDB情報を消さないための待ち時間 デフォルト1時間
	cloudn_flat_until_template_created("hinemos.cloud.cloudn.flat.untilTemplateCreated", String.valueOf(1000*60*60), PropValidator.intValidator),
	
	cloudn_client_config_proxyHost("hinemos.cloud.cloudn.client.config.proxyHost", null),
	cloudn_client_config_proxyPassword("hinemos.cloud.cloudn.client.config.proxyPassword", null),
	cloudn_client_config_proxyPort("hinemos.cloud.cloudn.client.config.proxyPort", String.valueOf(-1), PropValidator.intValidator),
	cloudn_client_config_proxyUsername("hinemos.cloud.cloudn.client.config.proxyUsername", null),
	
//	aws_client_config_connectionTimeout("hinemos.cloud.aws.client.config.connectionTimeout", String.valueOf(50 * 1000), PropValidator.intValidator),
//	aws_client_config_maxConnections("hinemos.cloud.aws.client.config.maxConnections", String.valueOf(50), PropValidator.intValidator),
//	aws_client_config_maxErrorRetry("hinemos.cloud.aws.client.config.maxErrorRetry", String.valueOf(3), PropValidator.intValidator),
//	aws_client_config_protocol("hinemos.cloud.aws.client.config.protocol", "https"),
//	aws_client_config_proxyDomain("hinemos.cloud.aws.client.config.proxyDomain", null),
//	aws_client_config_proxyHost("hinemos.cloud.aws.client.config.proxyHost", null),
//	aws_client_config_proxyPassword("hinemos.cloud.aws.client.config.proxyPassword", null),
//	aws_client_config_proxyPort("hinemos.cloud.aws.client.config.proxyPort", String.valueOf(-1), PropValidator.intValidator),
//	aws_client_config_proxyUsername("hinemos.cloud.aws.client.config.proxyUsername", null),
//	aws_client_config_proxyWorkstation("hinemos.cloud.aws.client.config.proxyWorkstation", null),
//	aws_client_config_socketTimeout("hinemos.cloud.aws.client.config.socketTimeout", String.valueOf(50 * 1000), PropValidator.intValidator),
//	aws_client_config_userAgent("hinemos.cloud.aws.client.config.userAgent", "");
	;
	
	private PropValidator nullvalidator = new PropValidator() {
		@Override
		public void validate(@Nullable String value) throws Exception {
		}
	};
	
	
	public final String id;
	public final String defaultValue;
	public final PropValidator validator;

	private CloudnOptionPropertyConstants(String id, @Nullable String defaultValue) {
		this.id = id;
		this.defaultValue = defaultValue == null ? "": defaultValue;
		this.validator = nullvalidator;
	}

	private CloudnOptionPropertyConstants(String id, @Nullable String defaultValue, PropValidator validator) {
		this.id = id;
		this.defaultValue = defaultValue == null ? "": defaultValue;
		this.validator = validator;
	}
	
	public String value() {
		String prop = HinemosProperties.getProperty(id, defaultValue);
		try {
			validator.validate(prop);
		}
		catch (Exception e) {
			Logger logger = Logger.getLogger(CloudnOptionPropertyConstants.class);
			logger.error(id + " is invalid("+ prop +"), using default value(" + defaultValue + ").");
			prop = defaultValue;
		}
		return prop;
	}

	public boolean match(@Nullable String value) {
		return value().equals(value);
	}

	public String defaultValue() {
		return this.defaultValue;
	}
}
