/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.validation;

import java.lang.reflect.Method;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.HinemosCredential;
import com.clustercontrol.cloud.ICloudContext;
import com.clustercontrol.cloud.IMessagesHolder;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.bean.CloudAccountResource;
import com.clustercontrol.cloud.bean.CloudRegion;
import com.clustercontrol.cloud.bean.CloudService;
import com.clustercontrol.cloud.bean.CloudUser;
import com.clustercontrol.cloud.factory.IAccountResourceOperator;
import com.clustercontrol.cloud.factory.ICloudServiceOperator;
import com.clustercontrol.cloud.factory.ICloudUserOperator;
import com.clustercontrol.cloud.registry.ObjectRegistryService;
import com.clustercontrol.cloud.util.AccessDestination;
import com.clustercontrol.cloud.util.CloudContext;
import com.clustercontrol.cloud.validation.MethodValidator.MethodValidationContext;
import com.clustercontrol.commons.util.HinemosSessionContext;

public class AuthorizingValidator_role_region implements CustomMethodValidator {
	@Override
	public void validate(Method method, Object[] params, String group, IMessagesHolder messages, MethodValidationContext context) throws ValidationFault {
		assert params.length >= 2 && params[0].getClass() == String.class && params[1].getClass() == String.class;
//		Object userId = null;
//		Object region = null;
//		
//		Annotation[][] eachs = method.getParameterAnnotations();
//		loop:
//		for (int i = 0; i < eachs.length; ++i) {
//			for (Annotation each: eachs[i]) {
//				if (CloudUserId.class.isInstance(each)) {
//					userId = params[i];
//				}
//				else if (Region.class.isInstance(each)) {
//					region = params[i];
//				}
//				if (userId != null && region != null) {
//					break loop;
//				}
//			}
//		}

		try {
			String roleId = (String)params[0];
			String region = (String)params[1];

			HinemosCredential credential = SessionService.current().getHinemosCredential();

			ICloudUserOperator userOperator = ObjectRegistryService.registry().get(ICloudUserOperator.class);
			CloudUser cloudUser = null;
			if (
				Boolean.TRUE.equals(HinemosSessionContext.instance().getProperty(HinemosSessionContext.IS_ADMINISTRATOR))
				) {
				cloudUser = userOperator.findCloudUserByRoleId(roleId);
			}
			else {
				cloudUser = userOperator.findCloudUserByUserIdAndRoleId(credential.getUserId(), roleId);
			}

			IAccountResourceOperator operator = ObjectRegistryService.registry().get(IAccountResourceOperator.class);
			CloudAccountResource accountResource = operator.findCloudAccountResource(cloudUser.getAccountResourceId());

			ICloudServiceOperator serviceOperator = ObjectRegistryService.registry().get(ICloudServiceOperator.class);
			CloudService cloudService = serviceOperator.findCloudService(accountResource.getCloudServiceId());
			CloudRegion cloudRegion = serviceOperator.findCloudRegion(accountResource.getCloudServiceId(), region);

			SessionService.current().set(ICloudContext.class, new CloudContext(new AccessDestination(cloudUser, cloudService, accountResource), cloudRegion));
		}
		catch (CloudManagerFault e) {
			throw new ValidationFault(e);
		}
	}
}