/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.bean;

import java.util.Map;

import com.clustercontrol.cloud.validation.annotation.ElementId;
import com.clustercontrol.cloud.validation.annotation.IntRange;
import com.clustercontrol.cloud.validation.annotation.Size;

/**
 * ストレージ作成情報を保持するクラス。 
 * {@link com.clustercontrol.ws.cloud.CloudEndpoint#addStorage(String,String,CreateStorageRequest) addStorage 関数}、
 * {@link com.clustercontrol.ws.cloud.CloudEndpoint#restoreStorage(String,StringCreateStorageRequest) restoreStorage 関数} にて使用される。
 *
 */
public class CreateStorageRequest extends CloudRequest {
	public CreateStorageRequest() {
		super();
	}
	
	public CreateStorageRequest(String storageName, Integer storageSize, String snapshotId,
			String zone, String storageDetail, String flavor, Map<String, String> options) {
		super(options);
		this.storageName = storageName;
		this.storageSize = storageSize;
		this.snapshotId = snapshotId;
		this.zone = zone;
		this.storageDetail = storageDetail;
		this.flavor = flavor;
	}
	private String storageName;
	private Integer storageSize;
	private String snapshotId;
	private String zone;
	private String storageDetail;
	private String flavor;
	
	/**
	 * ストレージ名を取得します。
	 * 
	 * @return ストレージ名。
	 */
	@ElementId("storageName")
	@Size(max = 128)
	public String getStorageName() {
		return storageName;
	}
	/**
	 * ストレージ名を指定します。
	 * 作成時には128 字以内の文字列を指定する必要があります。リストア時には、null を指定した場合、バックアップ時の値が使用されます。
	 * 
	 * @param storageName　ストレージ名。
	 */
	public void setStorageName(String storageName) {
		this.storageName = storageName;
	}
	/**
	 * ストレージサイズを取得します。
	 * 
	 * @return ストレージサイズ。
	 */
	@ElementId("storageSize")
	@IntRange(min=0)
	public Integer getStorageSize() {
		return storageSize;
	}
	/**
	 * ストレージサイズを指定します。リストア時には、null を指定した場合、バックアップ時の値が使用されます。
	 * 
	 * @param storageSize ストレージサイズ。
	 */
	public void setStorageSize(Integer storageSize) {
		this.storageSize = storageSize;
	}
	/**
	 * スナップショット ID を取得します。
	 * 
	 * @return スナップショット ID。
	 */
	public String getSnapshotId() {
		return snapshotId;
	}
	/**
	 * スナップショット ID を指定します。
	 * 
	 * @param snapshotId スナップショットID。
	 */
	public void setSnapshotId(String snapshotId) {
		this.snapshotId = snapshotId;
	}
	
	/**
	 * @return
	 */
	public String getZone() {
		return zone;
	}
	/**
	 * @param zone
	 */
	public void setZone(String zone) {
		this.zone = zone;
	}
	
	/**
	 * @return
	 */
	public String getStorageDetail() {
		return storageDetail;
	}
	/**
	 * @param storageDetail
	 */
	public void setStorageDetail(String storageDetail) {
		this.storageDetail = storageDetail;
	}

	/**
	 * @return
	 */
	public String getFlavor() {
		return flavor;
	}
	/**
	 * @param flavor
	 */
	public void setFlavor(String flavor) {
		this.flavor = flavor;
	}
}
