/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.bean;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlTransient;

import com.clustercontrol.cloud.dao.CloudTypeDao;

/**
 * クラウドタイプの情報を保持するクラス。
 *
 */
public class CloudType implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = -2147835401052595306L;

	private CloudTypeDao data;

	public CloudType() {
		super();
		this.data = new CloudTypeDao();
	}

	public CloudType(CloudTypeDao tableData) {
		super();
		this.data = new CloudTypeDao(tableData);
	}
	/**
	 * クラウドタイプ ID を取得する。
	 * 
	 * @return
	 */
	public String getCloudId() {
		return data.getId();
	}

	/**
	 * @param cloudId
	 */
	public void setCloudId(String cloudId) {
		throw new UnsupportedOperationException();
	}
	/**
	 * @return
	 */
	public String getCloudName() {
		return data.getName();
	}

	/**
	 * @param cloudName
	 */
	public void setCloudName(String cloudName) {
		throw new UnsupportedOperationException();
	}
	/**
	 * @return
	 */
	public String getDescription() {
		return data.getDescription();
	}

	/**
	 * @param description
	 */
	public void setDescription(String description) {
		throw new UnsupportedOperationException();
	}
	@XmlTransient
	public CloudTypeDao getTableData() {
		return data;
	}
}